/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.agent.source.tail;

import com.appdynamics.analytics.agent.input.tail.FileInfo;
import com.appdynamics.analytics.agent.input.tail.FileSignature;
import com.appdynamics.analytics.agent.source.tail.NativePlatform;
import com.appdynamics.analytics.agent.source.tail.NativePlatformFactory;
import com.appdynamics.common.io.IoHelper;
import com.appdynamics.common.io.file.FilePathConfiguration;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryPoller {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DirectoryPoller.class);
    private static final String DIRECTORY_SPLIT_CHAR = "/";
    private static final String DOUBLE_WILDCARD_CHAR = "**";
    private static final String WILDCARD_CHAR = "*";
    private final Path rootPath;
    private final PathMatcher matcher;
    private final ConcurrentMap<String, FileInfo> filePathInfoMap;
    private final String globPattern;
    private final List<String> blacklistGlob;
    private final List<PathMatcher> blacklistMatcher;
    private final int dirWalkMaxDepth;
    private final boolean recursiveDirSearch;
    private FilePathConfiguration currentPathConfig;
    private boolean firstTimePoll;
    private NativePlatform nativePlatform;

    public DirectoryPoller(FilePathConfiguration sourcePath, boolean includeCompressedGzips) {
        String glob;
        int extPosition;
        this.globPattern = includeCompressedGzips ? ((extPosition = (glob = IoHelper.getGlobPatternFromPathGlob((FilePathConfiguration)sourcePath)).lastIndexOf(".")) != -1 ? String.format("%s{,.gz}", glob) : glob) : IoHelper.getGlobPatternFromPathGlob((FilePathConfiguration)sourcePath);
        int doubleWildcardIndex = this.globPattern.indexOf(DOUBLE_WILDCARD_CHAR);
        boolean bl = this.recursiveDirSearch = doubleWildcardIndex >= 0;
        if (!this.recursiveDirSearch) {
            this.currentPathConfig = this.getStartingPathGlobConfig(this.globPattern);
        }
        this.blacklistGlob = sourcePath.getBlacklistGlob();
        this.blacklistMatcher = new ArrayList<PathMatcher>();
        this.matcher = FileSystems.getDefault().getPathMatcher(this.globPattern);
        if (this.blacklistGlob != null) {
            for (String blg : this.blacklistGlob) {
                String blPattern = IoHelper.getGlobPatternFromPathGlob((String)sourcePath.getPath(), (String)blg);
                this.blacklistMatcher.add(FileSystems.getDefault().getPathMatcher(blPattern));
            }
        }
        this.rootPath = Paths.get(sourcePath.getPath(), new String[0]);
        log.debug("Initializing Directory [{}] with matcherPath [{}]", (Object)this.rootPath, (Object)this.globPattern);
        if (!Files.exists(this.rootPath, new LinkOption[0])) {
            log.error("The specified path [{}] does not exist, we will skip scan", (Object)this.rootPath.toString());
        }
        this.filePathInfoMap = new ConcurrentHashMap<String, FileInfo>();
        this.dirWalkMaxDepth = IoHelper.checkRecursiveDirSearch((String)this.globPattern, (boolean)SystemUtils.IS_OS_WINDOWS) ? Integer.MAX_VALUE : 1;
        this.firstTimePoll = true;
        this.nativePlatform = NativePlatformFactory.create();
    }

    private FilePathConfiguration getStartingPathGlobConfig(String globPattern) {
        int endIndex;
        FilePathConfiguration pathConfiguration = new FilePathConfiguration();
        pathConfiguration.setPath(globPattern);
        int indexOfWildcard = globPattern.indexOf(WILDCARD_CHAR);
        if (indexOfWildcard >= 0) {
            pathConfiguration.setPath(globPattern.substring(0, indexOfWildcard));
        }
        if ((endIndex = pathConfiguration.getPath().lastIndexOf(DIRECTORY_SPLIT_CHAR)) > 0) {
            pathConfiguration.setNameGlob(globPattern.substring(endIndex + 1));
            pathConfiguration.setPath(globPattern.substring(0, endIndex + 1));
        } else {
            pathConfiguration.setNameGlob("");
        }
        return pathConfiguration;
    }

    public void clearFileCacheWithFileSignature(String fileSignature) {
        for (Map.Entry fileInfoKV : this.filePathInfoMap.entrySet()) {
            try {
                FileSignature cachedFileSignature = ((FileInfo)fileInfoKV.getValue()).getFileSignature();
                if (cachedFileSignature == null || !fileSignature.equals(cachedFileSignature.getSignature())) continue;
                this.filePathInfoMap.remove(fileInfoKV.getKey());
            }
            catch (IOException e) {
                log.error("Failed to retrieve signature for file [" + (String)fileInfoKV.getKey() + "]", (Throwable)e);
            }
        }
    }

    public FileInfo[] getFiles() {
        return this.getFiles(false);
    }

    public FileInfo[] getFiles(final boolean doHardCheck) {
        final ArrayList files = new ArrayList();
        try {
            if (log.isDebugEnabled() || this.firstTimePoll) {
                log.info("Starting directory scan of [{}] with walk depth of [{}]", (Object)this.globPattern, (Object)this.dirWalkMaxDepth);
            }
            if (Files.exists(this.rootPath, new LinkOption[0])) {
                if (log.isDebugEnabled()) {
                    log.debug("File exist in the rootPath [{}]", (Object)this.rootPath);
                }
                Files.walkFileTree(this.rootPath, EnumSet.of(FileVisitOption.FOLLOW_LINKS), this.dirWalkMaxDepth, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){
                    static final int FILES_SCANNED_WARN_THRESHOLD = 1000;
                    private int fileCount = 0;

                    @Override
                    public FileVisitResult preVisitDirectory(Path filePath, BasicFileAttributes attr) {
                        if (DirectoryPoller.this.recursiveDirSearch || DirectoryPoller.this.dirWalkMaxDepth == 1 || filePath.equals(DirectoryPoller.this.rootPath)) {
                            return FileVisitResult.CONTINUE;
                        }
                        try {
                            int index = DirectoryPoller.this.currentPathConfig.getNameGlob().indexOf(DirectoryPoller.DIRECTORY_SPLIT_CHAR);
                            if (index >= 0) {
                                PathMatcher matcher;
                                this.leftShiftPath(index);
                                if (log.isDebugEnabled() && DirectoryPoller.this.firstTimePoll) {
                                    log.debug("Current directory [{}], Current path glob pattern [{}], Current file glob pattern [{}]", new Object[]{filePath, DirectoryPoller.this.currentPathConfig.getPath(), DirectoryPoller.this.currentPathConfig.getNameGlob()});
                                }
                                if ((matcher = FileSystems.getDefault().getPathMatcher(DirectoryPoller.this.currentPathConfig.getPath().substring(0, DirectoryPoller.this.currentPathConfig.getPath().length() - 1))).matches(filePath)) {
                                    return FileVisitResult.CONTINUE;
                                }
                                index = DirectoryPoller.this.currentPathConfig.getPath().substring(0, DirectoryPoller.this.currentPathConfig.getPath().length() - 1).lastIndexOf(DirectoryPoller.DIRECTORY_SPLIT_CHAR);
                                if (index >= 0) {
                                    this.rightShiftPath(index);
                                }
                                return FileVisitResult.SKIP_SUBTREE;
                            }
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                        catch (Exception e) {
                            if (log.isDebugEnabled()) {
                                log.debug("Error while left shifting glob config [{}]", (Object)e.getMessage());
                            }
                            return FileVisitResult.CONTINUE;
                        }
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path filePath, IOException exc) throws IOException {
                        block4: {
                            if (DirectoryPoller.this.recursiveDirSearch || DirectoryPoller.this.dirWalkMaxDepth == 1 || filePath.equals(DirectoryPoller.this.rootPath)) {
                                return FileVisitResult.CONTINUE;
                            }
                            try {
                                int index = DirectoryPoller.this.currentPathConfig.getPath().substring(0, DirectoryPoller.this.currentPathConfig.getPath().length() - 1).lastIndexOf(DirectoryPoller.DIRECTORY_SPLIT_CHAR);
                                if (index >= 0) {
                                    this.rightShiftPath(index);
                                }
                            }
                            catch (Exception e) {
                                if (!log.isDebugEnabled()) break block4;
                                log.debug("Error while right shifting glob config [{}]", (Object)e.getMessage());
                            }
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    private void leftShiftPath(int index) {
                        String currentPathGlob = DirectoryPoller.this.currentPathConfig.getNameGlob().substring(0, index + 1);
                        DirectoryPoller.this.currentPathConfig.setNameGlob(DirectoryPoller.this.currentPathConfig.getNameGlob().substring(index + 1, DirectoryPoller.this.currentPathConfig.getNameGlob().length()));
                        DirectoryPoller.this.currentPathConfig.setPath(DirectoryPoller.this.currentPathConfig.getPath() + currentPathGlob);
                    }

                    private void rightShiftPath(int index) {
                        String currentPathGlob = DirectoryPoller.this.currentPathConfig.getPath().substring(index + 1);
                        DirectoryPoller.this.currentPathConfig.setNameGlob(currentPathGlob + DirectoryPoller.this.currentPathConfig.getNameGlob());
                        DirectoryPoller.this.currentPathConfig.setPath(DirectoryPoller.this.currentPathConfig.getPath().substring(0, DirectoryPoller.this.currentPathConfig.getPath().length() - currentPathGlob.length()));
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path file, IOException ioExcept) throws IOException {
                        if (log.isDebugEnabled() || DirectoryPoller.this.firstTimePoll) {
                            log.info("Skipping file [{}] because of IO exception [{}]", (Object)file, (Object)ioExcept);
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path filePath, BasicFileAttributes attr) throws IOException {
                        String fullPath;
                        if (log.isDebugEnabled()) {
                            log.debug("Visiting file name - [{}] , File attributes - lastModifiedTime [{}], lastAccessTime [{}], creationTime [{}], isRegularFile [{}], isDirectory [{}], isSymbolicLink [{}], isOther [{}], size [{}], fileKey [{}] ", new Object[]{filePath.toAbsolutePath().toString(), attr.lastModifiedTime(), attr.lastAccessTime(), attr.creationTime(), attr.isRegularFile(), attr.isDirectory(), attr.isSymbolicLink(), attr.isOther(), attr.size(), attr.fileKey()});
                        }
                        boolean matches = DirectoryPoller.this.matcher.matches(filePath);
                        if (DirectoryPoller.this.firstTimePoll) {
                            if (this.fileCount == 1000) {
                                log.warn("[{}] files scanned for a single directory, please consider more specific directory path rules, directory = [{}]", (Object)1000, (Object)DirectoryPoller.this.rootPath.toString());
                            } else {
                                ++this.fileCount;
                            }
                        }
                        String string = fullPath = IoHelper.isDefaultFileSystemCaseSensitive() ? filePath.toAbsolutePath().toString() : filePath.toAbsolutePath().toString().toLowerCase();
                        if (attr.isRegularFile()) {
                            if (doHardCheck || attr.size() > 0L) {
                                if (log.isDebugEnabled()) {
                                    log.debug("Found file [{}] checking if matches with glob [{}], match result: [{}]", new Object[]{fullPath, DirectoryPoller.this.globPattern, matches});
                                }
                                if (matches) {
                                    boolean isBLMatches = false;
                                    if (DirectoryPoller.this.blacklistGlob != null) {
                                        PathMatcher blm;
                                        Iterator<PathMatcher> iterator = DirectoryPoller.this.blacklistMatcher.iterator();
                                        while (iterator.hasNext() && !(isBLMatches = (blm = iterator.next()).matches(filePath))) {
                                        }
                                    }
                                    if (isBLMatches) {
                                        if (log.isDebugEnabled() || DirectoryPoller.this.firstTimePoll) {
                                            log.info("Skipping file [{}] because it match the black list mask pattern.", (Object)fullPath);
                                        }
                                    } else {
                                        DirectoryPoller.this.updateFileInfo(fullPath, attr, doHardCheck, files);
                                    }
                                } else if (log.isDebugEnabled() || DirectoryPoller.this.firstTimePoll) {
                                    log.info("Skipping file [{}] because it doesn't match the file mask pattern.", (Object)fullPath);
                                }
                            } else if (log.isDebugEnabled() || DirectoryPoller.this.firstTimePoll) {
                                log.info("Skipping file [{}] because it's an empty file.", (Object)fullPath);
                            }
                        } else if (log.isDebugEnabled() || DirectoryPoller.this.firstTimePoll) {
                            log.info("Found directory [{}], skipping.", (Object)fullPath);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            } else if (log.isDebugEnabled()) {
                log.debug("File does exist in the rootPath [{}]", (Object)this.rootPath);
            }
        }
        catch (IOException except) {
            log.error(String.format("Failed to scan the directory. [%s]", this.rootPath.toString()), (Throwable)except);
        }
        this.filePathInfoMap.clear();
        for (FileInfo fileInfo : files) {
            this.filePathInfoMap.put(fileInfo.getFilename(), fileInfo);
        }
        if (this.filePathInfoMap.size() == 0 && (log.isDebugEnabled() || this.firstTimePoll)) {
            log.info("No files found when polling directory [{}]", (Object)this.globPattern);
        }
        this.firstTimePoll = false;
        return files.toArray(new FileInfo[0]);
    }

    private void updateFileInfo(String fullPath, BasicFileAttributes attr, boolean doHardCheck, ArrayList<FileInfo> files) {
        FileInfo fileInfo = (FileInfo)this.filePathInfoMap.get(fullPath);
        if (fileInfo != null && this.nativePlatform != null && doHardCheck) {
            long fileSize = this.nativePlatform.getFileSize(fileInfo.getFilename());
            if (attr.size() == 0L && fileSize != -1L && fileSize > attr.size()) {
                fileInfo = new FileInfo(fullPath, fileSize, attr.creationTime().toMillis(), attr.lastModifiedTime().toMillis());
                files.add(fileInfo);
            } else {
                this.updateFileInfoBasedOnMetadata(fullPath, attr, fileInfo, files);
            }
        } else {
            this.updateFileInfoBasedOnMetadata(fullPath, attr, fileInfo, files);
        }
    }

    private void updateFileInfoBasedOnMetadata(String fullPath, BasicFileAttributes attr, FileInfo fileInfo, ArrayList<FileInfo> files) {
        if (fileInfo != null && fileInfo.metadataMatches(attr)) {
            files.add(fileInfo);
        } else {
            files.add(new FileInfo(fullPath, attr));
        }
    }

    @Generated
    public Path getRootPath() {
        return this.rootPath;
    }
}

