/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.agent.source.syslog;

import com.appdynamics.analytics.agent.source.LogComponentFactory;
import com.appdynamics.analytics.agent.source.LogSource;
import com.appdynamics.analytics.agent.source.LogSourceConfiguration;
import com.appdynamics.analytics.agent.source.LogWatermarkState;
import com.appdynamics.analytics.agent.source.syslog.SyslogSourceConfiguration;
import com.appdynamics.analytics.io.syslog.SyslogMessageListener;
import com.appdynamics.analytics.io.syslog.SyslogTcpServer;
import com.appdynamics.analytics.log.shared.dynamic.SyslogConfiguration;
import com.appdynamics.analytics.pipeline.framework.Pipeline;
import com.appdynamics.analytics.pipeline.framework.PipelineConfiguration;
import com.appdynamics.common.io.server.Servers;
import com.appdynamics.common.util.concurrent.ConcurrencyHelper;
import com.appdynamics.common.util.concurrent.ExitTrackableFutureTask;
import com.appdynamics.common.util.exception.Exceptions;
import com.codahale.metrics.health.HealthCheck;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyslogSource
extends LogSource
implements SyslogMessageListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SyslogSource.class);
    private final SyslogTcpServer listenable;
    private final ArrayBlockingQueue<CharSequence> queue;
    private final PipelineProcessor[] pipelineProcessors;
    private final List<ExitTrackableFutureTask<?>> pipelineProcessorsTasks;
    private Servers servers;

    public SyslogSource(LogSourceConfiguration configuration, LogComponentFactory lcf, ExecutorService executorService, SyslogTcpServer listenable, Servers servers) {
        super(String.format("%s [%s]", SyslogSource.class.getSimpleName(), configuration.getId()), configuration, lcf, executorService);
        this.listenable = listenable;
        this.servers = servers;
        Preconditions.checkArgument((boolean)(configuration instanceof SyslogSourceConfiguration));
        SyslogSourceConfiguration syslogSrcCfg = (SyslogSourceConfiguration)configuration;
        SyslogConfiguration syslogCfg = syslogSrcCfg.getSyslogInputConfiguration().getSyslogConfiguration();
        int numThreads = syslogCfg.getNumThreads();
        if (numThreads == 0) {
            numThreads = 1;
        }
        PipelineConfiguration pc = syslogSrcCfg.getSyslogInputConfiguration().getPipelineConfiguration();
        PipelineProcessor[] pp = new PipelineProcessor[numThreads];
        if (pc.isEnabled()) {
            for (int i = 0; i < pp.length; ++i) {
                Pipeline pipeline = this.factory.createPipeline(pc);
                pp[i] = new PipelineProcessor((Pipeline<CharSequence>)pipeline);
            }
        }
        this.queue = new ArrayBlockingQueue(pp.length * 4);
        this.pipelineProcessors = pp;
        this.pipelineProcessorsTasks = Collections.synchronizedList(new LinkedList());
    }

    @Override
    public LogWatermarkState getWatermarkState() {
        return null;
    }

    @Override
    public void setWatermarkState(LogWatermarkState watermarkState) {
    }

    @Override
    public synchronized void start() {
        if (!this.isRunning()) {
            this.cancelAndClear();
            for (PipelineProcessor pipelineProcessor : this.pipelineProcessors) {
                ExitTrackableFutureTask pipelineRunnable = new ExitTrackableFutureTask((Runnable)pipelineProcessor, null);
                this.executorService.submit((Runnable)pipelineRunnable);
                this.pipelineProcessorsTasks.add(pipelineRunnable);
            }
            if (this.listenable.getListener() != this && !this.listenable.compareAndSetListener(null, this)) {
                this.cancelAndClear();
                throw new IllegalStateException("Source [" + this.getName() + "] could not be started because there seems to be another listener already registered");
            }
            super.start();
        }
    }

    @Override
    public boolean isAlwaysRunnable() {
        return true;
    }

    private void cancelAndClear() {
        RuntimeException except = null;
        for (ExitTrackableFutureTask<?> runnable : this.pipelineProcessorsTasks) {
            try {
                ConcurrencyHelper.cancelWithWaitOnExit(runnable, (long)30000L);
            }
            catch (RuntimeException e) {
                log.error("Failed to cancel a syslog pipeline processor.", (Throwable)e);
                except = e;
            }
        }
        this.pipelineProcessorsTasks.clear();
        if (except != null) {
            throw except;
        }
    }

    @Override
    public void onMessage(String message) {
        if (this.isRunning()) {
            try {
                this.queue.put(message);
            }
            catch (InterruptedException e) {
                throw Exceptions.rethrowAsRuntimeException((InterruptedException)e);
            }
        }
    }

    @Override
    public synchronized void stop() {
        this.listenable.compareAndSetListener(this, null);
        try {
            this.cancelAndClear();
        }
        finally {
            if (this.isRunning()) {
                super.stop();
                this.closeConnection((SyslogSourceConfiguration)this.getConfiguration());
            }
        }
    }

    public HealthCheck.Result check() {
        int total = this.pipelineProcessorsTasks.size();
        int numRunning = 0;
        for (Future future : this.pipelineProcessorsTasks) {
            numRunning += !future.isDone() ? 1 : 0;
        }
        return numRunning < total ? HealthCheck.Result.unhealthy((String)("[" + (total - numRunning) + "] out of [" + total + "] pipelines are not running")) : HealthCheck.Result.healthy((String)("All [" + total + "] pipelines are running"));
    }

    public void closeConnection(SyslogSourceConfiguration configuration) {
        String serverId = configuration.getSyslogInputConfiguration().getSyslogConfiguration().getServerId();
        try {
            this.listenable.close();
            this.servers.remove((Object)serverId);
        }
        catch (Exception e) {
            log.warn("Error occurred while closing [{}]", (Throwable)e);
        }
    }

    class PipelineProcessor
    implements Runnable {
        private final Pipeline<CharSequence> pipeline;

        PipelineProcessor(Pipeline<CharSequence> pipeline) {
            this.pipeline = pipeline;
        }

        @Override
        public void run() {
            this.pipeline.start();
            try {
                Thread self = Thread.currentThread();
                try {
                    CharSequence chars = null;
                    while (!self.isInterrupted()) {
                        chars = SyslogSource.this.queue.poll(100L, TimeUnit.MILLISECONDS);
                        if (chars == null) continue;
                        this.pipeline.call((Object)chars);
                    }
                }
                catch (InterruptedException e) {
                    throw Exceptions.rethrowAsRuntimeException((InterruptedException)e);
                }
            }
            finally {
                this.pipeline.stop();
            }
        }
    }
}

