/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.agent.source;

import com.appdynamics.analytics.agent.base.LogBase;
import com.appdynamics.analytics.agent.pipeline.dynamic.LogSourceJobFileParser;
import com.appdynamics.analytics.agent.source.LogComponentFactory;
import com.appdynamics.analytics.agent.source.LogSource;
import com.appdynamics.analytics.agent.source.LogSourceConfiguration;
import com.appdynamics.analytics.agent.source.LogSourceItems;
import com.appdynamics.analytics.agent.source.LogSourceWatermarkConfiguration;
import com.appdynamics.analytics.agent.source.LogSourcesConfiguration;
import com.appdynamics.analytics.agent.source.LogWatermarkManager;
import com.appdynamics.analytics.agent.source.LogWatermarkState;
import com.appdynamics.analytics.agent.source.tail.LogSourceState;
import com.appdynamics.analytics.agent.source.tail.TailLogWatermarkState;
import com.codahale.metrics.health.HealthCheck;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogSources
extends LogBase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogSources.class);
    private static final Predicate<LogSourceState> REMOTE_WATERMARK_SOURCES_PREDICATE = new Predicate<LogSourceState>(){

        public boolean apply(@Nullable LogSourceState input) {
            return input != null && input.getLogSourceConfiguration().isRemoteConfigured();
        }
    };
    private static final Predicate<LogSource> REMOTE_LOG_SOURCES_PREDICATE = new Predicate<LogSource>(){

        public boolean apply(@Nullable LogSource input) {
            return input != null && input.getConfiguration().isRemoteConfigured();
        }
    };
    private final Predicate<LogSource> FORCED_DISABLED_LOG_SOURCES_PREDICATE = new Predicate<LogSource>(){

        public boolean apply(@Nullable LogSource input) {
            return input != null && LogSources.this.configuration.getForcedDisabledSourceIds().contains(input.getId()) && input.getConfiguration().isLocalConfigured();
        }
    };
    private static final Predicate<LogSource> LOCAL_LOG_SOURCES_PREDICATE = Predicates.not(REMOTE_LOG_SOURCES_PREDICATE);
    private static final Predicate<LogSource> ALL_LOG_SOURCES_PREDICATE = Predicates.alwaysTrue();
    private static final Predicate<LogSource> EMPTY_LOG_SOURCES_PREDICATE = Predicates.alwaysFalse();
    private final LogSourcesConfiguration configuration;
    private final LogSourceJobFileParser jobFileParser;
    private final LogWatermarkManager logWatermarkManager;
    private final LogSourceItems sources;
    private boolean firstConfigurationUpdate;

    public LogSources(LogComponentFactory factory, LogSourcesConfiguration configuration, LogSourceJobFileParser jobFileParser, ExecutorService executorService) {
        super("Log Sources", factory, executorService);
        this.configuration = configuration;
        this.jobFileParser = jobFileParser;
        this.sources = factory.createLogSourceItems(configuration.getMaxRunnableLogSources());
        this.logWatermarkManager = factory.createLogWatermarkManager(this, executorService, configuration.getWatermarkPath(), configuration.getWatermarkPersistInterval().toMilliseconds());
        this.firstConfigurationUpdate = true;
    }

    @Override
    public synchronized void start() {
        if (!this.isRunning()) {
            super.start();
            this.addInitialLogSources();
            this.applyDisableLogSourceOverrides();
            this.sources.startAll();
            this.logWatermarkManager.start();
        }
    }

    @Override
    public synchronized void stop() {
        if (this.isRunning()) {
            super.stop();
            this.sources.stopAll();
            this.logWatermarkManager.stop();
        }
    }

    @VisibleForTesting
    public void addInitialLogSources() {
        log.info("Loading previously persisted log source configuration and watermarks.");
        LogSourceWatermarkConfiguration sourceWatermarkConfiguration = this.logWatermarkManager.loadWatermarks();
        this.configuration.setDisableAllSources(sourceWatermarkConfiguration.isDisableAllSources());
        this.configuration.setDisableAllLocalSources(this.configuration.isDisableAllLocalSources() || sourceWatermarkConfiguration.isDisableAllLocalSources());
        this.configuration.setForcedDisabledSourceIds(sourceWatermarkConfiguration.getForcedDisabledSources());
        List<LogSourceState> sourceStates = sourceWatermarkConfiguration.getSourceStates();
        List<LogSourceConfiguration> localSources = this.jobFileParser.getLogSourceConfigurationsFromJobPaths();
        Map<String, LogSourceState> localWatermarks = this.filterWatermarks(sourceStates, (Predicate<LogSourceState>)Predicates.not(REMOTE_WATERMARK_SOURCES_PREDICATE));
        for (LogSourceConfiguration sourceConfiguration : localSources) {
            String logSourceId = sourceConfiguration.getId().toString();
            LogSourceState logSourceWatermark = localWatermarks.get(logSourceId);
            LogWatermarkState watermarkState = null;
            if (logSourceWatermark != null) {
                watermarkState = logSourceWatermark.getWatermarkState();
            }
            if (!sourceConfiguration.isEnabled() && logSourceWatermark == null) continue;
            this.addSource(sourceConfiguration, watermarkState);
        }
        for (LogSourceState sourceState : this.filterWatermarks(sourceStates, REMOTE_WATERMARK_SOURCES_PREDICATE).values()) {
            LogSourceConfiguration sourceConfiguration = sourceState.getLogSourceConfiguration();
            LogWatermarkState watermarkState = sourceState.getWatermarkState();
            this.addSource(sourceConfiguration, watermarkState);
        }
    }

    public void applyDisableLogSourceOverrides() {
        Predicate<LogSource> nonStartablePredicate = this.configuration.isDisableAllSources() ? ALL_LOG_SOURCES_PREDICATE : (this.configuration.isDisableAllLocalSources() ? LOCAL_LOG_SOURCES_PREDICATE : EMPTY_LOG_SOURCES_PREDICATE);
        nonStartablePredicate = Predicates.or(nonStartablePredicate, this.FORCED_DISABLED_LOG_SOURCES_PREDICATE);
        this.sources.setNonStartablePredicate(nonStartablePredicate);
    }

    private Map<String, LogSourceState> filterWatermarks(Collection<LogSourceState> sourceStates, Predicate<LogSourceState> filterPredicate) {
        HashMap<String, LogSourceState> watermarkStateMap = new HashMap<String, LogSourceState>();
        for (LogSourceState sourceState : Iterables.filter(sourceStates, filterPredicate)) {
            watermarkStateMap.put(sourceState.getLogSourceConfiguration().getId().toString(), sourceState);
        }
        return watermarkStateMap;
    }

    public synchronized boolean existsSource(String logSourceId) {
        return this.sources.get(logSourceId) != null;
    }

    public synchronized void removeSource(String sourceId) {
        this.sources.removeSource(sourceId);
        this.sources.startPendingSources();
    }

    @VisibleForTesting
    public synchronized void addSource(LogSourceConfiguration sourceConfiguration, LogWatermarkState logWatermarkState) {
        LogSource newLogSource = this.factory.createLogSource(sourceConfiguration, this.executorService);
        if (logWatermarkState != null) {
            newLogSource.setWatermarkState(logWatermarkState);
        }
        this.sources.addSource(newLogSource, false);
    }

    public synchronized void upsertSource(LogSourceConfiguration sourceConfiguration, boolean forceUpdateOnSameVersion) {
        long currentVersion;
        String logSourceId = sourceConfiguration.getId().toString();
        LogWatermarkState logWatermarkState = null;
        boolean forceStart = false;
        LogSource oldLogSource = this.sources.getSource(logSourceId);
        if (!forceUpdateOnSameVersion && oldLogSource != null && (currentVersion = oldLogSource.getConfiguration().getRevisionNumber()) == sourceConfiguration.getRevisionNumber()) {
            return;
        }
        if (oldLogSource == null && !sourceConfiguration.isEnabled()) {
            log.info("Skipping log source [{}] because it is disabled.", sourceConfiguration.getId());
            return;
        }
        if (oldLogSource != null) {
            this.removeSource(logSourceId);
        }
        LogSource newLogSource = this.factory.createLogSource(sourceConfiguration, this.executorService);
        if (oldLogSource != null) {
            forceStart = oldLogSource.isRunning();
            logWatermarkState = oldLogSource.getWatermarkState();
            if (newLogSource != null && logWatermarkState != null) {
                newLogSource.setWatermarkState(logWatermarkState);
            }
        } else if (sourceConfiguration.isDisableImportedSourceId() && sourceConfiguration.getImportedFromSourceId() != null && (oldLogSource = this.sources.getSource(sourceConfiguration.getImportedFromSourceId())) != null) {
            LogWatermarkState oldWatermarkState;
            if (oldLogSource.isRunning()) {
                log.warn("The old log source [{}] is still running. The log source will now be force disabled.", (Object)oldLogSource.getName());
                this.removeSource(oldLogSource.getId().toString());
            }
            if ((oldWatermarkState = oldLogSource.getWatermarkState()) != null) {
                newLogSource.setWatermarkState(TailLogWatermarkState.makeCopy((TailLogWatermarkState)oldWatermarkState));
            }
        }
        if (newLogSource != null) {
            this.sources.addSource(newLogSource, forceStart);
        }
        this.sources.startPendingSources();
    }

    public synchronized void updateRemoteSources(Collection<LogSourceConfiguration> upsertSources, Collection<String> deleteSourceIds) {
        if (this.firstConfigurationUpdate) {
            ArrayList<String> allDeletedSourceIds = new ArrayList<String>();
            allDeletedSourceIds.addAll(this.getLogSourceIdsFromLogSources(this.getAllRemoteSources()));
            allDeletedSourceIds.removeAll(this.getLogSourceIdsFromLogSourceConfigurations(upsertSources));
            allDeletedSourceIds.addAll(deleteSourceIds);
            deleteSourceIds = allDeletedSourceIds;
            this.firstConfigurationUpdate = false;
        }
        for (String logSourceId : deleteSourceIds) {
            log.info("Removing existing log source configuration [{}]", (Object)logSourceId);
            this.removeSource(logSourceId);
        }
        for (LogSourceConfiguration logSourceConfiguration : upsertSources) {
            log.info("Upserting log source configuration [{}]", (Object)logSourceConfiguration);
            this.upsertSource(logSourceConfiguration, false);
        }
    }

    public synchronized void updateDisableSources(boolean disableAllLocalSources, boolean disableAllSources, Set<String> forcedDisabledSourceIds) {
        if (this.configuration.isDisableAllLocalSources() != disableAllLocalSources || this.configuration.isDisableAllSources() != disableAllSources || !this.configuration.getForcedDisabledSourceIds().containsAll(forcedDisabledSourceIds)) {
            this.configuration.setDisableAllLocalSources(disableAllLocalSources);
            this.configuration.setDisableAllSources(disableAllSources);
            this.configuration.getForcedDisabledSourceIds().addAll(forcedDisabledSourceIds);
            this.applyDisableLogSourceOverrides();
            this.sources.startPendingSources();
        }
    }

    @VisibleForTesting
    public Collection<String> getLogSourceIdsFromLogSources(Collection<LogSource> logSources) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (LogSource logSource : logSources) {
            builder.add((Object)logSource.getId().toString());
        }
        return builder.build();
    }

    private Collection<String> getLogSourceIdsFromLogSourceConfigurations(Collection<LogSourceConfiguration> logSourceConfigurations) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (LogSourceConfiguration logSourceConfiguration : logSourceConfigurations) {
            builder.add((Object)logSourceConfiguration.getId().toString());
        }
        return builder.build();
    }

    public synchronized HealthCheck.Result check() {
        StringBuilder sb = new StringBuilder();
        boolean allRunning = true;
        int i = 0;
        for (LogSource logSource : this.sources.getAll()) {
            if (i > 0) {
                sb.append("; ");
            }
            ++i;
            sb.append("source: ").append(logSource.getName());
            HealthCheck.Result sourceHealth = logSource.check();
            sb.append(", details: ").append(sourceHealth.getMessage());
            allRunning = allRunning && sourceHealth.isHealthy();
        }
        return allRunning ? HealthCheck.Result.healthy((String)sb.toString()) : HealthCheck.Result.unhealthy((String)sb.toString());
    }

    public synchronized Collection<LogSource> getAllLogSources() {
        return this.sources.getAllLogSources();
    }

    public synchronized Collection<LogSource> getAllLocalSources() {
        return Collections2.filter(this.sources.getAllLogSources(), LOCAL_LOG_SOURCES_PREDICATE);
    }

    public synchronized Collection<LogSource> getAllRemoteSources() {
        return Collections2.filter(this.sources.getAllLogSources(), REMOTE_LOG_SOURCES_PREDICATE);
    }

    @Generated
    public LogSourcesConfiguration getConfiguration() {
        return this.configuration;
    }
}

