/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.agent.pipeline.event;

import com.appdynamics.analytics.agent.pipeline.event.EventServiceHelper;
import com.appdynamics.analytics.agent.pipeline.event.EventServicePublishStageFactoryConfig;
import com.appdynamics.analytics.client.common.exceptions.ClientException;
import com.appdynamics.analytics.client.common.exceptions.RestException;
import com.appdynamics.analytics.message.api.MessagePack;
import com.appdynamics.analytics.pipeline.api.PipelineStageParameters;
import com.appdynamics.analytics.pipeline.util.AbstractPipelineStage;
import com.appdynamics.analytics.shared.rest.client.eventservice.EventServiceClient;
import com.appdynamics.common.util.health.MeteredHealthCheck;
import com.appdynamics.common.util.misc.ThreadLocalObjects;
import com.codahale.metrics.Meter;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventServicePublishStage
extends AbstractPipelineStage<MessagePack<String, String>, MessagePack<String, String>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventServicePublishStage.class);
    final EventServicePublishStageFactoryConfig factoryConfig;
    final Meter successMeter;
    final Meter errorMeter;
    final EventServiceClient client;
    final String accountName;
    final String accessKey;
    final boolean eventBatchingEnabled;

    public EventServicePublishStage(PipelineStageParameters<MessagePack<String, String>> parameters, EventServicePublishStageFactoryConfig factoryConfig, MeteredHealthCheck healthCheck, EventServiceClient eventServiceClient, String accountName, String accessKey) {
        super(parameters);
        this.factoryConfig = factoryConfig;
        this.successMeter = healthCheck.getMeterSuccess();
        this.errorMeter = healthCheck.getMeterError();
        this.client = eventServiceClient;
        this.accountName = accountName;
        this.accessKey = accessKey;
        this.eventBatchingEnabled = factoryConfig.isEventBatchingEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(MessagePack<String, String> messagePack) {
        if (messagePack.size() == 0) {
            this.invokeNext(messagePack);
            return;
        }
        boolean trace = log.isTraceEnabled();
        if (this.eventBatchingEnabled) {
            boolean isFirst = true;
            StringBuilder messageBuilder = ThreadLocalObjects.stringBuilder();
            try {
                String message;
                messageBuilder.append("[");
                while ((message = (String)messagePack.poll()) != null) {
                    if (!isFirst) {
                        messageBuilder.append(",");
                    } else {
                        isFirst = false;
                    }
                    messageBuilder.append(message);
                }
                messageBuilder.append("]");
                String batchedMessage = messageBuilder.toString();
                this.sendMessage(messagePack, batchedMessage, trace);
            }
            finally {
                messageBuilder.setLength(0);
            }
        } else {
            String message;
            while ((message = (String)messagePack.poll()) != null) {
                this.sendMessage(messagePack, message, trace);
            }
        }
        this.invokeNext(messagePack);
    }

    private void sendMessage(MessagePack<String, String> messagePack, String message, boolean traceEnabled) {
        try {
            if (traceEnabled) {
                log.trace("About to publish [\n{}\n]", (Object)message);
            }
            if (this.factoryConfig.isUpsert()) {
                this.client.upsertEvents(this.accountName, this.accessKey, (String)messagePack.getSourceId(), message, this.factoryConfig.getIdPath(), this.factoryConfig.getMergeFields());
            } else {
                this.client.publishEvents(this.accountName, this.accessKey, (String)messagePack.getSourceId(), message);
            }
            this.successMeter.mark();
        }
        catch (RestException e) {
            this.errorMeter.mark();
            EventServiceHelper.handleRestError(log, messagePack, message, this.eventBatchingEnabled, e);
        }
        catch (ClientException e) {
            this.errorMeter.mark();
            EventServiceHelper.handleTransientError(log, messagePack, message, this.eventBatchingEnabled, e, e.getMessage());
        }
    }
}

