/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.agent.pipeline.event;

import com.appdynamics.analytics.client.common.exceptions.RestException;
import com.appdynamics.analytics.message.api.MessagePack;
import com.appdynamics.analytics.shared.rest.exceptions.StandardErrorSubStatusCodes;
import com.appdynamics.common.io.codec.Json;
import com.appdynamics.common.util.exception.PermanentException;
import com.appdynamics.common.util.misc.ThreadLocalObjects;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.slf4j.Logger;

public abstract class EventServiceHelper {
    private static final String FAILURES_FIELD = "failures";
    private static final String BULK_REQUEST_INDEX_FIELD = "bulkRequestIndex";
    private static final String TRANSIENT_FIELD = "transient";
    private static final String FAILURE_MESSAGE_FIELD = "message";
    private static final String LOG_NOT_NULL_MSG = "log can't be null";
    private static final String INPUT_SRC_NOT_NULL_MSG = "inputSource can't be null";

    private EventServiceHelper() {
    }

    public static void handleRestError(Logger log, MessagePack<String, String> inputSource, String input, boolean isBatchingEnabled, RestException ex) {
        Preconditions.checkNotNull((Object)log, (Object)LOG_NOT_NULL_MSG);
        Preconditions.checkNotNull(inputSource, (Object)INPUT_SRC_NOT_NULL_MSG);
        Preconditions.checkNotNull((Object)((Object)ex), (Object)"ex can't be null");
        Response.Status status = Response.Status.fromStatusCode((int)ex.getStatusCode());
        String code = ex.getCode();
        if (status == null) {
            EventServiceHelper.handleTransientError(log, inputSource, input, isBatchingEnabled, ex, String.format("The received status code [%d] was not a known value", ex.getStatusCode()));
            return;
        }
        switch (status.getFamily()) {
            case INFORMATIONAL: 
            case SUCCESSFUL: {
                EventServiceHelper.handlePermanentError(log, inputSource, input, ex, "The exception seems to contradict the status code");
                return;
            }
            case CLIENT_ERROR: {
                switch (status) {
                    case BAD_REQUEST: {
                        if (Objects.equals(StandardErrorSubStatusCodes.BULK_ERROR_BAD_REQUEST.getSubStatusCode(), code)) {
                            EventServiceHelper.handleBulkErrorResponse(log, inputSource, input, isBatchingEnabled, ex);
                            return;
                        }
                        EventServiceHelper.handlePermanentError(log, inputSource, input, ex, "Message could not be delivered since the request was invalid");
                        return;
                    }
                    case PRECONDITION_FAILED: {
                        EventServiceHelper.handlePermanentError(log, inputSource, input, ex, "Message could not be delivered because it appears to be corrupt or structured badly");
                        return;
                    }
                    case NOT_ACCEPTABLE: {
                        EventServiceHelper.handleTransientError(log, inputSource, input, isBatchingEnabled, ex, "Message could not be delivered because the REST resource rejected it");
                        return;
                    }
                    case NOT_FOUND: {
                        if (Objects.equals(StandardErrorSubStatusCodes.MISSING_EVENT_TYPE.getSubStatusCode(), code)) {
                            EventServiceHelper.handleTransientError(log, inputSource, input, isBatchingEnabled, ex, "Message could not be delivered because the event type is not registered, retrying in some time");
                            return;
                        }
                        EventServiceHelper.handlePermanentError(log, inputSource, input, ex, "Message could not be delivered because the REST resource was not found");
                        return;
                    }
                }
                EventServiceHelper.handlePermanentError(log, inputSource, input, ex, "Message could not be delivered due to a serious error");
                return;
            }
            case REDIRECTION: {
                EventServiceHelper.handlePermanentError(log, inputSource, input, ex, "Message could not be delivered because the REST resource appears to have moved");
                return;
            }
            case SERVER_ERROR: {
                EventServiceHelper.handleTransientError(log, inputSource, input, isBatchingEnabled, ex, "Message could not be delivered due to a server error");
                return;
            }
        }
        EventServiceHelper.handlePermanentError(log, inputSource, input, ex, "Message could not be delivered due to an unexpected error");
    }

    public static void handlePermanentError(Logger log, MessagePack<String, String> inputSource, String input, Throwable ex, String errorMessage) {
        Preconditions.checkNotNull((Object)log, (Object)LOG_NOT_NULL_MSG);
        Preconditions.checkNotNull(inputSource, (Object)INPUT_SRC_NOT_NULL_MSG);
        log.warn("Permanent error encountered due to the following cause: [{}]", (Object)errorMessage, (Object)ex);
        if (input == null) {
            log.warn("The original input message corresponding to the permanent error was null so it will not be placed back into the message pack");
            return;
        }
        inputSource.returnUndelivered((Object)input, (Throwable)new PermanentException(ex));
    }

    public static void handleTransientError(Logger log, MessagePack<String, String> inputSource, String input, boolean isBatchingEnabled, Throwable ex, String errorMessage) {
        Preconditions.checkNotNull((Object)log, (Object)LOG_NOT_NULL_MSG);
        Preconditions.checkNotNull(inputSource, (Object)INPUT_SRC_NOT_NULL_MSG);
        log.warn("Transient error encountered due to the following cause: [{}]", (Object)errorMessage, (Object)ex);
        if (input == null) {
            log.warn("The original input message corresponding to the transient error was null so it will not be placed back into the message pack");
            return;
        }
        if (isBatchingEnabled) {
            if (input.length() >= 2 && input.charAt(0) == '[' && input.charAt(input.length() - 1) == ']') {
                input = input.substring(1, input.length() - 1);
                inputSource.returnUndelivered((Object)input);
            } else {
                inputSource.returnUndelivered((Object)input, (Throwable)new IllegalArgumentException(String.format("Batch enabled message [%s] was not properly enclosed within square brackets.  Since the message is not formatted properly it will not be re-circulated back onto the message pack queue.", input)));
            }
        } else {
            inputSource.returnUndelivered((Object)input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleBulkErrorResponse(Logger log, MessagePack<String, String> inputSource, String input, boolean isBatchingEnabled, RestException ex) {
        Preconditions.checkNotNull((Object)log, (Object)LOG_NOT_NULL_MSG);
        Preconditions.checkNotNull(inputSource, (Object)INPUT_SRC_NOT_NULL_MSG);
        Preconditions.checkNotNull((Object)((Object)ex), (Object)"ex can't be null");
        if (input == null) {
            log.warn("The original input message corresponding to the bulk error response was null so it will not be placed back into the message pack", (Throwable)ex);
            return;
        }
        String developerMessage = ex.getDeveloperMessage();
        if (Strings.isNullOrEmpty((String)developerMessage)) {
            EventServiceHelper.handlePermanentError(log, inputSource, input, ex, "Failed to parse bulk error response since the developerMessage field was blank");
            return;
        }
        Json.Walker walker = ThreadLocalObjects.jsonWalker();
        try {
            JsonNode failures = EventServiceHelper.getFailures(walker, developerMessage);
            if (failures == null || !failures.isArray()) {
                EventServiceHelper.handlePermanentError(log, inputSource, input, ex, "Failed to parse bulk error response since the failures field was not an array type");
                return;
            }
            HashMap<Integer, String> transientErrorIndexAndMessagePairs = new HashMap<Integer, String>();
            HashMap<Integer, String> permanentErrorIndexAndMessagePairs = new HashMap<Integer, String>();
            EventServiceHelper.populateErrorIndexAndMessagePairs(log, walker, failures, transientErrorIndexAndMessagePairs, permanentErrorIndexAndMessagePairs);
            EventServiceHelper.extractMessagesFromInput(log, walker, inputSource, input, isBatchingEnabled, transientErrorIndexAndMessagePairs, permanentErrorIndexAndMessagePairs);
        }
        catch (IOException e) {
            EventServiceHelper.handlePermanentError(log, inputSource, input, e, "Failed to parse the bulk error response");
        }
        finally {
            walker.endWalk();
        }
    }

    @Nullable
    private static JsonNode getFailures(Json.Walker walker, String developerMessage) throws IOException {
        byte[] developerMessageBytes = developerMessage.getBytes(Charsets.UTF_8);
        HashMap fieldNamesToFind = new HashMap(2);
        fieldNamesToFind.put(FAILURES_FIELD, null);
        Json.readTopLevelFields((Json.Walker)walker, (byte[])developerMessageBytes, (int)0, (int)developerMessageBytes.length, fieldNamesToFind);
        return (JsonNode)fieldNamesToFind.get(FAILURES_FIELD);
    }

    private static void populateErrorIndexAndMessagePairs(Logger log, Json.Walker walker, JsonNode failures, Map<Integer, String> transientErrorIndexAndMessagePairs, Map<Integer, String> permanentErrorIndexAndMessagePairs) throws IOException {
        byte[] failureBytes = failures.toString().getBytes(Charsets.UTF_8);
        List scanResults = Json.scanChildrenOfArray((Json.Walker)walker, (byte[])failureBytes, (int)0, (int)failureBytes.length);
        for (Json.ScanResult result : scanResults) {
            String failureMessage;
            int rangeOffset = (Integer)result.getLeft();
            int rangeLength = (Integer)result.getRight();
            HashMap fieldNamesToFind = new HashMap(4);
            fieldNamesToFind.put(BULK_REQUEST_INDEX_FIELD, null);
            fieldNamesToFind.put(TRANSIENT_FIELD, null);
            fieldNamesToFind.put(FAILURE_MESSAGE_FIELD, null);
            Json.readTopLevelFields((Json.Walker)walker, (byte[])failureBytes, (int)rangeOffset, (int)rangeLength, fieldNamesToFind);
            JsonNode isTransientNode = (JsonNode)fieldNamesToFind.get(TRANSIENT_FIELD);
            JsonNode bulkRequestIndexNode = (JsonNode)fieldNamesToFind.get(BULK_REQUEST_INDEX_FIELD);
            JsonNode failureMessageNode = (JsonNode)fieldNamesToFind.get(FAILURE_MESSAGE_FIELD);
            boolean isTransient = isTransientNode != null && isTransientNode.asBoolean();
            int bulkRequestIndex = bulkRequestIndexNode == null ? -1 : bulkRequestIndexNode.asInt(-1);
            String string = failureMessage = failureMessageNode == null ? null : failureMessageNode.asText();
            if (isTransient && bulkRequestIndex >= 0) {
                transientErrorIndexAndMessagePairs.put(bulkRequestIndex, failureMessage);
                continue;
            }
            if (bulkRequestIndex >= 0) {
                permanentErrorIndexAndMessagePairs.put(bulkRequestIndex, failureMessage);
                continue;
            }
            log.warn("Failure message [{}] from bulk error response contained invalid bulk request index [{}]", (Object)failureMessage, (Object)bulkRequestIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractMessagesFromInput(Logger log, Json.Walker walker, MessagePack<String, String> inputSource, String input, boolean isBatchingEnabled, Map<Integer, String> transientErrorIndexAndMessagePairs, Map<Integer, String> permanentErrorIndexAndMessagePairs) throws IOException {
        StringBuilder transientErrorMessages = ThreadLocalObjects.stringBuilder();
        try {
            if (!transientErrorIndexAndMessagePairs.isEmpty() && !isBatchingEnabled) {
                transientErrorMessages.append('[');
            }
            byte[] inputBytes = input.getBytes(Charsets.UTF_8);
            List scanResults = Json.scanChildrenOfArray((Json.Walker)walker, (byte[])inputBytes, (int)0, (int)inputBytes.length);
            int arrayIndex = 0;
            boolean isFirst = true;
            for (Json.ScanResult result : scanResults) {
                int rangeOffset = (Integer)result.getLeft();
                int rangeLength = (Integer)result.getRight();
                if (transientErrorIndexAndMessagePairs.containsKey(arrayIndex)) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        transientErrorMessages.append(',');
                    }
                    String transientErrorMessage = new String(Arrays.copyOfRange(inputBytes, rangeOffset, rangeOffset + rangeLength), Charsets.UTF_8);
                    log.warn("The message at index [{}] failed due to the following transient error: [{}]", (Object)arrayIndex, (Object)transientErrorIndexAndMessagePairs.get(arrayIndex));
                    transientErrorMessages.append(transientErrorMessage);
                } else if (permanentErrorIndexAndMessagePairs.containsKey(arrayIndex)) {
                    String permanentErrorMessage = new String(Arrays.copyOfRange(inputBytes, rangeOffset, rangeOffset + rangeLength), Charsets.UTF_8);
                    log.warn("The message at index [{}] failed due to the following permanent error: [{}]", (Object)arrayIndex, (Object)permanentErrorIndexAndMessagePairs.get(arrayIndex));
                    inputSource.returnUndelivered((Object)permanentErrorMessage, (Throwable)new PermanentException(permanentErrorIndexAndMessagePairs.get(arrayIndex)));
                }
                ++arrayIndex;
            }
            if (transientErrorMessages.length() > 0) {
                if (!isBatchingEnabled) {
                    transientErrorMessages.append(']');
                }
                inputSource.returnUndelivered((Object)transientErrorMessages.toString());
            }
        }
        finally {
            transientErrorMessages.setLength(0);
        }
    }
}

