/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.agent.pipeline.event;

import com.appdynamics.analytics.agent.pipeline.event.AgentEventServiceConfiguration;
import com.appdynamics.analytics.shared.rest.client.eventservice.DefaultEventServiceClient;
import com.appdynamics.analytics.shared.rest.client.eventservice.DefaultExtractedFieldsClient;
import com.appdynamics.analytics.shared.rest.client.eventservice.EventServiceClient;
import com.appdynamics.analytics.shared.rest.client.eventservice.ExtractedFieldsClient;
import com.appdynamics.analytics.shared.rest.client.eventservice.creator.AnalyticsBizTxnEventTypeCreator;
import com.appdynamics.analytics.shared.rest.client.eventservice.creator.AnalyticsLogTxnEventTypeCreator;
import com.appdynamics.analytics.shared.rest.client.eventservice.creator.EventTypeCreator;
import com.appdynamics.common.framework.util.Module;
import com.appdynamics.common.util.health.ConsolidatedHealthCheck;
import com.appdynamics.common.util.health.HealthCheckable;
import com.appdynamics.common.util.health.SimpleHealthCheck;
import com.codahale.metrics.health.HealthCheck;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.PreDestroy;
import lombok.Generated;
import org.apache.http.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentEventServiceClientModule
extends Module<AgentEventServiceConfiguration> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AgentEventServiceClientModule.class);
    private static final int MAX_CONNECTIONS_PER_ROUTE = 1;
    private static final int MAX_TOTAL_CONNECTIONS = 1;

    @Provides
    @Singleton
    public EventServiceClientFactory provideEventServiceClient() {
        return new EventServiceClientFactory((AgentEventServiceConfiguration)this.getConfiguration());
    }

    @Inject
    void start(EventServiceClientFactory eventServiceClientFactory, ConsolidatedHealthCheck healthCheck) {
        try (EventServiceClient client = eventServiceClientFactory.createEventServiceClient();){
            client.ping(eventServiceClientFactory.getAccountName(), eventServiceClientFactory.getAccessKey());
        }
        catch (ParseException e) {
            log.error("The Event Service could not be contacted. Please verify that the account name, access key and the endpoint address were specified correctly", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            String msg = "The Event Service could not be contacted. Please verify that the account name, access key and the endpoint address were specified correctly. It could also be the case that the service is not running yet";
            if (log.isDebugEnabled()) {
                log.warn(msg, (Throwable)e);
            }
            String s = Throwables.getRootCause((Throwable)e).getMessage();
            log.warn(msg + ". Actual error message [" + s + "]");
        }
        healthCheck.register((HealthCheckable)new EventServiceConnectivityHealthCheck(eventServiceClientFactory));
    }

    public static class EventServiceClientFactory {
        private final URI baseUri;
        private final String accountName;
        private final String accessKey;
        private final String eventTrustStorePath;
        private final String eventTrustStorePassword;
        private final String eventTrustStoreType;
        final List<Closeable> closeableClients;
        private final AgentEventServiceConfiguration configuration;

        EventServiceClientFactory(AgentEventServiceConfiguration configuration) {
            this.baseUri = URI.create(configuration.getEndpoint());
            this.accountName = configuration.getAccountName();
            this.accessKey = configuration.getAccessKey();
            this.closeableClients = new CopyOnWriteArrayList<Closeable>();
            this.configuration = configuration;
            this.eventTrustStorePath = configuration.isUseControllerTrustStore() ? configuration.getControllerTrustStorePath() : configuration.getEventTrustStorePath();
            this.eventTrustStorePassword = configuration.isUseControllerTrustStore() ? configuration.getControllerTrustStorePassword() : configuration.getEventTrustStorePassword();
            this.eventTrustStoreType = configuration.isUseControllerTrustStore() ? configuration.getControllerTrustStoreType() : configuration.getEventTrustStoreType();
        }

        public EventServiceClient createEventServiceClient() {
            log.info("Created EventServiceClient for account [{}]", (Object)this.accountName);
            DefaultEventServiceClient client = this.createDefaultEventServiceClient();
            this.closeableClients.add((Closeable)client);
            return client;
        }

        public ExtractedFieldsClient createExtractedFieldsClient() {
            log.info("Created ExtractedFieldsClient for account [{}]", (Object)this.accountName);
            DefaultExtractedFieldsClient client = this.createDefaultExtractedFieldsClient();
            this.closeableClients.add((Closeable)client);
            return client;
        }

        DefaultEventServiceClient createDefaultEventServiceClient() {
            log.info("Trust store being used for communication with the Event Service [{}]", (Object)this.eventTrustStorePath);
            DefaultEventServiceClient client = (DefaultEventServiceClient)DefaultEventServiceClient.builder((String)this.baseUri.getScheme(), (String)this.baseUri.getHost(), (int)this.baseUri.getPort(), (String)this.baseUri.getPath()).socketTimeoutMillis(this.configuration.getSocketTimeoutMillis()).connectionTimeoutMillis(this.configuration.getConnectionTimeoutMillis()).trustStoreConfig(this.eventTrustStorePath, this.eventTrustStorePassword, this.eventTrustStoreType).maxConnectionsPerRoute(1).maxTotalConnections(1).proxyConfig(this.configuration.proxyHost, this.configuration.proxyPort, this.configuration.proxyUsername, this.configuration.proxyPassword).setTlsVersion(this.configuration.getEventTlsVersion()).evictIdleConnections(10000L).evictExpiredConnections().build();
            client.registerEventTypeCreator(new EventTypeCreator[]{new AnalyticsBizTxnEventTypeCreator(), new AnalyticsLogTxnEventTypeCreator()});
            return client;
        }

        DefaultExtractedFieldsClient createDefaultExtractedFieldsClient() {
            log.info("Trust store being used for communication with the Event Service [{}]", (Object)this.eventTrustStorePath);
            return (DefaultExtractedFieldsClient)DefaultExtractedFieldsClient.builder((String)this.baseUri.getScheme(), (String)this.baseUri.getHost(), (int)this.baseUri.getPort(), (String)this.baseUri.getPath()).socketTimeoutMillis(this.configuration.getSocketTimeoutMillis()).connectionTimeoutMillis(this.configuration.getConnectionTimeoutMillis()).trustStoreConfig(this.eventTrustStorePath, this.eventTrustStorePassword, this.eventTrustStoreType).maxConnectionsPerRoute(1).maxTotalConnections(1).proxyConfig(this.configuration.proxyHost, this.configuration.proxyPort, this.configuration.proxyUsername, this.configuration.proxyPassword).setTlsVersion(this.configuration.getEventTlsVersion()).build();
        }

        public String getAccountName() {
            return this.accountName;
        }

        public String getAccessKey() {
            return this.accessKey;
        }

        @PreDestroy
        void stop() {
            for (Closeable client : this.closeableClients) {
                try {
                    client.close();
                }
                catch (IOException e) {
                    log.error("Could not close http client connection", (Throwable)e);
                }
            }
            this.closeableClients.clear();
        }
    }

    static class EventServiceConnectivityHealthCheck
    extends SimpleHealthCheck {
        final EventServiceClient client;
        final String accountName;
        final String accessKey;

        public EventServiceConnectivityHealthCheck(EventServiceClientFactory esf) {
            super("Connection to [" + esf.baseUri.toString() + "]");
            this.client = esf.createEventServiceClient();
            this.accountName = esf.getAccountName();
            this.accessKey = esf.getAccessKey();
        }

        public HealthCheck.Result check() {
            return SimpleHealthCheck.callAndCheck(() -> this.client.ping(this.accountName, this.accessKey));
        }
    }
}

