/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.agent.pipeline.dynamic;

import com.appdynamics.analytics.agent.field.ExtractedFieldsManager;
import com.appdynamics.analytics.agent.pipeline.dynamic.JobConfigurationDecoder;
import com.appdynamics.analytics.agent.source.LogSourceConfiguration;
import com.appdynamics.analytics.agent.source.LogSourceConfigurationHelper;
import com.appdynamics.analytics.pipeline.framework.PipelineConfiguration;
import com.appdynamics.common.io.IoHelper;
import com.appdynamics.common.io.file.FilePathConfiguration;
import com.appdynamics.common.util.configuration.CommonReader;
import com.appdynamics.common.util.configuration.Reader;
import com.appdynamics.common.util.var.Variables;
import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.google.common.base.Charsets;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogSourceJobFileParser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogSourceJobFileParser.class);
    final List<FilePathConfiguration> jobFilePaths;
    final String templatePath;
    final Mustache mustache;
    final Properties variableValues;
    final JobConfigurationDecoder decoder;
    final ExtractedFieldsManager extractedFieldsManager;

    public LogSourceJobFileParser(List<FilePathConfiguration> jobFilePaths, String mustacheTemplatePath, Properties variableValues, ExtractedFieldsManager extractedFieldsManager) {
        this.jobFilePaths = jobFilePaths;
        this.templatePath = mustacheTemplatePath;
        DefaultMustacheFactory mustacheFactory = new DefaultMustacheFactory();
        this.mustache = mustacheFactory.compile(mustacheTemplatePath);
        this.variableValues = variableValues;
        this.decoder = new JobConfigurationDecoder(this.mustache);
        this.extractedFieldsManager = extractedFieldsManager;
    }

    public LogSourceConfiguration parseLogSourceConfigurationFromFile(String jobFile) throws IOException {
        return this.parseLogSourceConfigurationFromFile(new File(this.jobFilePaths.get(0).getPath(), jobFile));
    }

    public LogSourceConfiguration parseLogSourceConfigurationFromFile(File input) throws IOException {
        PipelineConfiguration pipelineConfiguration = this.parsePipelineConfigurationFromFile(input);
        LogSourceConfiguration logSourceConfiguration = LogSourceConfigurationHelper.convertPipelineConfigurationToLogSourceConfiguration(pipelineConfiguration.getId(), pipelineConfiguration, this.extractedFieldsManager);
        logSourceConfiguration.setRemoteConfigured(false);
        logSourceConfiguration.setRevisionNumber(input.lastModified());
        return logSourceConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PipelineConfiguration parsePipelineConfigurationFromFile(File input) throws IOException {
        String varResolvedInput;
        InputStream inputStream = null;
        try {
            inputStream = this.decoder.toYml(input);
        }
        catch (Exception e) {
            log.warn("File [" + input.getAbsolutePath() + "] could not be parsed as 'Job DSL' input to [" + this.templatePath + "]. An attempt will be made to read it as a plain YML file", (Throwable)e);
        }
        if (inputStream == null) {
            inputStream = new FileInputStream(input);
        }
        try {
            varResolvedInput = this.readAndResolveVariables(input, inputStream);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return LogSourceJobFileParser.tryParsePipelineConfiguration(input, varResolvedInput);
    }

    String readAndResolveVariables(File originalFile, InputStream unresolvedInputStream) throws IOException {
        this.variableValues.put("pipeline.id", this.makePipelineId(originalFile));
        try {
            String string;
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                Variables.resolveVariables((InputStream)unresolvedInputStream, (Properties)this.variableValues, (OutputStream)outputStream);
                log.debug("File [{}] variables were resolved", (Object)originalFile.getAbsolutePath());
                string = new String(outputStream.toByteArray(), Charsets.UTF_8);
            }
            return string;
        }
        finally {
            this.variableValues.remove("pipeline.id");
        }
    }

    String makePipelineId(File unresolvedInput) {
        return unresolvedInput.getName();
    }

    static PipelineConfiguration tryParsePipelineConfiguration(File originalFile, String ymlInput) throws IOException {
        PipelineConfiguration pc = (PipelineConfiguration)Reader.DEFAULT_YAML_MAPPER.readValue(ymlInput, PipelineConfiguration.class);
        CommonReader.validate((Object)pc);
        log.debug("File [{}] was used to create a valid [{}] \n{}", new Object[]{originalFile.getAbsolutePath(), pc.getClass().getSimpleName(), ymlInput});
        return pc;
    }

    public List<LogSourceConfiguration> getLogSourceConfigurationsFromJobPaths() {
        ArrayList<LogSourceConfiguration> sourceConfigurations = new ArrayList<LogSourceConfiguration>();
        for (FilePathConfiguration path : this.jobFilePaths) {
            sourceConfigurations.addAll(this.getLogSourceConfigurationsFromPath(path));
        }
        return sourceConfigurations;
    }

    public List<LogSourceConfiguration> getLogSourceConfigurationsFromPath(FilePathConfiguration jobPath) {
        final ArrayList<LogSourceConfiguration> sourceConfigurations = new ArrayList<LogSourceConfiguration>();
        Path path = Paths.get(jobPath.getPath(), new String[0]);
        final PathMatcher matcher = FileSystems.getDefault().getPathMatcher(IoHelper.getGlobPatternFromPathGlob((FilePathConfiguration)jobPath));
        try {
            Files.walkFileTree(path, Collections.emptySet(), 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    log.debug("Skipping file [{}] because of IO exception [{}]", (Object)file, (Object)exc.getMessage());
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path filePath, BasicFileAttributes attr) throws IOException {
                    try {
                        boolean matches = matcher.matches(filePath);
                        if (matches) {
                            LogSourceConfiguration logSourceConfiguration = LogSourceJobFileParser.this.parseLogSourceConfigurationFromFile(filePath.toFile());
                            sourceConfigurations.add(logSourceConfiguration);
                        }
                    }
                    catch (Exception except) {
                        log.error("Failed to load job file [{}], skipping.", (Object)filePath.toString(), (Object)except);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException except) {
            log.error("Failed to find job files in directory [{}]", (Object)path.toString(), (Object)except);
        }
        return sourceConfigurations;
    }
}

