/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.agent.pipeline.dynamic;

import com.appdynamics.analytics.agent.field.ExtractedFieldsManager;
import com.appdynamics.analytics.agent.pipeline.dynamic.LogSourceJobFileConfiguration;
import com.appdynamics.analytics.agent.pipeline.dynamic.LogSourceJobFileListener;
import com.appdynamics.analytics.agent.pipeline.dynamic.LogSourceJobFileParser;
import com.appdynamics.analytics.agent.source.LogSources;
import com.appdynamics.common.io.file.AbstractFilePollerModule;
import com.appdynamics.common.util.configuration.ConfigurationHelper;
import com.google.inject.Inject;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import java.io.File;
import java.net.URL;
import java.nio.file.PathMatcher;
import lombok.Generated;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogSourceJobFileModule
extends AbstractFilePollerModule<LogSourceJobFileConfiguration> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogSourceJobFileModule.class);
    @Inject
    private volatile LogSourceJobFileListener jobFileListener;

    @Singleton
    @Provides
    public LogSourceJobFileParser makeLogSourceJobFileParser(ExtractedFieldsManager extractedFieldsManager) {
        return new LogSourceJobFileParser(((LogSourceJobFileConfiguration)((Object)this.getConfiguration())).getPaths(), this.findTemplatePath("log-pipeline.yml.template"), ConfigurationHelper.getProperties(), extractedFieldsManager);
    }

    @Singleton
    @Provides
    public LogSourceJobFileListener makeLogSourceJobFileListener(LogSources logSources, LogSourceJobFileParser jobFileParser) {
        return new LogSourceJobFileListener(logSources, jobFileParser);
    }

    protected FileAlterationListener newListener(String path, PathMatcher pathMatcher) {
        return this.jobFileListener;
    }

    private String findTemplatePath(String inputPath) {
        File file = new File(inputPath);
        if (!file.exists()) {
            URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource(inputPath);
            if (url == null) {
                throw new IllegalArgumentException("The template file that is supposed to be located at [" + file.getAbsolutePath() + "] does not exist");
            }
            return file.getPath();
        }
        return file.getAbsolutePath();
    }
}

