/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.agent.input.tail;

import com.appdynamics.analytics.agent.input.tail.FileInfo;
import com.appdynamics.analytics.agent.input.tail.FileSignature;
import com.appdynamics.analytics.agent.input.tail.GZIPFileChannel;
import com.appdynamics.common.util.datetime.TimeKeeper;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;

public class TailFileState
implements AutoCloseable {
    private static final AtomicInteger globalUniqueIdCounter = new AtomicInteger(0);
    @JsonIgnore
    private final int uniqueId = globalUniqueIdCounter.addAndGet(1);
    @JsonIgnore
    volatile FileChannel fileChannel;
    volatile FileSignature signature;
    volatile String filename;
    volatile long lastScanned;
    volatile long lastReadPosition;
    volatile long decompressedSize;
    @JsonIgnore
    volatile long created;
    @JsonIgnore
    long lastModifiedTimestamp;
    @JsonIgnore
    volatile long lastReadTimestamp;

    protected TailFileState() {
    }

    public TailFileState(FileInfo fileInfo) throws IOException {
        this();
        this.initializeFromFileInfo(fileInfo);
    }

    public TailFileState(TailFileState other) {
        this.signature = other.getSignature();
        this.filename = other.getFilename();
        this.lastScanned = other.getLastScanned();
        this.lastReadPosition = other.getLastReadPosition();
        this.decompressedSize = other.getDecompressedSize();
        this.created = other.getCreated();
        this.lastModifiedTimestamp = other.getLastModifiedTimestamp();
        this.lastReadPosition = other.getLastReadPosition();
    }

    protected void initializeFromFileInfo(FileInfo fileInfo) throws IOException {
        this.signature = fileInfo.getFileSignature();
        this.filename = fileInfo.getFilename();
        this.lastScanned = TimeKeeper.currentUtcTime().getMillis();
        this.lastReadPosition = 0L;
        this.lastReadTimestamp = TimeKeeper.currentUtcTime().getMillis();
        this.lastModifiedTimestamp = fileInfo.getLastModified();
        this.created = fileInfo.getCreated();
        this.decompressedSize = -1L;
    }

    public void updateLastModifiedTime(FileInfo fileInfo) throws IOException {
        this.lastModifiedTimestamp = fileInfo.getLastModified();
    }

    protected void finalize() throws IOException {
        this.close();
    }

    public FileChannel takeFileChannelOwnership() throws IOException {
        this.ensureFileChannelExists();
        FileChannel takenFc = this.fileChannel;
        this.fileChannel = null;
        return takenFc;
    }

    private void ensureFileChannelExists() throws IOException {
        if (this.fileChannel == null) {
            Path filePath = Paths.get(this.filename, new String[0]);
            this.fileChannel = FileChannel.open(filePath, StandardOpenOption.READ);
            if (this.isCompressed()) {
                this.fileChannel = new GZIPFileChannel(this.fileChannel);
            }
        }
    }

    private boolean isCompressed() {
        return this.filename.endsWith(".gz");
    }

    @Override
    public void close() throws IOException {
        if (this.fileChannel != null) {
            this.fileChannel.close();
            this.fileChannel = null;
        }
    }

    public int hashCode() {
        return this.getUniqueId();
    }

    public boolean equals(Object o) {
        return o instanceof TailFileState && this.getUniqueId() == ((TailFileState)o).getUniqueId();
    }

    @Generated
    public int getUniqueId() {
        return this.uniqueId;
    }

    @Generated
    public FileChannel getFileChannel() {
        return this.fileChannel;
    }

    @Generated
    public FileSignature getSignature() {
        return this.signature;
    }

    @Generated
    public String getFilename() {
        return this.filename;
    }

    @Generated
    public long getLastScanned() {
        return this.lastScanned;
    }

    @Generated
    public long getLastReadPosition() {
        return this.lastReadPosition;
    }

    @Generated
    public long getDecompressedSize() {
        return this.decompressedSize;
    }

    @Generated
    public long getCreated() {
        return this.created;
    }

    @Generated
    public long getLastModifiedTimestamp() {
        return this.lastModifiedTimestamp;
    }

    @Generated
    public long getLastReadTimestamp() {
        return this.lastReadTimestamp;
    }

    @JsonIgnore
    @Generated
    public void setFileChannel(FileChannel fileChannel) {
        this.fileChannel = fileChannel;
    }

    @Generated
    public void setSignature(FileSignature signature) {
        this.signature = signature;
    }

    @Generated
    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Generated
    public void setLastScanned(long lastScanned) {
        this.lastScanned = lastScanned;
    }

    @Generated
    public void setLastReadPosition(long lastReadPosition) {
        this.lastReadPosition = lastReadPosition;
    }

    @Generated
    public void setDecompressedSize(long decompressedSize) {
        this.decompressedSize = decompressedSize;
    }

    @JsonIgnore
    @Generated
    public void setCreated(long created) {
        this.created = created;
    }

    @JsonIgnore
    @Generated
    public void setLastModifiedTimestamp(long lastModifiedTimestamp) {
        this.lastModifiedTimestamp = lastModifiedTimestamp;
    }

    @JsonIgnore
    @Generated
    public void setLastReadTimestamp(long lastReadTimestamp) {
        this.lastReadTimestamp = lastReadTimestamp;
    }

    @Generated
    public String toString() {
        return "TailFileState(signature=" + String.valueOf(this.getSignature()) + ", filename=" + this.getFilename() + ", lastScanned=" + this.getLastScanned() + ", lastReadPosition=" + this.getLastReadPosition() + ", decompressedSize=" + this.getDecompressedSize() + ", created=" + this.getCreated() + ", lastModifiedTimestamp=" + this.getLastModifiedTimestamp() + ", lastReadTimestamp=" + this.getLastReadTimestamp() + ")";
    }
}

