/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.agent.input.tail;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPInputStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GZIPFileChannel
extends FileChannel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GZIPFileChannel.class);
    private static final String METHOD_NOT_IMPL_MSG = "This method is not implemented for GZ files";
    private static final int MAX_READ_CAP = 65536;
    private final FileChannel baseFileChannel;
    private InputStream gzipInputStream;
    private final AtomicLong readPosition = new AtomicLong(-1L);
    private final AtomicLong fileSize = new AtomicLong(-1L);

    public GZIPFileChannel(FileChannel fc) throws IOException {
        this.baseFileChannel = fc;
        this.resetGzipInputStream();
    }

    private synchronized void resetGzipInputStream() throws IOException {
        this.baseFileChannel.position(0L);
        this.gzipInputStream = new GZIPInputStream(Channels.newInputStream(this.baseFileChannel), 65536);
        this.readPosition.set(0L);
    }

    @Override
    public synchronized long size() throws IOException {
        if (this.fileSize.get() == -1L) {
            long initialReadPos = this.readPosition.get();
            this.fileSize.set(initialReadPos);
            long skippedBytes = this.skip(Long.MAX_VALUE);
            this.fileSize.addAndGet(skippedBytes);
            this.resetGzipInputStream();
            this.position(initialReadPos);
        }
        return this.fileSize.get();
    }

    @Override
    public synchronized int read(ByteBuffer dst) throws IOException {
        int readPos = dst.position();
        int readBytes = this.gzipInputStream.read(dst.array(), readPos, dst.array().length - readPos);
        if (readBytes > 0) {
            this.readPosition.addAndGet(readBytes);
        }
        return readBytes;
    }

    @Override
    public long position() throws IOException {
        return this.readPosition.get();
    }

    private synchronized long skip(long delta) throws IOException {
        long actualSkipped = 0L;
        while (delta > 0L && this.gzipInputStream.available() > 0) {
            long d1 = this.gzipInputStream.skip(delta);
            delta -= d1;
            actualSkipped += d1;
        }
        return actualSkipped;
    }

    @Override
    public synchronized FileChannel position(long newPosition) throws IOException {
        long skipped = 0L;
        if (newPosition > this.readPosition.get()) {
            long diff = newPosition - this.readPosition.get();
            skipped = this.skip(diff);
            this.readPosition.addAndGet(skipped);
        } else if (newPosition < this.readPosition.get()) {
            this.resetGzipInputStream();
            skipped = this.skip(newPosition);
            this.readPosition.set(skipped);
        }
        log.trace("Skipped [{}] bytes", (Object)skipped);
        return this;
    }

    @Override
    protected void implCloseChannel() throws IOException {
        this.gzipInputStream.close();
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        throw new IllegalAccessError(METHOD_NOT_IMPL_MSG);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        throw new IllegalAccessError(METHOD_NOT_IMPL_MSG);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        throw new IllegalAccessError(METHOD_NOT_IMPL_MSG);
    }

    @Override
    public FileChannel truncate(long size) throws IOException {
        throw new IllegalAccessError(METHOD_NOT_IMPL_MSG);
    }

    @Override
    public void force(boolean metaData) throws IOException {
        throw new IllegalAccessError(METHOD_NOT_IMPL_MSG);
    }

    @Override
    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        throw new IllegalAccessError(METHOD_NOT_IMPL_MSG);
    }

    @Override
    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        throw new IllegalAccessError(METHOD_NOT_IMPL_MSG);
    }

    @Override
    public int read(ByteBuffer dst, long position) throws IOException {
        throw new IllegalAccessError(METHOD_NOT_IMPL_MSG);
    }

    @Override
    public int write(ByteBuffer src, long position) throws IOException {
        throw new IllegalAccessError(METHOD_NOT_IMPL_MSG);
    }

    @Override
    public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
        throw new IllegalAccessError(METHOD_NOT_IMPL_MSG);
    }

    @Override
    public FileLock lock(long position, long size, boolean shared) throws IOException {
        throw new IllegalAccessError(METHOD_NOT_IMPL_MSG);
    }

    @Override
    public FileLock tryLock(long position, long size, boolean shared) throws IOException {
        throw new IllegalAccessError(METHOD_NOT_IMPL_MSG);
    }
}

