/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.agent.input.tail;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.codec.digest.DigestUtils;

public class FileSignature {
    public static final int MAX_FILE_SIGNATURE_SIZE = 4096;
    @JsonProperty
    @NonNull
    final String signature;
    @JsonProperty
    final int size;

    @JsonIgnore
    public boolean isComplete() {
        return this.size == 4096;
    }

    @JsonCreator
    public FileSignature(@JsonProperty(value="signature") String signature, @JsonProperty(value="size") int size) {
        this.signature = signature;
        this.size = size;
    }

    public static FileSignature calculateFileSignature(String fileName, FileChannel fc) throws IOException {
        return FileSignature.calculateFileSignature(fileName, fc, 0, 4096);
    }

    public static FileSignature calculateFileSignature(String fileName, FileChannel fc, int minSize, int maxSize) throws IOException {
        long length = fc.size();
        if (length < (long)minSize) {
            throw new IOException(String.format("File not long enough to compute signature, size is %d.", length));
        }
        int size = (int)Math.min(fc.size(), (long)maxSize);
        byte[] bytes = new byte[size];
        int signatureSize = fc.position(0L).read(ByteBuffer.wrap(bytes));
        if (signatureSize == -1) {
            signatureSize = size;
        }
        String signature = size < 4096 ? DigestUtils.sha256Hex((String)(new String(bytes, Charset.defaultCharset()) + fileName)) : DigestUtils.sha256Hex((String)new String(bytes, Charset.defaultCharset()));
        return new FileSignature(signature, signatureSize);
    }

    public String toString() {
        return String.format("%s^%d", this.signature, this.size);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileSignature)) {
            return false;
        }
        FileSignature other = (FileSignature)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        String this$signature = this.getSignature();
        String other$signature = other.getSignature();
        return !(this$signature == null ? other$signature != null : !this$signature.equals(other$signature));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FileSignature;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSize();
        String $signature = this.getSignature();
        result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String getSignature() {
        return this.signature;
    }

    @Generated
    public int getSize() {
        return this.size;
    }
}

