/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.agent.field;

import com.appdynamics.analytics.agent.field.ExtractedFieldsManager;
import com.appdynamics.analytics.agent.pipeline.dynamic.LogSourceJobFileParser;
import com.appdynamics.analytics.agent.source.LogSource;
import com.appdynamics.analytics.agent.source.LogSourceConfiguration;
import com.appdynamics.analytics.agent.source.LogSources;
import com.appdynamics.analytics.agent.sync.configuration.ConfigurationSyncEvent;
import com.appdynamics.analytics.pipeline.xform.grok.NonGrokPattern;
import com.appdynamics.common.util.concurrent.ConcurrencyHelper;
import com.appdynamics.common.util.event.EventBuses;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.SetMultimap;
import com.google.common.eventbus.Subscribe;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.GuardedBy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractedFieldsPoller {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExtractedFieldsPoller.class);
    private final LogSourceJobFileParser jobFileParser;
    @GuardedBy(value="this")
    private final LogSources logSources;
    private final ExtractedFieldsManager extractedFieldsManager;
    private final long pollIntervalMillis;
    private final long initialDelayMillis;
    private final EventBuses eventBuses;
    private ScheduledExecutorService backgroundTpe;
    private volatile boolean isRunning;

    public ExtractedFieldsPoller(LogSourceJobFileParser jobFileParser, LogSources logSources, ExtractedFieldsManager extractedFieldsManager, long pollIntervalMillis, long initialDelayMillis, EventBuses eventBuses) {
        this.jobFileParser = jobFileParser;
        this.logSources = logSources;
        this.extractedFieldsManager = extractedFieldsManager;
        this.initialDelayMillis = initialDelayMillis;
        this.pollIntervalMillis = pollIntervalMillis;
        this.eventBuses = eventBuses;
        this.isRunning = false;
    }

    @PostConstruct
    private void init() {
        this.start();
        this.eventBuses.registerListener("default-event-bus", (Object)this);
    }

    @PreDestroy
    private void shutdown() {
        this.stop();
    }

    @VisibleForTesting
    synchronized void start() {
        if (!this.isRunning) {
            this.backgroundTpe = Executors.newScheduledThreadPool(1, ConcurrencyHelper.newDaemonThreadFactory((String)"extracted-fields-poller-%d"));
            this.backgroundTpe.scheduleWithFixedDelay(this::onWakeUp, this.initialDelayMillis, this.pollIntervalMillis, TimeUnit.MILLISECONDS);
            log.info("Extracted fields poller started with poll interval [{}] ms and initial delay [{}] ms", (Object)this.pollIntervalMillis, (Object)this.initialDelayMillis);
            this.isRunning = true;
        }
    }

    @VisibleForTesting
    synchronized void stop() {
        if (this.isRunning) {
            ConcurrencyHelper.stop((ExecutorService)this.backgroundTpe, (int)1, (Logger)log);
            this.backgroundTpe = null;
            this.isRunning = false;
            log.info("Extracted fields poller stopped");
        }
    }

    @Subscribe
    @VisibleForTesting
    void onNewConfigurationSyncEvent(ConfigurationSyncEvent configurationSyncEvent) {
        Preconditions.checkNotNull((Object)configurationSyncEvent, (Object)"configurationSyncEvent can't be null");
        Preconditions.checkNotNull((Object)configurationSyncEvent.getAgentConfiguration(), (Object)"agentConfiguration can't be null");
        boolean isDisableAllLocalSources = configurationSyncEvent.getAgentConfiguration().isDisableAllLocalSources();
        log.debug("Received the following disableAllLocalSources flag value: [{}]", (Object)isDisableAllLocalSources);
        if (isDisableAllLocalSources && this.isRunning) {
            this.stop();
        } else if (!isDisableAllLocalSources && !this.isRunning) {
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onWakeUp() {
        LogSources logSources = this.logSources;
        synchronized (logSources) {
            try {
                ImmutableList<String> sourceTypes = this.getAllLocalSourceTypes();
                log.debug("Found the following enabled source types {}", sourceTypes);
                if (sourceTypes.isEmpty()) {
                    return;
                }
                SetMultimap<String, NonGrokPattern> extractedFieldPatterns = this.extractedFieldsManager.getExtractedFieldPatterns((List<String>)sourceTypes);
                for (LogSource logSource : this.logSources.getAllLocalSources()) {
                    try {
                        String sourceType = logSource.getSourceType();
                        String logSourceName = logSource.getName();
                        log.debug("Processing extracted field pattern configurations for log source [{}] with source type [{}]", (Object)logSourceName, (Object)sourceType);
                        Set<NonGrokPattern> currentPatterns = logSource.getExtractedFieldPatterns();
                        log.debug("The following extracted field patterns {} are currently being used by log source [{}]", currentPatterns, (Object)logSourceName);
                        Set newPatterns = extractedFieldPatterns.get((Object)sourceType);
                        log.debug("Retrieved new extracted field patterns {} for source type [{}]", (Object)newPatterns, (Object)sourceType);
                        if (Objects.equals(this.normalize(currentPatterns), this.normalize(newPatterns))) continue;
                        log.info("The current extracted field patterns for log source [{}] with source type [{}] were different from the newly retrieved set of extracted field patterns. The job pipeline for this log source will be updated with the latest configurations.", (Object)logSourceName, (Object)sourceType);
                        LogSourceConfiguration logSourceConfiguration = this.jobFileParser.parseLogSourceConfigurationFromFile(logSourceName);
                        this.logSources.upsertSource(logSourceConfiguration, true);
                    }
                    catch (Exception e) {
                        log.warn("An exception occurred while attempting to process extracted fields for log source [{}], therefore its associated pipeline configurations were not updated.", (Object)logSource.getName(), (Object)e);
                    }
                }
            }
            catch (Exception e) {
                log.warn("An exception occurred while attempting to poll for extracted field patterns, therefore the pipeline configurations were not updated", (Throwable)e);
            }
        }
    }

    private ImmutableList<String> getAllLocalSourceTypes() {
        Collection<LogSource> logSourceCollection = this.logSources.getAllLocalSources();
        HashSet<String> sourceTypes = new HashSet<String>();
        for (LogSource logSource : logSourceCollection) {
            sourceTypes.add(logSource.getSourceType());
        }
        return ImmutableList.copyOf(sourceTypes);
    }

    private Set<NonGrokPattern> normalize(Set<NonGrokPattern> set) {
        return set == null ? Collections.emptySet() : set;
    }
}

