/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.agent.field;

import com.appdynamics.analytics.pipeline.framework.PipelineConfiguration;
import com.appdynamics.analytics.pipeline.framework.PipelineStageConfiguration;
import com.appdynamics.analytics.pipeline.xform.grok.NonGrokPattern;
import com.appdynamics.analytics.shared.rest.client.eventservice.ExtractedFieldsClient;
import com.appdynamics.analytics.shared.rest.dto.ExtractedFieldDefinition;
import com.appdynamics.common.util.type.ValueType;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class ExtractedFieldsManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExtractedFieldsManager.class);
    private final ExtractedFieldsClient extractedFieldsClient;
    private final String accountName;
    private final String accessKey;
    private final String eventType;

    public ExtractedFieldsManager(ExtractedFieldsClient extractedFieldsClient, String accountName, String accessKey, String eventType) {
        this.extractedFieldsClient = extractedFieldsClient;
        this.accountName = accountName;
        this.accessKey = accessKey;
        this.eventType = eventType;
    }

    public Set<NonGrokPattern> getExtractedFieldPatterns(String sourceType) {
        if (Strings.isNullOrEmpty((String)sourceType)) {
            return Collections.emptySet();
        }
        SetMultimap<String, NonGrokPattern> extractedFieldPatterns = this.getExtractedFieldPatterns(Lists.newArrayList((Object[])new String[]{sourceType}));
        return extractedFieldPatterns.get((Object)sourceType);
    }

    public SetMultimap<String, NonGrokPattern> getExtractedFieldPatterns(List<String> sourceTypes) {
        HashMultimap extractedFieldPatterns = HashMultimap.create();
        List extractedFields = this.extractedFieldsClient.getExtractedFields(this.accountName, this.accessKey, this.eventType, sourceTypes);
        if (extractedFields == null || extractedFields.isEmpty()) {
            return extractedFieldPatterns;
        }
        for (ExtractedFieldDefinition extractedField : extractedFields) {
            NonGrokPattern grokPattern = new NonGrokPattern(extractedField.getPattern(), extractedField.getName(), this.extractedFieldTypeToGrokValueType(extractedField.getDataType()));
            extractedFieldPatterns.put((Object)extractedField.getSourceType(), (Object)grokPattern);
        }
        return extractedFieldPatterns;
    }

    private ValueType extractedFieldTypeToGrokValueType(ExtractedFieldDefinition.DataType dataType) {
        switch (dataType) {
            case BOOLEAN: {
                return ValueType.BOOLEAN;
            }
            case NUMBER: {
                return ValueType.NUMBER;
            }
        }
        return ValueType.STRING;
    }

    public void addExtractedFieldPatterns(PipelineConfiguration pipelineConfiguration, Set<NonGrokPattern> extractedFieldPatterns) {
        if (extractedFieldPatterns == null || extractedFieldPatterns.isEmpty()) {
            return;
        }
        List<NonGrokPattern> grokPatterns = this.getNonGrokPatterns(pipelineConfiguration);
        if (grokPatterns == null) {
            this.createGrokStageAndAddExtractedFieldPatterns(pipelineConfiguration, extractedFieldPatterns);
        } else {
            grokPatterns.addAll(extractedFieldPatterns);
        }
    }

    List<NonGrokPattern> getNonGrokPatterns(PipelineConfiguration pipelineConfiguration) {
        for (PipelineStageConfiguration stage : pipelineConfiguration.getStages()) {
            if (!"xform:grok".equals(stage.getUri())) continue;
            HashMap<String, Object> stageProperties = stage.getProperties();
            if (stageProperties == null) {
                stageProperties = new HashMap<String, Object>();
            }
            stageProperties.computeIfAbsent("nonGrokPatterns", k -> Lists.newArrayList());
            return (List)stageProperties.get("nonGrokPatterns");
        }
        return null;
    }

    void createGrokStageAndAddExtractedFieldPatterns(PipelineConfiguration pipelineConfiguration, Set<NonGrokPattern> extractedFieldPatterns) {
        List stageConfigurations = pipelineConfiguration.getStages();
        int indexOfAddFieldScriptsStage = -1;
        Iterator stageConfigurationsIterator = stageConfigurations.iterator();
        int i = 0;
        while (stageConfigurationsIterator.hasNext()) {
            PipelineStageConfiguration stageConfiguration = (PipelineStageConfiguration)stageConfigurationsIterator.next();
            if ("xform:field:add".equals(stageConfiguration.getUri())) {
                indexOfAddFieldScriptsStage = i;
                break;
            }
            ++i;
        }
        if (indexOfAddFieldScriptsStage == -1) {
            throw new IllegalStateException(String.format("Could not find pipeline stage [%s] in pipeline configuration with id [%s]", "xform:field:add", pipelineConfiguration.getId()));
        }
        int indexOfGrokStage = indexOfAddFieldScriptsStage + 1;
        HashMap<String, ArrayList> grokStageProperties = new HashMap<String, ArrayList>(1);
        grokStageProperties.put("nonGrokPatterns", Lists.newArrayList(extractedFieldPatterns));
        PipelineStageConfiguration grokStageConfiguration = new PipelineStageConfiguration();
        grokStageConfiguration.setUri("xform:grok");
        grokStageConfiguration.setProperties(grokStageProperties);
        stageConfigurations.add(indexOfGrokStage, grokStageConfiguration);
    }
}

