/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.agent.executor;

import com.appdynamics.analytics.agent.AnalyticsAgent;
import com.appdynamics.analytics.agent.executor.command.AgentStartCommand;
import com.appdynamics.analytics.agent.executor.command.windows.AgentInstallServiceCommand;
import com.appdynamics.analytics.agent.executor.command.windows.AgentRunServiceInternalCommand;
import com.appdynamics.analytics.agent.executor.command.windows.AgentStartServiceCommand;
import com.appdynamics.analytics.agent.executor.command.windows.AgentStopServiceCommand;
import com.appdynamics.analytics.agent.executor.command.windows.AgentUninstallServiceCommand;
import com.appdynamics.common.executor.Arguments;
import com.appdynamics.common.executor.CommandExecutor;
import com.appdynamics.common.executor.command.AppHealthCheckCommand;
import com.appdynamics.common.executor.command.AppShutdownTaskCommand;
import com.appdynamics.common.executor.command.AppStopCommand;
import com.appdynamics.common.executor.command.windows.AppListServiceCommand;
import com.appdynamics.common.executor.standalone.ActualMainLogHelper;
import com.google.common.base.Throwables;
import java.util.ArrayList;
import org.apache.commons.lang.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyticsAgentExecutor {
    private static final Logger LOGGER;

    public static void main(String[] args) {
        ArrayList<Object> commandList = new ArrayList<Object>();
        String mainClassName = AnalyticsAgent.class.getName();
        if (SystemUtils.IS_OS_WINDOWS) {
            commandList.add((Object)new com.appdynamics.analytics.agent.executor.command.windows.AgentStartCommand(mainClassName));
            commandList.add(new AppShutdownTaskCommand());
            commandList.add((Object)new AgentInstallServiceCommand("tool-executor.jar", mainClassName));
            commandList.add((Object)new AgentStartServiceCommand());
            commandList.add((Object)new AgentStopServiceCommand());
            commandList.add((Object)new AgentUninstallServiceCommand());
            commandList.add(new AppListServiceCommand());
            commandList.add((Object)new AgentRunServiceInternalCommand());
        } else {
            commandList.add((Object)new AgentStartCommand(mainClassName));
            commandList.add(new AppStopCommand());
        }
        commandList.add(new AppHealthCheckCommand());
        try {
            CommandExecutor commandExecutor = new CommandExecutor(commandList);
            commandExecutor.execute(new Arguments(args));
        }
        catch (Throwable t) {
            if (LOGGER.isDebugEnabled()) {
                throw t;
            }
            String err = Throwables.getRootCause((Throwable)t).getMessage();
            LOGGER.error("Error occurred [{}]", (Object)err);
            System.exit(1);
        }
    }

    static {
        ActualMainLogHelper.initLogger();
        LOGGER = LoggerFactory.getLogger(AnalyticsAgentExecutor.class);
    }
}

