/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.agent;

import com.appdynamics.common.framework.AbstractApp;
import com.appdynamics.common.framework.AppConfiguration;
import com.appdynamics.common.framework.util.EmbeddedModeSecurityManager;
import com.appdynamics.common.framework.util.FrameworkHelper;
import com.appdynamics.common.framework.util.ShutdownTask;
import com.appdynamics.common.framework.util.SimpleApp;
import com.appdynamics.common.framework.util.VersionedAppConfiguration;
import com.appdynamics.common.util.configuration.property.ConfigurationProperties;
import com.google.common.base.Optional;
import io.dropwizard.core.setup.Environment;
import io.dropwizard.servlets.tasks.Task;
import java.util.ArrayList;
import java.util.Arrays;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyticsAgent {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnalyticsAgent.class);
    static final String ILLEGAL_ARGS_MSG = "The path to the properties file must be provided";
    static final String PKG_ANALYTICS = "com.appdynamics.analytics";
    static final String PKG_COMMON_FRAMEWORK = "com.appdynamics.common.framework";

    static String[] validateAndMakeArgs(String[] args) {
        if (args.length < 1 || args.length > 2) {
            throw new IllegalArgumentException(ILLEGAL_ARGS_MSG);
        }
        ArrayList<String> appArgs = new ArrayList<String>();
        if (args.length == 1) {
            appArgs.add("-p");
            appArgs.add(args[0]);
        } else {
            appArgs.add(args[0]);
            appArgs.add(args[1]);
        }
        appArgs.add("-yr");
        appArgs.add("analytics-agent.yml");
        String[] newArgs = appArgs.toArray(new String[appArgs.size()]);
        Pair params = null;
        try {
            params = AbstractApp.validate((String[])newArgs);
        }
        catch (IllegalArgumentException e) {
            log.trace("Internal exception", (Throwable)e);
            throw new IllegalArgumentException(ILLEGAL_ARGS_MSG);
        }
        if (params == null || !((Optional)params.getRight()).isPresent()) {
            throw new IllegalArgumentException(ILLEGAL_ARGS_MSG);
        }
        log.info("Starting analytics agent with arguments {}", Arrays.asList(newArgs));
        return newArgs;
    }

    public static void main(String[] args) throws Exception {
        String embeddedStr = System.getProperty("analytics.mode.embedded", "false");
        String installCustomSM = System.getProperty("analytics.custom.security.manager.enabled", "true");
        boolean embedded = Boolean.parseBoolean(embeddedStr);
        boolean installSM = Boolean.parseBoolean(installCustomSM);
        if (embedded && installSM) {
            EmbeddedModeSecurityManager.installSecurityManager((String[])new String[]{PKG_COMMON_FRAMEWORK, PKG_ANALYTICS});
        }
        String[] newArgs = AnalyticsAgent.validateAndMakeArgs(args);
        SimpleApp<VersionedAppConfiguration> app = new SimpleApp<VersionedAppConfiguration>(embedded){

            protected void beforeModuleLoading(VersionedAppConfiguration conf, Environment env) {
                FrameworkHelper.checkVersionsMatch((int)21, (VersionedAppConfiguration)conf, (ConfigurationProperties)this.configurationProperties, (Optional)Optional.of((Object)"ad.configuration.version"));
                env.admin().addTask((Task)new ShutdownTask());
                super.beforeModuleLoading((AppConfiguration)conf, env);
            }
        };
        app.runUsingTemplate(newArgs);
    }
}

