/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.client.common.exceptions;

import com.appdynamics.analytics.client.common.exceptions.RestExceptionPayload;
import com.google.common.base.Throwables;
import lombok.Generated;

public class RestException
extends RuntimeException {
    private static final String MESSAGE_TEMPLATE = "Status code: [%d], Message: %s";
    private static final long serialVersionUID = 1L;
    private int statusCode;
    private String code;
    private String errorMessage;
    private String developerMessage;
    private String logCorrelationId;

    public RestException(RestExceptionPayload payload) {
        super(String.format(MESSAGE_TEMPLATE, payload.getStatusCode(), payload.getMessage()));
        this.statusCode = payload.getStatusCode();
        this.code = payload.getCode();
        this.errorMessage = payload.getMessage();
        this.developerMessage = payload.getDeveloperMessage();
        this.logCorrelationId = payload.getLogCorrelationId();
    }

    public RestException(int statusCode, String message) {
        super(String.format(MESSAGE_TEMPLATE, statusCode, message));
        this.statusCode = statusCode;
        this.errorMessage = message;
        this.developerMessage = Throwables.getStackTraceAsString((Throwable)this);
    }

    public RestException(int statusCode, String message, Throwable cause) {
        super(String.format(MESSAGE_TEMPLATE, statusCode, message), cause);
        this.statusCode = statusCode;
        this.errorMessage = message;
        this.developerMessage = Throwables.getStackTraceAsString((Throwable)this);
    }

    public RestException(int statusCode, String message, String developerMessage) {
        super(String.format(MESSAGE_TEMPLATE, statusCode, message));
        this.statusCode = statusCode;
        this.errorMessage = message;
        this.developerMessage = developerMessage;
    }

    @Generated
    public RestException() {
    }

    @Generated
    public int getStatusCode() {
        return this.statusCode;
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Generated
    public String getDeveloperMessage() {
        return this.developerMessage;
    }

    @Generated
    public String getLogCorrelationId() {
        return this.logCorrelationId;
    }

    @Override
    @Generated
    public String toString() {
        return "RestException(statusCode=" + this.getStatusCode() + ", code=" + this.getCode() + ", errorMessage=" + this.getErrorMessage() + ", developerMessage=" + this.getDeveloperMessage() + ", logCorrelationId=" + this.getLogCorrelationId() + ")";
    }
}

