/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.client.common;

import com.appdynamics.analytics.client.common.AsyncObjectResponseHandler;
import com.appdynamics.analytics.client.common.ResponseConsumer;
import com.appdynamics.analytics.client.common.io.ConnectedInputOutputStream;
import com.appdynamics.analytics.client.common.io.UnprotectedByteArrayInputStream;
import com.appdynamics.analytics.client.common.io.UnprotectedByteArrayOutputStream;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.xml.bind.DatatypeConverter;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SuccessResponseConsumer
extends ResponseConsumer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SuccessResponseConsumer.class);
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private final ConnectedInputOutputStream inputOutputStream = new ConnectedInputOutputStream(4096);

    SuccessResponseConsumer() {
    }

    @Override
    public void close() throws Exception {
        this.closeQuietly(this.inputOutputStream.getOutputStream());
        this.closeQuietly(this.inputOutputStream.getInputStream());
    }

    @Override
    <T> void onByteReceived(ByteBuffer buffer, AsyncObjectResponseHandler<T> asyncResponseHandler, Class<T> classType) throws IOException {
        int numBytes = -1;
        int objectSize = -1;
        int inputStreamAvailable = -1;
        try {
            boolean readObject;
            numBytes = buffer.limit();
            UnprotectedByteArrayOutputStream outputStream = this.inputOutputStream.getOutputStream();
            outputStream.write(buffer.array(), buffer.arrayOffset(), numBytes);
            do {
                readObject = false;
                this.inputOutputStream.resetInputFromOutputStream();
                UnprotectedByteArrayInputStream inputStream = this.inputOutputStream.getInputStream();
                objectSize = SuccessResponseConsumer.readIntegerFromInputStream(inputStream);
                if (objectSize <= 0 || (inputStreamAvailable = inputStream.available()) < objectSize) continue;
                int objectEndPosition = inputStream.getPosition() + objectSize;
                T obj = SuccessResponseConsumer.parseObject(inputStream, objectSize, classType);
                asyncResponseHandler.completeObject(obj);
                if (asyncResponseHandler.isDead()) {
                    return;
                }
                this.inputOutputStream.resetOutputStreamFromInputStreamPosition(objectEndPosition);
                readObject = true;
            } while (readObject);
        }
        catch (Exception e) {
            String bufferInHex = "na";
            try {
                byte[] tempBuffer = Arrays.copyOfRange(this.inputOutputStream.getOutputStream().getInternalBuffer(), 0, Math.min(this.inputOutputStream.getOutputStream().size(), 100));
                bufferInHex = DatatypeConverter.printHexBinary((byte[])tempBuffer);
            }
            catch (Exception e2) {
                log.error("There was an error processing the buffer.");
            }
            log.error("Failed to process received bytes as json object: numBytes=[{}], objectSize=[{}], available=[{}], bufferInHex=[{}]", new Object[]{numBytes, objectSize, inputStreamAvailable, bufferInHex});
            throw e;
        }
    }

    @Override
    <T> boolean onComplete(AsyncObjectResponseHandler<T> asyncResponseHandler) {
        return true;
    }

    @Override
    Logger getLogger() {
        return log;
    }

    private static <T> T parseObject(InputStream inputStream, int objectSize, Class<T> classType) throws IOException {
        return (T)OBJECT_MAPPER.readValue(ByteStreams.limit((InputStream)inputStream, (long)objectSize), classType);
    }

    private static int readIntegerFromInputStream(InputStream inputStream) throws IOException {
        int intValue = 0;
        int nextCh = inputStream.read();
        while (nextCh >= 48 && nextCh <= 57) {
            intValue = intValue * 10 + (nextCh - 48);
            nextCh = inputStream.read();
        }
        if (nextCh == 10) {
            return intValue;
        }
        if (nextCh != -1) {
            throw new IOException("Expected object size but found " + nextCh);
        }
        return -1;
    }
}

