/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.client.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Function;
import java.util.Stack;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingJsonDetector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StreamingJsonDetector.class);
    private static char CURLY_OPEN_BRACE = (char)123;
    private static char CURLY_END_BRACE = (char)125;
    private static char ARRAY_OPEN_BRACE = (char)91;
    private static char ARRAY_END_BRACE = (char)93;
    private static char QUOTE = (char)34;
    private static char ESCAPE = (char)92;
    private Function<String, JsonNode> callback;
    private StringBuilder charBuffer;
    private Stack<Character> braceStack;
    private boolean firstCharacter;
    private boolean lastPop;
    private boolean ignoreCharacters;
    private char previousCharacter;

    public StreamingJsonDetector(Function<String, JsonNode> callback) {
        this.callback = callback;
        this.charBuffer = new StringBuilder();
        this.braceStack = new Stack();
        this.firstCharacter = false;
        this.lastPop = false;
        this.ignoreCharacters = false;
        this.previousCharacter = '\u0000';
    }

    public synchronized void feed(String charContent) {
        for (char ch : charContent.toCharArray()) {
            if (!(this.firstCharacter || ch != CURLY_OPEN_BRACE && ch != ARRAY_OPEN_BRACE)) {
                this.firstCharacter = true;
            }
            if (this.firstCharacter) {
                this.charBuffer.append(ch);
                if (ch == QUOTE && this.previousCharacter != ESCAPE) {
                    boolean bl = this.ignoreCharacters = !this.ignoreCharacters;
                }
                if (!this.ignoreCharacters) {
                    boolean checkIfBraceMatch;
                    if (ch == CURLY_OPEN_BRACE || ch == ARRAY_OPEN_BRACE) {
                        this.braceStack.push(Character.valueOf(ch));
                    }
                    boolean bl = checkIfBraceMatch = ch == CURLY_END_BRACE && this.braceStack.peek().charValue() == CURLY_OPEN_BRACE || ch == ARRAY_END_BRACE && this.braceStack.peek().charValue() == ARRAY_OPEN_BRACE;
                    if (checkIfBraceMatch) {
                        this.braceStack.pop();
                        this.lastPop = true;
                    }
                    if (this.braceStack.empty() && this.lastPop) {
                        log.info("Json object detected [{}]", (Object)this.charBuffer.toString());
                        this.callback.apply((Object)this.charBuffer.toString());
                        this.charBuffer.setLength(0);
                        this.firstCharacter = false;
                        this.lastPop = false;
                    }
                }
            }
            this.previousCharacter = ch;
        }
    }

    public synchronized String getContent() {
        return this.charBuffer.toString();
    }

    public synchronized boolean isJsonParsed() {
        return this.braceStack.empty() && this.charBuffer.length() == 0;
    }
}

