/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.client.common;

import com.appdynamics.analytics.client.common.HttpEntityEnclosingRequestBuilder;
import com.appdynamics.analytics.client.common.HttpRequestBuilder;
import com.appdynamics.analytics.client.common.exceptions.ClientException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import java.beans.ConstructorProperties;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class HttpRequestFactory {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final ObjectMapper mapper;
    private final CloseableHttpClient client;
    private final URI baseUri;

    public static <T> T retryWithRequestFactory(HttpRequestExecutor<T> executor, CloseableHttpClient httpClient, String url, int maxRetries) {
        Throwable clientException = null;
        for (int attempt = 1; attempt <= maxRetries; ++attempt) {
            HttpRequestFactory requestFactory = HttpRequestFactory.buildRequestFactory(url, httpClient);
            try {
                return executor.execute(requestFactory);
            }
            catch (ClientException e) {
                clientException = e;
                if (e.getCause() instanceof SocketException || e.getCause() instanceof NoHttpResponseException) continue;
                throw Throwables.propagate((Throwable)e);
            }
        }
        String msg = "Failed after [" + maxRetries + "] retries" + (String)(clientException != null ? " with exception " + clientException.getMessage() : "");
        if (clientException != null) {
            throw new IllegalStateException(msg, clientException);
        }
        throw new IllegalStateException(msg);
    }

    public static HttpRequestFactory buildRequestFactory(String uriString, CloseableHttpClient httpClient) {
        URI uri;
        try {
            uri = new URI(uriString);
        }
        catch (URISyntaxException e) {
            throw Throwables.propagate((Throwable)e);
        }
        if (!uri.getScheme().equalsIgnoreCase("http") && !uri.getScheme().equalsIgnoreCase("https") || Strings.isNullOrEmpty((String)uri.getHost())) {
            throw new IllegalArgumentException("Invalid uri: " + String.valueOf(uri));
        }
        return new HttpRequestFactory(MAPPER, httpClient, uri);
    }

    public static CloseableHttpClient buildHttpClient(long timeout, TimeUnit timeoutUnit) {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout((int)TimeUnit.MILLISECONDS.convert(timeout, timeoutUnit)).build();
        PoolingHttpClientConnectionManager cManager = new PoolingHttpClientConnectionManager();
        cManager.setDefaultMaxPerRoute(20);
        cManager.setMaxTotal(200);
        return HttpClients.custom().setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)cManager).build();
    }

    private RequestConfig getCustomRequestConfig(int connTimeout, int connRequestTimeout, int socketTimeout) {
        return RequestConfig.custom().setConnectTimeout(connTimeout).setConnectionRequestTimeout(connRequestTimeout).setSocketTimeout(socketTimeout).build();
    }

    public HttpEntityEnclosingRequestBuilder post() {
        return (HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)new HttpEntityEnclosingRequestBuilder(new HttpPost()).setUri(this.baseUri)).using(this.mapper)).using(this.client);
    }

    public HttpEntityEnclosingRequestBuilder post(int connTimeout, int connRequestTimeout, int socketTimeout) {
        HttpPost post = new HttpPost();
        post.setConfig(this.getCustomRequestConfig(connTimeout, connRequestTimeout, socketTimeout));
        return (HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)new HttpEntityEnclosingRequestBuilder(post).setUri(this.baseUri)).using(this.mapper)).using(this.client);
    }

    public HttpEntityEnclosingRequestBuilder patch() {
        return (HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)new HttpEntityEnclosingRequestBuilder(new HttpPatch()).setUri(this.baseUri)).using(this.mapper)).using(this.client);
    }

    public HttpEntityEnclosingRequestBuilder patch(int connTimeout, int connRequestTimeout, int socketTimeout) {
        HttpPatch patch = new HttpPatch();
        patch.setConfig(this.getCustomRequestConfig(connTimeout, connRequestTimeout, socketTimeout));
        return (HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)new HttpEntityEnclosingRequestBuilder(patch).setUri(this.baseUri)).using(this.mapper)).using(this.client);
    }

    public HttpEntityEnclosingRequestBuilder put() {
        return (HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)new HttpEntityEnclosingRequestBuilder(new HttpPut()).setUri(this.baseUri)).using(this.mapper)).using(this.client);
    }

    public HttpEntityEnclosingRequestBuilder put(int connTimeout, int connRequestTimeout, int socketTimeout) {
        HttpPut put = new HttpPut();
        put.setConfig(this.getCustomRequestConfig(connTimeout, connRequestTimeout, socketTimeout));
        return (HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)((HttpEntityEnclosingRequestBuilder)new HttpEntityEnclosingRequestBuilder(put).setUri(this.baseUri)).using(this.mapper)).using(this.client);
    }

    public HttpRequestBuilder get() {
        return (HttpRequestBuilder)((HttpRequestBuilder)((HttpRequestBuilder)new HttpRequestBuilder((HttpRequestBase)new HttpGet()).setUri(this.baseUri)).using(this.mapper)).using(this.client);
    }

    public HttpRequestBuilder get(int connTimeout, int connRequestTimeout, int socketTimeout) {
        HttpGet get = new HttpGet();
        get.setConfig(this.getCustomRequestConfig(connTimeout, connRequestTimeout, socketTimeout));
        return (HttpRequestBuilder)((HttpRequestBuilder)((HttpRequestBuilder)new HttpRequestBuilder((HttpRequestBase)get).setUri(this.baseUri)).using(this.mapper)).using(this.client);
    }

    public HttpRequestBuilder head() {
        return (HttpRequestBuilder)((HttpRequestBuilder)((HttpRequestBuilder)new HttpRequestBuilder((HttpRequestBase)new HttpHead()).setUri(this.baseUri)).using(this.mapper)).using(this.client);
    }

    public HttpRequestBuilder head(int connTimeout, int connRequestTimeout, int socketTimeout) {
        HttpHead head = new HttpHead();
        head.setConfig(this.getCustomRequestConfig(connTimeout, connRequestTimeout, socketTimeout));
        return (HttpRequestBuilder)((HttpRequestBuilder)((HttpRequestBuilder)new HttpRequestBuilder((HttpRequestBase)head).setUri(this.baseUri)).using(this.mapper)).using(this.client);
    }

    public HttpRequestBuilder delete() {
        return (HttpRequestBuilder)((HttpRequestBuilder)((HttpRequestBuilder)new HttpRequestBuilder((HttpRequestBase)new HttpDelete()).setUri(this.baseUri)).using(this.mapper)).using(this.client);
    }

    public HttpRequestBuilder delete(int connTimeout, int connRequestTimeout, int socketTimeout) {
        HttpDelete delete = new HttpDelete();
        delete.setConfig(this.getCustomRequestConfig(connTimeout, connRequestTimeout, socketTimeout));
        return (HttpRequestBuilder)((HttpRequestBuilder)((HttpRequestBuilder)new HttpRequestBuilder((HttpRequestBase)delete).setUri(this.baseUri)).using(this.mapper)).using(this.client);
    }

    public URI getBaseURI() {
        return this.baseUri;
    }

    @ConstructorProperties(value={"mapper", "client", "baseUri"})
    @Generated
    public HttpRequestFactory(ObjectMapper mapper, CloseableHttpClient client, URI baseUri) {
        this.mapper = mapper;
        this.client = client;
        this.baseUri = baseUri;
    }

    public static interface HttpRequestExecutor<T> {
        public T execute(HttpRequestFactory var1);
    }
}

