/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.client.common;

import com.appdynamics.analytics.client.common.StreamingJsonDetector;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import java.io.IOException;
import java.nio.CharBuffer;
import lombok.Generated;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.client.methods.AsyncCharConsumer;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkCallbackResponseConsumer
extends AsyncCharConsumer<Boolean> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ChunkCallbackResponseConsumer.class);
    private static ObjectMapper objectMapper = new ObjectMapper();
    private final FutureCallback<JsonNode> callback;
    private final int expectedHttpStatusCode;
    private final StreamingJsonDetector jsonDetector;
    private volatile HttpResponse response;

    public ChunkCallbackResponseConsumer(FutureCallback<JsonNode> chunkCallBack, int expectedHttpStatusCode) {
        this.callback = chunkCallBack;
        this.expectedHttpStatusCode = expectedHttpStatusCode;
        this.jsonDetector = new StreamingJsonDetector(this.jsonBuilderFunction());
    }

    protected void onCharReceived(CharBuffer buffer, IOControl ioctrl) throws IOException {
        this.jsonDetector.feed(buffer.toString());
    }

    protected void onResponseReceived(HttpResponse response) throws HttpException, IOException {
        this.response = response;
    }

    protected Boolean buildResult(HttpContext context) throws Exception {
        if (this.response.getStatusLine().getStatusCode() != this.expectedHttpStatusCode) {
            return false;
        }
        return true;
    }

    private Function<String, JsonNode> jsonBuilderFunction() {
        return new Function<String, JsonNode>(){

            public JsonNode apply(String content) {
                JsonNode jsonNode = null;
                try {
                    jsonNode = objectMapper.readTree(content);
                    if (ChunkCallbackResponseConsumer.this.callback != null) {
                        ChunkCallbackResponseConsumer.this.callback.completed((Object)jsonNode);
                    }
                }
                catch (JsonProcessingException ioe) {
                    log.error("Invalid Json passed from the server", (Throwable)ioe);
                }
                catch (IOException ex) {
                    log.error("Invalid Json passed from the server", (Throwable)ex);
                }
                return jsonNode;
            }
        };
    }
}

