/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.client.common;

import com.appdynamics.analytics.client.common.AsyncObjectResponseHandler;
import com.appdynamics.analytics.client.common.ErrorResponseConsumer;
import com.appdynamics.analytics.client.common.ResponseConsumer;
import com.appdynamics.analytics.client.common.SuccessResponseConsumer;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.nio.ByteBuffer;
import lombok.Generated;
import lombok.NonNull;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.client.methods.AsyncByteConsumer;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncObjectResponseConsumer<T>
extends AsyncByteConsumer<Boolean> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncObjectResponseConsumer.class);
    private final int expectedHttpStatusCode;
    @NonNull
    private final Class<T> classType;
    @NonNull
    private final AsyncObjectResponseHandler<T> asyncResponseHandler;
    private volatile boolean isIoCtrlClosed;
    protected ResponseConsumer responseConsumerDelegate;

    protected void onResponseReceived(HttpResponse response) throws HttpException, IOException {
        if (this.isDead()) {
            return;
        }
        this.responseConsumerDelegate = response.getStatusLine().getStatusCode() == this.expectedHttpStatusCode ? new SuccessResponseConsumer() : new ErrorResponseConsumer(response);
    }

    protected void onByteReceived(ByteBuffer buffer, IOControl ioctrl) throws IOException {
        if (this.isDead()) {
            this.close(ioctrl);
            return;
        }
        try {
            Preconditions.checkState((this.responseConsumerDelegate != null ? 1 : 0) != 0, (Object)"Expected the responseConsumerDelegate to be non-null as 'onResponseReceived' should have been called first to set this.");
            this.responseConsumerDelegate.onByteReceived(buffer, this.asyncResponseHandler, this.classType);
        }
        catch (IOException e) {
            this.asyncResponseHandler.failed(e);
            this.close(ioctrl);
        }
        if (this.isDead()) {
            this.close(ioctrl);
        }
    }

    protected Boolean buildResult(HttpContext context) throws Exception {
        return !this.isDead() && this.responseConsumerDelegate.onComplete(this.asyncResponseHandler);
    }

    protected void releaseResources() {
        try {
            this.responseConsumerDelegate.close();
        }
        catch (Exception e) {
            log.error("Failed to close resource.", (Throwable)e);
        }
        this.isIoCtrlClosed = false;
        this.responseConsumerDelegate = null;
    }

    protected boolean isDead() {
        return this.asyncResponseHandler.isDead() || this.getException() != null;
    }

    private void close(IOControl ioctrl) {
        if (this.isIoCtrlClosed) {
            return;
        }
        try {
            if (ioctrl != null) {
                ioctrl.shutdown();
            }
        }
        catch (IOException e) {
            log.error("Failed to close connection.", (Throwable)e);
        }
        this.isIoCtrlClosed = true;
    }

    @ConstructorProperties(value={"expectedHttpStatusCode", "classType", "asyncResponseHandler"})
    @Generated
    public AsyncObjectResponseConsumer(int expectedHttpStatusCode, @NonNull Class<T> classType, @NonNull AsyncObjectResponseHandler<T> asyncResponseHandler) {
        if (classType == null) {
            throw new IllegalArgumentException("classType is marked non-null but is null");
        }
        if (asyncResponseHandler == null) {
            throw new IllegalArgumentException("asyncResponseHandler is marked non-null but is null");
        }
        this.expectedHttpStatusCode = expectedHttpStatusCode;
        this.classType = classType;
        this.asyncResponseHandler = asyncResponseHandler;
    }

    @Generated
    public int getExpectedHttpStatusCode() {
        return this.expectedHttpStatusCode;
    }
}

