/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.client.common;

import com.appdynamics.analytics.client.common.AdvancedNHttpClientConnectionManager;
import com.appdynamics.analytics.client.common.AsyncHttpResponseConsumer;
import com.appdynamics.analytics.client.common.AsyncObjectResponseConsumer;
import com.appdynamics.analytics.client.common.AsyncObjectResponseHandler;
import com.appdynamics.analytics.client.common.AsyncStringResponseConsumer;
import com.appdynamics.analytics.client.common.BaseAnalyticsClient;
import com.appdynamics.analytics.client.common.ChunkCallbackResponseConsumer;
import com.appdynamics.analytics.client.common.DefaultHeadersBuilder;
import com.appdynamics.analytics.client.common.FutureCallbackHandlerAdapter;
import com.appdynamics.analytics.client.common.GenericHttpRequestBuilder;
import com.appdynamics.analytics.client.common.HttpClientAndConnectionManager;
import com.appdynamics.analytics.client.common.HttpEntityEnclosingRequestBuilder;
import com.appdynamics.analytics.client.common.HttpRequestFactory;
import com.appdynamics.analytics.client.common.InstrumentedNClientConnManager;
import com.appdynamics.analytics.client.common.RequestCancellableFuture;
import com.appdynamics.analytics.client.common.exceptions.RestException;
import com.appdynamics.analytics.client.common.util.MetricsConfig;
import com.appdynamics.analytics.client.common.util.MetricsUtil;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.io.BaseEncoding;
import com.google.common.util.concurrent.RateLimiter;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLContext;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.concurrent.BasicFuture;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.config.Registry;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.client.methods.HttpAsyncMethods;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAsyncAnalyticsHttpClient
extends BaseAnalyticsClient
implements Closeable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractAsyncAnalyticsHttpClient.class);
    protected final AtomicReference<AdvancedNHttpClientConnectionManager> advancedNHttpClientConnectionManager = new AtomicReference();
    protected final Optional<MetricRegistry> metricRegistry;
    protected final String metricPrefix;
    protected final String metricName;
    private final Builder clientBuilder;
    private final Lock clientLock = new ReentrantLock();
    private final RateLimiter clientCreationRateLimiter = RateLimiter.create((double)0.016666666666666666);
    private final Meter clientRecreateMeter;
    private final AtomicInteger inProcessRequestCount;
    protected float maxLeasedToMaxConnectionsLimit = 0.95f;
    protected float inProcessRequestToLeasedConnectionLimit = 0.2f;
    private volatile CloseableHttpAsyncClient client;

    protected AbstractAsyncAnalyticsHttpClient(Builder builder, ObjectMapper mapper, URI baseUri, MetricsConfig metricsConfig) {
        super(mapper, new HttpRequestFactory(mapper, null, baseUri));
        Preconditions.checkNotNull((Object)builder);
        Preconditions.checkNotNull((Object)metricsConfig);
        this.clientBuilder = builder;
        this.metricRegistry = Optional.fromNullable((Object)metricsConfig.getMetricRegistry());
        this.metricPrefix = metricsConfig.getMetricsPrefix();
        this.metricName = metricsConfig.getMetricsName();
        HttpClientAndConnectionManager httpClientAndConnectionManager = this.clientBuilder.getOrCreateAsyncClient(this.metricRegistry, this.metricPrefix, this.metricName);
        this.advancedNHttpClientConnectionManager.set(httpClientAndConnectionManager.getConnectionManager());
        this.client = httpClientAndConnectionManager.getHttpClient();
        this.inProcessRequestCount = new AtomicInteger(0);
        this.client.start();
        if (this.metricRegistry.isPresent()) {
            this.clientRecreateMeter = ((MetricRegistry)this.metricRegistry.get()).meter(MetricRegistry.name((String)this.metricPrefix, (String[])new String[]{this.metricName, "client-recreation"}));
            ((MetricRegistry)this.metricRegistry.get()).gauge(MetricRegistry.name((String)this.metricPrefix, (String[])new String[]{this.metricName, "in-process-request"}), (MetricRegistry.MetricSupplier)new MetricRegistry.MetricSupplier<Gauge>(){

                public Gauge newMetric() {
                    return new Gauge<Integer>(){

                        public Integer getValue() {
                            return AbstractAsyncAnalyticsHttpClient.this.inProcessRequestCount.get();
                        }
                    };
                }
            });
        } else {
            this.clientRecreateMeter = MetricsUtil.NO_OP_METER;
        }
    }

    protected AbstractAsyncAnalyticsHttpClient(Builder builder, ObjectMapper mapper, URI baseUri) {
        this(builder, mapper, baseUri, MetricsConfig.EMPTY_METRICS_CONFIG);
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    protected <T> Future<T> submitAsync(GenericHttpRequestBuilder httpEntityBuilder, FutureCallback<T> callback, Class<T> classType) {
        if (httpEntityBuilder instanceof HttpEntityEnclosingRequestBuilder) {
            Preconditions.checkArgument((boolean)((HttpEntityEnclosingRequestBuilder)httpEntityBuilder).isGzipDisabled(), (Object)"The async client does not support gzip enabled requests");
        }
        if (this.clientCreationRateLimiter.tryAcquire() && this.needsClientRecreation()) {
            this.ensureClientRunning();
        }
        try {
            Preconditions.checkNotNull((Object)httpEntityBuilder, (Object)"Request Builder Empty");
            Pair<HttpUriRequest, HttpHost> requestParams = this.formRequestParams(httpEntityBuilder);
            HttpUriRequest uriRequest = (HttpUriRequest)requestParams.getLeft();
            HttpHost target = (HttpHost)requestParams.getRight();
            this.inProcessRequestCount.incrementAndGet();
            Future future = this.client.execute(HttpAsyncMethods.create((HttpHost)target, (HttpRequest)uriRequest), new AsyncHttpResponseConsumer<T>(httpEntityBuilder, classType), new InProcessCallsAdapter<T>(callback));
            return new RequestCancellableFuture(future, uriRequest);
        }
        catch (ClientProtocolException ex) {
            BasicFuture future = new BasicFuture(new InProcessCallsAdapter<T>(callback));
            future.failed((Exception)((Object)ex));
            return future;
        }
        catch (Exception e) {
            this.inProcessRequestCount.decrementAndGet();
            this.ensureClientRunning();
            throw e;
        }
    }

    private void ensureClientRunning() {
        block7: {
            if (!this.needsClientRecreation()) {
                return;
            }
            if (this.clientLock.tryLock()) {
                try {
                    if (!this.needsClientRecreation()) break block7;
                    HttpClientAndConnectionManager httpClientAndConnectionManager = this.clientBuilder.ioReactor(null).client((HttpClientAndConnectionManager)null).getOrCreateAsyncClient(this.metricRegistry, this.metricPrefix, this.metricName);
                    httpClientAndConnectionManager.getHttpClient().start();
                    try {
                        this.client.close();
                    }
                    catch (IOException e1) {
                        log.warn("Failed to close CloseableHttpAsyncClient", (Throwable)e1);
                    }
                    this.clientRecreateMeter.mark();
                    this.inProcessRequestCount.set(0);
                    this.advancedNHttpClientConnectionManager.set(httpClientAndConnectionManager.getConnectionManager());
                    this.client = httpClientAndConnectionManager.getHttpClient();
                    log.info("Created new instance of CloseableHttpAsyncClient in" + this.getClass().getName());
                }
                finally {
                    this.clientLock.unlock();
                }
            }
        }
    }

    protected boolean needsClientRecreation() {
        return !this.client.isRunning() || this.advancedNHttpClientConnectionManager.get().getNumOfMaxConnection() > 1 && this.advancedNHttpClientConnectionManager.get().getLeasedToMaxConnectionsRatio() >= (double)this.maxLeasedToMaxConnectionsLimit && this.getInProcessRequestToLeasedConnectionRatio() <= (double)this.inProcessRequestToLeasedConnectionLimit;
    }

    private double getInProcessRequestToLeasedConnectionRatio() {
        double ratio = (double)this.inProcessRequestCount.get() / (double)this.advancedNHttpClientConnectionManager.get().getSumOfRouteSpecificLeasedConnection();
        return Math.abs(ratio) <= Double.MAX_VALUE ? ratio : Double.MAX_VALUE;
    }

    protected Future<Boolean> submitAsyncString(GenericHttpRequestBuilder httpEntityBuilder, AsyncObjectResponseHandler<String> objectResponseHandler, int expectedHttpStatusCode) {
        return this.submitAsyncObjectStreamWithConsumer(httpEntityBuilder, new AsyncStringResponseConsumer(expectedHttpStatusCode, objectResponseHandler), new FutureCallbackHandlerAdapter<String>(objectResponseHandler));
    }

    protected <T> Future<Boolean> submitAsyncObjectStream(GenericHttpRequestBuilder httpEntityBuilder, AsyncObjectResponseHandler<T> objectResponseHandler, int expectedHttpStatusCode, Class<T> classType) {
        return this.submitAsyncObjectStreamWithConsumer(httpEntityBuilder, new AsyncObjectResponseConsumer<T>(expectedHttpStatusCode, classType, objectResponseHandler), new FutureCallbackHandlerAdapter<T>(objectResponseHandler));
    }

    private <T> Future<Boolean> submitAsyncObjectStreamWithConsumer(GenericHttpRequestBuilder httpEntityBuilder, AsyncObjectResponseConsumer<T> objectResponseConsumer, FutureCallbackHandlerAdapter<T> futureCallback) {
        if (this.clientCreationRateLimiter.tryAcquire() && this.needsClientRecreation()) {
            this.ensureClientRunning();
        }
        try {
            Preconditions.checkNotNull((Object)httpEntityBuilder, (Object)"Request Builder Empty");
            Pair<HttpUriRequest, HttpHost> requestParams = this.formRequestParams(httpEntityBuilder);
            HttpUriRequest uriRequest = (HttpUriRequest)requestParams.getLeft();
            HttpHost target = (HttpHost)requestParams.getRight();
            this.inProcessRequestCount.incrementAndGet();
            Future future = this.client.execute(HttpAsyncMethods.create((HttpHost)target, (HttpRequest)uriRequest), objectResponseConsumer, new InProcessCallsAdapter<Boolean>(futureCallback));
            return new RequestCancellableFuture<Boolean>(future, uriRequest);
        }
        catch (ClientProtocolException ex) {
            BasicFuture future = new BasicFuture(new InProcessCallsAdapter(null));
            future.failed((Exception)((Object)ex));
            return future;
        }
        catch (Exception e) {
            this.inProcessRequestCount.decrementAndGet();
            this.ensureClientRunning();
            throw e;
        }
    }

    protected Future<Boolean> submitAsyncChunk(GenericHttpRequestBuilder httpEntityBuilder, FutureCallback<JsonNode> chunkCallback, FutureCallback<Boolean> callback, int expectedHttpStatusCode) {
        if (this.clientCreationRateLimiter.tryAcquire() && this.needsClientRecreation()) {
            this.ensureClientRunning();
        }
        try {
            Preconditions.checkNotNull((Object)httpEntityBuilder, (Object)"Request Builder Empty");
            Pair<HttpUriRequest, HttpHost> requestParams = this.formRequestParams(httpEntityBuilder);
            HttpUriRequest uriRequest = (HttpUriRequest)requestParams.getLeft();
            HttpHost target = (HttpHost)requestParams.getRight();
            this.inProcessRequestCount.incrementAndGet();
            Future future = this.client.execute(HttpAsyncMethods.create((HttpHost)target, (HttpRequest)uriRequest), (HttpAsyncResponseConsumer)new ChunkCallbackResponseConsumer(chunkCallback, expectedHttpStatusCode), new InProcessCallsAdapter<Boolean>(callback));
            return new RequestCancellableFuture<Boolean>(future, uriRequest);
        }
        catch (ClientProtocolException ex) {
            BasicFuture future = new BasicFuture(new InProcessCallsAdapter<Boolean>(callback));
            future.failed((Exception)((Object)ex));
            return future;
        }
        catch (Exception e) {
            this.inProcessRequestCount.decrementAndGet();
            this.ensureClientRunning();
            throw e;
        }
    }

    private Pair<HttpUriRequest, HttpHost> formRequestParams(GenericHttpRequestBuilder httpEntityBuilder) throws ClientProtocolException {
        HttpUriRequest uriRequest;
        try {
            uriRequest = httpEntityBuilder.getHttpRequest();
        }
        catch (URISyntaxException e) {
            throw new RestException(400, "Malformed URI", e);
        }
        Preconditions.checkNotNull((Object)uriRequest, (Object)"HTTP request empty");
        HttpHost target = null;
        URI requestURI = uriRequest.getURI();
        if (requestURI.isAbsolute() && (target = URIUtils.extractHost((URI)requestURI)) == null) {
            throw new ClientProtocolException("URI does not specify a valid host name: " + String.valueOf(requestURI));
        }
        return Pair.of((Object)uriRequest, (Object)target);
    }

    public static abstract class Builder<T> {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(Builder.class);
        protected final String hostName;
        protected final int port;
        protected final String scheme;
        protected ObjectMapper mapper;
        protected HttpClientAndConnectionManager client;
        protected int maxTotalConnections = 200;
        protected int maxConnectionsPerRoute = 20;
        protected int socketTimeoutMillis = 30000;
        protected int connectionTimeoutMillis = 5000;
        protected int connectionRequestTimeout = 60000;
        protected ConnectingIOReactor ioReactor;
        protected SSLContext sslContext = null;
        protected SSLIOSessionStrategy sslioSessionStrategy;
        protected Registry<SchemeIOSessionStrategy> schemaIOSessionRegistry;
        protected String trustStorePasswordBase64 = null;
        protected String trustStoreFile = null;
        protected String trustStoreType = null;
        protected String httpProxyHost = null;
        protected Integer httpProxyPort = null;
        protected String httpProxyUsername = null;
        protected String httpProxyPassword = null;
        protected DefaultHeadersBuilder defaultHeadersBuilder = new DefaultHeadersBuilder();
        protected MetricsConfig metricsConfig = MetricsConfig.EMPTY_METRICS_CONFIG;

        public Builder(String scheme, String hostName, int port) {
            this.scheme = scheme;
            this.hostName = hostName;
            this.port = port;
        }

        public Builder(String scheme, String hostName, int port, MetricsConfig metricsConfig) {
            this.scheme = scheme;
            this.hostName = hostName;
            this.port = port;
            this.metricsConfig = metricsConfig;
        }

        public Builder(String hostName, int port) {
            this("http", hostName, port);
        }

        public Builder<T> maxTotalConnections(int maxTotalConnections) {
            this.maxTotalConnections = maxTotalConnections;
            return this;
        }

        public Builder<T> maxConnectionsPerRoute(int maxConnectionsPerRoute) {
            this.maxConnectionsPerRoute = maxConnectionsPerRoute;
            return this;
        }

        public Builder<T> socketTimeoutMillis(int socketTimeoutMillis) {
            this.socketTimeoutMillis = socketTimeoutMillis;
            return this;
        }

        public Builder<T> connectionTimeoutMillis(int connectionTimeoutMillis) {
            this.connectionTimeoutMillis = connectionTimeoutMillis;
            return this;
        }

        public Builder<T> sslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder<T> trustStoreConfig(String trustStoreFile, String trustStorePasswordBase64) {
            this.trustStorePasswordBase64 = trustStorePasswordBase64;
            this.trustStoreFile = trustStoreFile;
            return this;
        }

        public Builder<T> trustStoreConfig(String trustStoreFile, String trustStorePasswordBase64, String trustStoreType) {
            this.trustStorePasswordBase64 = trustStorePasswordBase64;
            this.trustStoreFile = trustStoreFile;
            this.trustStoreType = trustStoreType;
            return this;
        }

        public Builder<T> proxyConfig(String httpProxyHost, Integer httpProxyPort, String httpProxyUsername, String httpProxyPassword) {
            this.httpProxyHost = httpProxyHost;
            this.httpProxyPort = httpProxyPort;
            this.httpProxyUsername = httpProxyUsername;
            this.httpProxyPassword = httpProxyPassword;
            return this;
        }

        public Builder<T> requestorIdentifierHeader(String requestorIdentifierDefaultValue) {
            this.defaultHeadersBuilder.upsertHeader("Requestor-Identifier", requestorIdentifierDefaultValue);
            return this;
        }

        public Builder<T> socketFactoryRegistry(Registry<SchemeIOSessionStrategy> socketFactoryRegistry) {
            this.schemaIOSessionRegistry = socketFactoryRegistry;
            return this;
        }

        public Builder<T> mapper(ObjectMapper mapper) {
            this.mapper = mapper;
            return this;
        }

        public Builder<T> ioReactor(ConnectingIOReactor ioReactor) {
            this.ioReactor = ioReactor;
            return this;
        }

        public Builder<T> client(CloseableHttpClient client) {
            throw new UnsupportedOperationException("Supports CloseableHttpAsyncClient only");
        }

        public Builder<T> client(HttpClientAndConnectionManager asyncClient) {
            this.client = asyncClient;
            return this;
        }

        public T build() {
            if (this.mapper == null) {
                this.mapper = new ObjectMapper();
            }
            return this.buildInternal();
        }

        protected HttpClientAndConnectionManager getOrCreateAsyncClient(Optional<MetricRegistry> metricRegistry, String metricPrefix, String metricName) {
            if (this.client != null) {
                return this.client;
            }
            if (this.ioReactor == null) {
                try {
                    IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setConnectTimeout(this.connectionTimeoutMillis).setSoTimeout(this.socketTimeoutMillis).build();
                    this.ioReactor = new DefaultConnectingIOReactor(ioReactorConfig);
                }
                catch (IOReactorException e) {
                    throw new RuntimeException(e);
                }
            }
            HttpAsyncClientBuilder builder = HttpAsyncClients.custom();
            this.addProxyConfig(builder);
            this.setSslContext();
            InstrumentedNClientConnManager instrumentedNClientConnManager = this.schemaIOSessionRegistry != null ? new InstrumentedNClientConnManager(this.ioReactor, this.schemaIOSessionRegistry, metricRegistry, metricName, metricPrefix) : new InstrumentedNClientConnManager(this.ioReactor, metricRegistry, metricName, metricPrefix);
            instrumentedNClientConnManager.setMaxTotal(this.maxTotalConnections);
            instrumentedNClientConnManager.setDefaultMaxPerRoute(this.maxConnectionsPerRoute);
            CloseableHttpAsyncClient httpClient = builder.setConnectionManager((NHttpClientConnectionManager)instrumentedNClientConnManager).setSSLContext(this.sslContext).setDefaultRequestConfig(this.getRequestConfig()).setDefaultHeaders(this.defaultHeadersBuilder.build()).build();
            return new HttpClientAndConnectionManager(httpClient, instrumentedNClientConnManager);
        }

        private void addProxyConfig(HttpAsyncClientBuilder builder) {
            if (!Strings.isNullOrEmpty((String)this.httpProxyHost) && this.httpProxyPort != null) {
                HttpHost proxy = new HttpHost(this.httpProxyHost, this.httpProxyPort.intValue());
                builder.setProxy(proxy);
                if (!Strings.isNullOrEmpty((String)this.httpProxyUsername) && !Strings.isNullOrEmpty((String)this.httpProxyPassword)) {
                    BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                    UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.httpProxyUsername, this.httpProxyPassword);
                    credsProvider.setCredentials(new AuthScope(this.httpProxyHost, this.httpProxyPort.intValue()), (Credentials)credentials);
                    builder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
                }
            }
        }

        private void addGzipEncoding(HttpAsyncClientBuilder builder) {
            builder.addInterceptorFirst(new HttpRequestInterceptor(){

                public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                    if (!request.containsHeader("Accept-Encoding")) {
                        request.addHeader("Accept-Encoding", "gzip");
                    }
                }
            });
        }

        protected RequestConfig getRequestConfig() {
            return RequestConfig.custom().setSocketTimeout(this.socketTimeoutMillis).setConnectTimeout(this.connectionTimeoutMillis).setConnectionRequestTimeout(this.connectionRequestTimeout).build();
        }

        private void setSslContext() {
            if (this.sslContext == null) {
                try {
                    this.sslContext = this.buildSslContextFromTrustStoreOrDefault();
                }
                catch (Exception e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        }

        private static char[] base64ToClearAscii(String optBase64String) {
            if (optBase64String == null || optBase64String.length() == 0) {
                return null;
            }
            byte[] clearTxtPassword = BaseEncoding.base64().decode((CharSequence)optBase64String);
            return new String(clearTxtPassword, StandardCharsets.US_ASCII).toCharArray();
        }

        private static void clearArray(char[] chars) {
            if (chars != null) {
                for (int i = 0; i < chars.length; ++i) {
                    chars[i] = '\u0000';
                }
            }
        }

        private SSLContext buildSslContextFromTrustStoreOrDefault() throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException, KeyManagementException {
            if (Strings.isNullOrEmpty((String)this.trustStoreFile) || Strings.isNullOrEmpty((String)this.trustStorePasswordBase64)) {
                return SSLContexts.createDefault();
            }
            if (Strings.isNullOrEmpty((String)this.trustStoreType)) {
                this.trustStoreType = "JKS";
                log.debug("No trust store type is specified, using default type: {}", (Object)this.trustStoreType);
            }
            log.info("Trust store used is [{}] and of type: {}", (Object)this.trustStoreFile, (Object)this.trustStoreType);
            KeyStore jks = KeyStore.getInstance(this.trustStoreType);
            char[] password = null;
            if (this.trustStorePasswordBase64 != null) {
                password = Builder.base64ToClearAscii(this.trustStorePasswordBase64);
            }
            try (FileInputStream trustStoreStream = new FileInputStream(this.trustStoreFile);){
                jks.load(trustStoreStream, password);
                Builder.clearArray(password);
            }
            log.info("Trust store [{}] is in use for HTTPS", (Object)this.trustStoreFile);
            return SSLContexts.custom().loadTrustMaterial(jks, (TrustStrategy)new TrustSelfSignedStrategy()).build();
        }

        protected URI buildBaseUri(String path) {
            try {
                URIBuilder builder = new URIBuilder();
                builder.setScheme(this.scheme).setHost(this.hostName).setPath(path);
                if (this.port != 80 && this.port != 443) {
                    builder.setPort(this.port);
                }
                return builder.build();
            }
            catch (URISyntaxException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        protected abstract T buildInternal();

        @Generated
        public String getHostName() {
            return this.hostName;
        }

        @Generated
        public int getPort() {
            return this.port;
        }

        @Generated
        public String getScheme() {
            return this.scheme;
        }
    }

    private class InProcessCallsAdapter<T>
    implements FutureCallback<T> {
        FutureCallback futureCallback;

        public InProcessCallsAdapter(FutureCallback<T> futureCallback) {
            this.futureCallback = futureCallback;
        }

        public void completed(T result) {
            AbstractAsyncAnalyticsHttpClient.this.inProcessRequestCount.decrementAndGet();
            if (this.futureCallback != null) {
                this.futureCallback.completed(result);
            }
        }

        public void failed(Exception ex) {
            AbstractAsyncAnalyticsHttpClient.this.inProcessRequestCount.decrementAndGet();
            if (this.futureCallback != null) {
                this.futureCallback.failed(ex);
            }
        }

        public void cancelled() {
            AbstractAsyncAnalyticsHttpClient.this.inProcessRequestCount.decrementAndGet();
            if (this.futureCallback != null) {
                this.futureCallback.cancelled();
            }
        }
    }
}

