/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.client.common;

import com.appdynamics.analytics.client.common.AbstractAnalyticsClient;
import com.appdynamics.analytics.client.common.GenericHttpRequestBuilder;
import com.appdynamics.analytics.client.common.LazyHttpRequestBuilder;
import com.appdynamics.analytics.client.common.RestClientUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import lombok.Generated;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.schedulers.Schedulers;

public class AbstractAsyncAnalyticsClient
extends AbstractAnalyticsClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractAsyncAnalyticsClient.class);
    private final ExecutorService threadPool;
    private final CloseableHttpAsyncClient httpClient;

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }

    protected AbstractAsyncAnalyticsClient(ExecutorService es, CloseableHttpAsyncClient asyncClient, ObjectMapper mapper, URI baseUri) {
        super(mapper, null, baseUri);
        this.threadPool = es;
        this.httpClient = asyncClient;
        this.httpClient.start();
    }

    protected <T> Observable<T> createObservable(final LazyHttpRequestBuilder lazyBuilder, final Throwable[] err, final Class<T> clz) {
        Scheduler scheduler = Schedulers.from((Executor)this.threadPool);
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<T>(){

            public void call(final Subscriber<? super T> observer) {
                if (observer.isUnsubscribed()) {
                    return;
                }
                if (err[0] != null) {
                    observer.onError(err[0]);
                    return;
                }
                try {
                    final GenericHttpRequestBuilder httpRequest = lazyBuilder.create();
                    AbstractAsyncAnalyticsClient.this.httpClient.execute(httpRequest.getHttpRequest(), (FutureCallback)new FutureCallback<HttpResponse>(){

                        public void completed(HttpResponse result) {
                            if (observer.isUnsubscribed()) {
                                return;
                            }
                            try {
                                observer.onNext(RestClientUtils.resolve(result, httpRequest.getExpectedStatusCode(), AbstractAsyncAnalyticsClient.this.getMapper(), clz));
                                observer.onCompleted();
                            }
                            catch (Exception e) {
                                err[0] = e;
                                observer.onError((Throwable)e);
                            }
                        }

                        public void failed(Exception ex) {
                            err[0] = ex;
                            if (!observer.isUnsubscribed()) {
                                observer.onError((Throwable)ex);
                            }
                        }

                        public void cancelled() {
                            if (!observer.isUnsubscribed()) {
                                observer.onCompleted();
                            }
                        }
                    });
                }
                catch (Exception e) {
                    observer.onError((Throwable)e);
                }
            }
        }).observeOn(scheduler).subscribeOn(scheduler);
    }

    public static abstract class Builder<T>
    extends AbstractAnalyticsClient.Builder<T> {
        private int poolSize = 4;
        private CloseableHttpAsyncClient asyncClient = null;

        public Builder<T> setWorkerPoolSize(int size) {
            this.poolSize = size;
            return this;
        }

        @Override
        public Builder<T> client(CloseableHttpClient client) {
            throw new UnsupportedOperationException("Supports CloseableHttpAsyncClient only");
        }

        public Builder<T> client(CloseableHttpAsyncClient asyncClient) {
            this.asyncClient = asyncClient;
            return this;
        }

        @Override
        public T build() {
            if (this.mapper == null) {
                this.mapper = new ObjectMapper();
            }
            return this.buildInternal();
        }

        protected ExecutorService createExectorService() {
            return Executors.newFixedThreadPool(this.poolSize);
        }

        protected CloseableHttpAsyncClient getOrCreateAsyncClient() {
            if (this.asyncClient != null) {
                return this.asyncClient;
            }
            DefaultConnectingIOReactor ioReactor = null;
            try {
                ioReactor = new DefaultConnectingIOReactor(IOReactorConfig.DEFAULT);
            }
            catch (IOReactorException e) {
                throw new IllegalStateException(e);
            }
            PoolingNHttpClientConnectionManager connectionManager = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)ioReactor);
            connectionManager.setMaxTotal(this.maxTotalConnections);
            connectionManager.setDefaultMaxPerRoute(this.maxConnectionsPerRoute);
            HttpAsyncClientBuilder builder = HttpAsyncClientBuilder.create();
            this.addProxyConfig(builder);
            return builder.setSSLContext(this.sslContext).setConnectionManager((NHttpClientConnectionManager)connectionManager).setDefaultRequestConfig(this.getRequestConfig()).build();
        }

        private void addProxyConfig(HttpAsyncClientBuilder builder) {
            if (!Strings.isNullOrEmpty((String)this.httpProxyHost) && this.httpProxyPort != null) {
                HttpHost proxy = new HttpHost(this.httpProxyHost, this.httpProxyPort.intValue());
                builder.setProxy(proxy);
                if (!Strings.isNullOrEmpty((String)this.httpProxyUsername) && !Strings.isNullOrEmpty((String)this.httpProxyPassword)) {
                    BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                    UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.httpProxyUsername, this.httpProxyPassword);
                    credsProvider.setCredentials(new AuthScope(this.httpProxyHost, this.httpProxyPort.intValue()), (Credentials)credentials);
                    builder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
                }
            }
        }

        protected Builder(Class<T> clazz, String scheme, String hostName, int port) {
            super(clazz, scheme, hostName, port);
        }
    }
}

