/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.configuration.providers;

import com.appdynamics.voltron.configuration.ConfigurationException;
import com.appdynamics.voltron.configuration.ConfigurationWriter;
import com.appdynamics.voltron.configuration.providers.Deserializer;
import com.appdynamics.voltron.configuration.providers.UriConfig;
import com.appdynamics.voltron.configuration.providers.UriConfigMonitor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UriConfigProvider
implements UriConfigMonitor {
    private static final Logger log = LoggerFactory.getLogger(UriConfigProvider.class);
    private final Object $lock = new Object[0];
    private final ConfigurationWriter configurationWriter;
    @VisibleForTesting
    private final Set<URI> monitoredUris;
    private final long pollingPeriodMillis;
    private final Set<Deserializer> deserializers;
    private final ScheduledExecutorService pollingService;
    private final HashFunction hashFunction;
    private final Map<URI, HashCode> configFileHashCodes;
    private ScheduledFuture<?> future;

    @Inject
    private UriConfigProvider(ConfigurationWriter configurationWriter, @UriConfig ScheduledExecutorService pollingService, @UriConfig Set<URI> monitoredUris, @UriConfig Long pollingPeriodMillis, @UriConfig HashFunction hashFunction, @UriConfig Set<Deserializer> deserializers) {
        this.configurationWriter = configurationWriter;
        this.pollingService = pollingService;
        this.monitoredUris = new HashSet<URI>(monitoredUris);
        this.pollingPeriodMillis = pollingPeriodMillis;
        this.hashFunction = hashFunction;
        this.deserializers = deserializers;
        this.configFileHashCodes = new ConcurrentHashMap<URI, HashCode>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    private void start() {
        Object object = this.$lock;
        synchronized (object) {
            if (this.future == null) {
                this.future = this.pollingService.scheduleWithFixedDelay(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            UriConfigProvider.this.checkTargets();
                        }
                        catch (InterruptedException e) {
                            UriConfigProvider.this.pollingService.shutdown();
                        }
                        catch (Exception e) {
                            log.warn("Could not check URIs for configuration", (Throwable)e);
                        }
                    }
                }, 0L, this.pollingPeriodMillis, TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    private void stop() {
        Object object = this.$lock;
        synchronized (object) {
            if (this.future != null) {
                this.future.cancel(true);
                this.future = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTargets() throws InterruptedException {
        Object object = this.$lock;
        synchronized (object) {
            for (URI uri : this.monitoredUris) {
                this.processUri(uri);
            }
        }
    }

    private void processUri(URI uri) throws InterruptedException {
        if (uri.getScheme().startsWith("file")) {
            for (URI fileUri : this.getFileUris(uri)) {
                this.processFileUri(fileUri);
            }
        } else {
            this.processFileUri(uri);
        }
    }

    private Iterable<URI> getFileUris(URI fileUri) {
        HashSet<URI> uriSet = new HashSet<URI>();
        Files.fileTraverser().depthFirstPostOrder((Object)new File(fileUri)).forEach(file -> uriSet.add(file.toURI()));
        return uriSet;
    }

    private void processFileUri(URI uri) throws InterruptedException {
        log.debug("Checking uri {} to see if it is readable.", (Object)uri);
        for (Deserializer deserializer : this.deserializers) {
            if (deserializer.accepts(FilenameUtils.getName((String)uri.getPath()))) {
                log.debug("Processing uri {} with {}", (Object)uri, (Object)deserializer);
                try {
                    byte[] data = Resources.toByteArray((URL)uri.toURL());
                    HashCode hashCode = this.hashFunction.hashBytes(data);
                    HashCode prevHashCode = this.configFileHashCodes.get(uri);
                    if (prevHashCode == null || !prevHashCode.equals((Object)hashCode)) {
                        log.debug("File {} has changed contents.", (Object)uri);
                        this.writeConfig(deserializer, data, uri);
                        this.configFileHashCodes.put(uri, hashCode);
                    }
                }
                catch (IOException e) {
                    log.warn("Could not read file " + String.valueOf(uri) + ". Ignoring", (Throwable)e);
                }
                return;
            }
            log.trace("Deserializer {} does not accept {}.", (Object)deserializer, (Object)uri);
        }
    }

    private void writeConfig(Deserializer deserializer, byte[] data, URI uri) throws InterruptedException {
        try {
            Map<String, Object> map = deserializer.deserialize(data);
            String configName = FilenameUtils.getBaseName((String)uri.getPath());
            try {
                this.configurationWriter.writeRawConfiguration(configName, map);
            }
            catch (ConfigurationException e) {
                log.warn("Could not apply configuration " + String.valueOf(map) + " from " + configName, (Throwable)e);
            }
        }
        catch (IOException e) {
            log.warn("Could not deserialize configuration at " + String.valueOf(uri), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addUriToMonitorForConfigFiles(URI uri) {
        Object object = this.$lock;
        synchronized (object) {
            if (!this.monitoredUris.contains(uri)) {
                log.debug("Added URI {} to monitor.", (Object)uri);
                this.monitoredUris.add(uri);
                try {
                    log.debug("Processing new URI {}", (Object)uri);
                    this.processUri(uri);
                    log.debug("Processed new URI {}", (Object)uri);
                }
                catch (InterruptedException e) {
                    log.debug("Interrupted while processing uri " + String.valueOf(uri), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUriToMonitorForConfigFiles(URI uri) {
        Object object = this.$lock;
        synchronized (object) {
            this.monitoredUris.remove(uri);
        }
    }

    Set<URI> getMonitoredUris() {
        return this.monitoredUris;
    }
}

