/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.configuration;

import com.appdynamics.voltron.configuration.ConfigurationException;
import com.appdynamics.voltron.configuration.ConfigurationInternal;
import com.appdynamics.voltron.configuration.ConfigurationListener;
import com.appdynamics.voltron.configuration.ConfigurationListenerKey;
import com.appdynamics.voltron.configuration.ConfigurationRegistrar;
import com.appdynamics.voltron.configuration.CustomValidator;
import com.google.inject.Inject;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DynamicConfigurationRegistrar {
    private static final Logger log = LoggerFactory.getLogger(DynamicConfigurationRegistrar.class);
    private final Map<ConfigurationListenerKey, Set<ConfigurationListener<?>>> allListeners;
    private final Map<Class<?>, Set<CustomValidator<?>>> customValidators;
    private final ConfigurationRegistrar configurationRegistrar;

    @Inject
    DynamicConfigurationRegistrar(@ConfigurationInternal Map<ConfigurationListenerKey, Set<ConfigurationListener<?>>> allListeners, @ConfigurationInternal Map<Class<?>, Set<CustomValidator<?>>> customValidators, ConfigurationRegistrar configurationRegistrar) {
        this.allListeners = allListeners;
        this.customValidators = customValidators;
        this.configurationRegistrar = configurationRegistrar;
    }

    @PostConstruct
    private void addListenersAndValidators() {
        for (Map.Entry<ConfigurationListenerKey, Set<ConfigurationListener<?>>> entry : this.allListeners.entrySet()) {
            String name = entry.getKey().getName();
            Class<?> configClass = entry.getKey().getConfigClass();
            for (ConfigurationListener<?> configurationListener : entry.getValue()) {
                try {
                    this.addConfigListener(name, configClass, configurationListener);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                catch (ConfigurationException e) {
                    log.warn("Could not add config listener " + String.valueOf(configurationListener) + " for " + name + " and type " + String.valueOf(configClass) + ". Skipping... Some functions may not work.", (Throwable)e);
                }
            }
        }
        for (Map.Entry<Object, Set<Object>> entry : this.customValidators.entrySet()) {
            Class configClass = (Class)entry.getKey();
            for (CustomValidator customValidator : entry.getValue()) {
                this.addCustomValidator(configClass, customValidator);
            }
        }
    }

    @PreDestroy
    private void removeListenersAndValidators() {
        for (Map.Entry<ConfigurationListenerKey, Set<ConfigurationListener<?>>> entry : this.allListeners.entrySet()) {
            String name = entry.getKey().getName();
            Class<?> configClass = entry.getKey().getConfigClass();
            for (ConfigurationListener<?> configurationListener : entry.getValue()) {
                try {
                    this.removeConfigListener(name, configClass, configurationListener);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                catch (ConfigurationException e) {
                    log.warn("Could not add config listener " + String.valueOf(configurationListener) + " for " + name + " and type " + String.valueOf(configClass) + ". Skipping... Some functions may not work.", (Throwable)e);
                }
            }
        }
        for (Map.Entry<Object, Set<Object>> entry : this.customValidators.entrySet()) {
            Class configClass = (Class)entry.getKey();
            for (CustomValidator customValidator : entry.getValue()) {
                this.removeCustomValidator(configClass, customValidator);
            }
        }
    }

    private void addCustomValidator(Class<?> configClass, CustomValidator<?> validator) {
        this.configurationRegistrar.addCustomValidator(configClass, validator);
    }

    private void addConfigListener(String name, Class<?> configClass, ConfigurationListener<?> configurationListener) throws InterruptedException, ConfigurationException {
        this.configurationRegistrar.addConfigurationListener(name, configClass, configurationListener);
    }

    private void removeCustomValidator(Class<?> configClass, CustomValidator<?> validator) {
        this.configurationRegistrar.removeCustomValidator(configClass, validator);
    }

    private void removeConfigListener(String name, Class<?> configClass, ConfigurationListener<?> configurationListener) throws InterruptedException, ConfigurationException {
        this.configurationRegistrar.removeConfigurationListener(name, configClass, configurationListener);
    }
}

