/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.configuration;

import com.appdynamics.voltron.configuration.Configuration;
import com.appdynamics.voltron.configuration.ConfigurationClientModule;
import com.appdynamics.voltron.configuration.ConfigurationExecutor;
import com.appdynamics.voltron.configuration.ConfigurationManager;
import com.appdynamics.voltron.configuration.ConfigurationMapper;
import com.appdynamics.voltron.configuration.ConfigurationRegistrar;
import com.appdynamics.voltron.configuration.ConfigurationTimeout;
import com.appdynamics.voltron.configuration.ConfigurationValidator;
import com.appdynamics.voltron.configuration.ConfigurationWriter;
import com.appdynamics.voltron.utils.ManagedExecutorService;
import com.appdynamics.voltron.utils.overrides.Overrider;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.LinkedBindingBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.validation.Validation;
import javax.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationModule
extends AbstractModule {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationModule.class);
    private static final long DEFAULT_CONFIG_TIMEOUT_MS = 10000L;
    private final boolean synchronousApply;

    public ConfigurationModule() {
        this(false);
    }

    public ConfigurationModule(boolean synchronousApply) {
        this.synchronousApply = synchronousApply;
    }

    protected final void configure() {
        this.install((Module)new ConfigurationClientModule(){

            @Override
            protected void configureListenersAndValidators() {
            }
        });
        this.bind(ConfigurationManager.class).in(Scopes.SINGLETON);
        this.bind(ConfigurationWriter.class).to(ConfigurationManager.class);
        this.bind(ConfigurationRegistrar.class).to(ConfigurationManager.class);
        this.configureConfigurationTimeout((LinkedBindingBuilder<Long>)this.bind(Long.TYPE).annotatedWith(ConfigurationTimeout.class));
        this.configureValidator((LinkedBindingBuilder<Validator>)this.bind(Validator.class).annotatedWith(ConfigurationValidator.class));
        this.configureConfigurationExecutor((LinkedBindingBuilder<ExecutorService>)this.bind(ExecutorService.class).annotatedWith(ConfigurationExecutor.class));
        this.configureMapper((LinkedBindingBuilder<ObjectMapper>)this.bind(ObjectMapper.class).annotatedWith(ConfigurationMapper.class));
        this.configureOverrider((LinkedBindingBuilder<Optional<Overrider>>)this.bind((TypeLiteral)new TypeLiteral<Optional<Overrider>>(){}).annotatedWith(Configuration.class));
    }

    protected void configureConfigurationExecutor(LinkedBindingBuilder<ExecutorService> bindExecutorService) {
        if (this.synchronousApply) {
            bindExecutorService.toInstance((Object)MoreExecutors.newDirectExecutorService());
        } else {
            final ThreadFactory threadFactoryBuilder = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ConfigExecutor-%d").setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    log.warn("Thread " + String.valueOf(t) + " threw an uncaught exception", e);
                }
            }).build();
            bindExecutorService.toInstance((Object)new ManagedExecutorService(){

                protected ExecutorService createDelegate() {
                    return Executors.newFixedThreadPool(1, threadFactoryBuilder);
                }

                protected TimeUnit getTimeUnit() {
                    return TimeUnit.MILLISECONDS;
                }

                protected long getShutdownTimeout() {
                    return 10000L;
                }
            });
        }
    }

    protected void configureConfigurationTimeout(LinkedBindingBuilder<Long> bindTimeoutMillis) {
        bindTimeoutMillis.toInstance((Object)10000L);
    }

    protected void configureValidator(LinkedBindingBuilder<Validator> bindValidator) {
        bindValidator.toInstance((Object)Validation.buildDefaultValidatorFactory().getValidator());
    }

    protected void configureMapper(LinkedBindingBuilder<ObjectMapper> bindMapper) {
        bindMapper.to(ObjectMapper.class).in(Scopes.SINGLETON);
    }

    protected void configureOverrider(LinkedBindingBuilder<Optional<Overrider>> bindOverrider) {
        bindOverrider.toInstance((Object)Optional.absent());
    }
}

