/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.api.rawdata;

import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataErrorHandler;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataItem;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawDataString
implements RawDataItem<String> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RawDataString.class);
    private final Optional<String> value;
    private final String error;
    private final RawDataFactory factory;
    private final RawDataErrorHandler errorHandler;

    @AssistedInject
    @VisibleForTesting
    public RawDataString(@NonNull RawDataFactory factory, @NonNull RawDataErrorHandler errorHandler, @Assisted @NonNull Optional<String> value, @Assisted @NonNull String error) {
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        if (errorHandler == null) {
            throw new NullPointerException("errorHandler is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (error == null) {
            throw new NullPointerException("error is marked non-null but is null");
        }
        this.factory = factory;
        this.errorHandler = errorHandler;
        this.value = value;
        this.error = error;
        if (value.isPresent() && !StringUtils.isEmpty((CharSequence)error)) {
            log.warn("There is both a value {} and error {} for this RawDataString.", value.get(), (Object)error);
        }
    }

    @AssistedInject
    private RawDataString(@NonNull RawDataFactory factory, @NonNull RawDataErrorHandler errorHandler, @Assisted @NonNull Optional<String> value) {
        this(factory, errorHandler, value, "");
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        if (errorHandler == null) {
            throw new NullPointerException("errorHandler is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
    }

    @Override
    public String get() {
        if (this.value.isPresent()) {
            return (String)this.value.get();
        }
        throw new IllegalStateException("The value was not present");
    }

    @Override
    public String or(@NonNull String defaultValue) {
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        if (this.value.isPresent()) {
            return (String)this.value.get();
        }
        return defaultValue;
    }

    @Override
    public boolean isPresent() {
        return this.value.isPresent();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawDataString)) {
            return false;
        }
        RawDataString other = (RawDataString)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Optional<String> this$value = this.getValue();
        Optional<String> other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$error = this.getError();
        String other$error = other.getError();
        return !(this$error == null ? other$error != null : !this$error.equals(other$error));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RawDataString;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<String> $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RawDataString(value=" + String.valueOf(this.getValue()) + ", error=" + this.getError() + ")";
    }

    @Generated
    public Optional<String> getValue() {
        return this.value;
    }

    @Override
    @Generated
    public String getError() {
        return this.error;
    }
}

