/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.api.rawdata;

import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataBigInt;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataString;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import io.dropwizard.util.SizeUnit;
import lombok.NonNull;

public class RawDataItemUtil {
    private static final double PERCENT = 100.0;
    private static final String NOT_VALID_LONG = "not a valid long number";
    private final RawDataFactory factory;

    @Inject
    @VisibleForTesting
    public RawDataItemUtil(RawDataFactory factory) {
        this.factory = factory;
    }

    public RawDataLong aggregate(@NonNull RawDataLong first, @NonNull RawDataLong second) {
        if (first == null) {
            throw new NullPointerException("first is marked non-null but is null");
        }
        if (second == null) {
            throw new NullPointerException("second is marked non-null but is null");
        }
        if (first.getValue().isPresent() && second.getValue().isPresent()) {
            return first.add(second);
        }
        if (first.getValue().isPresent()) {
            return first;
        }
        return second;
    }

    public RawDataBigInt aggregate(@NonNull RawDataBigInt first, @NonNull RawDataBigInt second) {
        if (first == null) {
            throw new NullPointerException("first is marked non-null but is null");
        }
        if (second == null) {
            throw new NullPointerException("second is marked non-null but is null");
        }
        if (first.getValue().isPresent() && second.getValue().isPresent()) {
            return first.add(second);
        }
        if (first.getValue().isPresent()) {
            return first;
        }
        return second;
    }

    public RawDataLong bytesToMegabytes(@NonNull RawDataLong bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        if (bytes.isPresent()) {
            long bytesLong = bytes.get();
            long megabytes = SizeUnit.BYTES.toMegabytes(bytesLong);
            return this.factory.createLong(megabytes);
        }
        return bytes;
    }

    public RawDataLong bytesToKilobytes(@NonNull RawDataLong bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        if (bytes.isPresent()) {
            long bytesLong = bytes.get();
            long kilobytes = SizeUnit.BYTES.toKilobytes(bytesLong);
            return this.factory.createLong(kilobytes);
        }
        return bytes;
    }

    public RawDataLong kilobytesToMegabytes(@NonNull RawDataLong kilobytes) {
        if (kilobytes == null) {
            throw new NullPointerException("kilobytes is marked non-null but is null");
        }
        if (kilobytes.isPresent()) {
            long kbLong = kilobytes.get();
            long megabytes = SizeUnit.KILOBYTES.toMegabytes(kbLong);
            return this.factory.createLong(megabytes);
        }
        return kilobytes;
    }

    public RawDataLong megabytesToKilobytes(@NonNull RawDataLong megabytes) {
        if (megabytes == null) {
            throw new NullPointerException("megabytes is marked non-null but is null");
        }
        if (megabytes.isPresent()) {
            long mbLong = megabytes.get();
            long kilobytes = SizeUnit.MEGABYTES.toKilobytes(mbLong);
            return this.factory.createLong(kilobytes);
        }
        return megabytes;
    }

    public RawDataLong calculatePercentage(@NonNull RawDataLong value, @NonNull RawDataLong total) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (total == null) {
            throw new NullPointerException("total is marked non-null but is null");
        }
        if (!value.isPresent() || !total.isPresent()) {
            return value.divide(total);
        }
        long valueLong = value.get();
        long totalLong = total.get();
        long calculatedValue = totalLong == 0L ? 0L : Math.round((double)valueLong * 100.0 / (double)totalLong);
        return this.factory.createLong(calculatedValue);
    }

    public RawDataString rawDataLongToRawDataString(@NonNull RawDataLong longValue) {
        if (longValue == null) {
            throw new NullPointerException("longValue is marked non-null but is null");
        }
        if (longValue.isPresent()) {
            Optional stringOpt = Optional.of((Object)longValue.get().toString());
            return this.factory.createString((Optional<String>)stringOpt);
        }
        return this.factory.createString((Optional<String>)Optional.absent(), NOT_VALID_LONG);
    }
}

