/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.api.rawdata;

import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataItem;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class RawDataErrorHandler {
    private static final String ERROR_SPLITTER = " & ";

    boolean isValidInput(RawDataItem<?> ... items) {
        if (items == null) {
            throw new NullPointerException("items is marked non-null but is null");
        }
        for (RawDataItem<?> item : items) {
            if (item.isPresent()) continue;
            return false;
        }
        return true;
    }

    String aggregateErrorStrings(RawDataItem<?> first, RawDataItem<?> second) {
        HashSet<String> errorMessages = new HashSet<String>();
        this.addErrorsToSet(first, errorMessages);
        this.addErrorsToSet(second, errorMessages);
        StringBuilder sb = new StringBuilder();
        Iterator errorMessageIt = errorMessages.iterator();
        while (errorMessageIt.hasNext()) {
            sb.append((String)errorMessageIt.next());
            if (!errorMessageIt.hasNext()) continue;
            sb.append(ERROR_SPLITTER);
        }
        return sb.toString();
    }

    private void addErrorsToSet(RawDataItem<?> item, Set<String> errorMessages) {
        String[] individualErrors;
        String itemErrorMessage = item.getError();
        if (StringUtils.isBlank((CharSequence)itemErrorMessage)) {
            return;
        }
        for (String error : individualErrors = itemErrorMessage.split(ERROR_SPLITTER)) {
            errorMessages.add(error.trim());
        }
    }
}

