/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.api.rawdata;

import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataErrorHandler;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataNumber;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.math.BigInteger;
import lombok.Generated;
import lombok.NonNull;

public class RawDataBigInt
implements RawDataNumber<BigInteger, RawDataBigInt> {
    private final Optional<BigInteger> value;
    private final String error;
    private final RawDataFactory factory;
    private final RawDataErrorHandler errorHandler;

    @VisibleForTesting
    public RawDataBigInt(RawDataFactory factory, RawDataErrorHandler errorHandler, Optional<BigInteger> value, String error) {
        this.factory = factory;
        this.errorHandler = errorHandler;
        this.value = value;
        this.error = error;
    }

    @AssistedInject
    private RawDataBigInt(RawDataFactory factory, RawDataErrorHandler errorHandler, @Assisted BigInteger value) {
        this(factory, errorHandler, (Optional<BigInteger>)Optional.of((Object)value), "");
    }

    @AssistedInject
    private RawDataBigInt(RawDataFactory factory, RawDataErrorHandler errorHandler, @Assisted String error) {
        this(factory, errorHandler, (Optional<BigInteger>)Optional.absent(), error);
    }

    @Override
    public BigInteger get() {
        if (this.value.isPresent()) {
            return (BigInteger)this.value.get();
        }
        throw new IllegalStateException("The value was not present");
    }

    @Override
    public BigInteger or(@NonNull BigInteger defaultValue) {
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        if (this.value.isPresent()) {
            return (BigInteger)this.value.get();
        }
        return defaultValue;
    }

    @Override
    public boolean isPresent() {
        return this.value.isPresent();
    }

    @Override
    public RawDataBigInt add(@NonNull RawDataBigInt item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        if (this.errorHandler.isValidInput(this, item)) {
            BigInteger newValue = ((BigInteger)this.value.get()).add((BigInteger)item.getValue().get());
            return this.factory.createBigInt(newValue);
        }
        return this.newBigIntWithError(item);
    }

    @Override
    public RawDataBigInt subtract(@NonNull RawDataBigInt item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        if (this.errorHandler.isValidInput(this, item)) {
            BigInteger newValue = ((BigInteger)this.value.get()).subtract((BigInteger)item.getValue().get());
            return this.factory.createBigInt(newValue);
        }
        return this.newBigIntWithError(item);
    }

    @Override
    public RawDataBigInt multiply(@NonNull RawDataBigInt item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        if (this.errorHandler.isValidInput(this, item)) {
            BigInteger newValue = ((BigInteger)this.value.get()).multiply((BigInteger)item.getValue().get());
            return this.factory.createBigInt(newValue);
        }
        return this.newBigIntWithError(item);
    }

    @Override
    public RawDataBigInt divide(@NonNull RawDataBigInt item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        if (this.errorHandler.isValidInput(this, item)) {
            if (((BigInteger)item.getValue().get()).equals(BigInteger.ZERO)) {
                return this.newBigIntWithError("Tried to divide by 0");
            }
            BigInteger newValue = ((BigInteger)this.value.get()).divide((BigInteger)item.getValue().get());
            return this.factory.createBigInt(newValue);
        }
        return this.newBigIntWithError(item);
    }

    private RawDataBigInt newBigIntWithError(RawDataBigInt item) {
        String aggregatedErrorString = this.errorHandler.aggregateErrorStrings(this, item);
        return this.factory.createBigInt(aggregatedErrorString);
    }

    private RawDataBigInt newBigIntWithError(String error) {
        return this.factory.createBigInt(error);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawDataBigInt)) {
            return false;
        }
        RawDataBigInt other = (RawDataBigInt)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Optional<BigInteger> this$value = this.getValue();
        Optional<BigInteger> other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$error = this.getError();
        String other$error = other.getError();
        return !(this$error == null ? other$error != null : !this$error.equals(other$error));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RawDataBigInt;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<BigInteger> $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RawDataBigInt(value=" + String.valueOf(this.getValue()) + ", error=" + this.getError() + ")";
    }

    @Generated
    public Optional<BigInteger> getValue() {
        return this.value;
    }

    @Override
    @Generated
    public String getError() {
        return this.error;
    }
}

