/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.test.utils.ssh;

import com.appdynamics.voltron.test.utils.LogLevel;
import com.appdynamics.voltron.test.utils.remote.ProcUtils;
import com.appdynamics.voltron.test.utils.ssh.RemoteFileSystem;
import com.appdynamics.voltron.test.utils.ssh.SSHConfig;
import com.appdynamics.voltron.test.utils.ssh.SSHSessionProvider;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.NonNull;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteServer
implements AutoCloseable,
RemoteFileSystem {
    private static final Logger log = LoggerFactory.getLogger(RemoteServer.class);
    private static final String EXEC_CHANNEL = "exec";
    private static final String SFTP_CHANNEL = "sftp";
    private static final long TIMEOUT_MS = TimeUnit.SECONDS.toMillis(30L);
    private final SSHSessionProvider sessionProvider;
    private final int sshTimeout;

    public RemoteServer(@NonNull SSHConfig sshConfig) {
        if (sshConfig == null) {
            throw new NullPointerException("sshConfig is marked non-null but is null");
        }
        this.sessionProvider = new SSHSessionProvider(sshConfig);
        this.sshTimeout = sshConfig.getConnectTimeout();
    }

    ChannelExec getExecChannel() throws IOException, JSchException {
        return (ChannelExec)this.sessionProvider.get().openChannel(EXEC_CHANNEL);
    }

    ChannelSftp connectSftpChannel() {
        try {
            ChannelSftp channel = (ChannelSftp)this.sessionProvider.get().openChannel(SFTP_CHANNEL);
            channel.connect(this.sshTimeout);
            return channel;
        }
        catch (JSchException e) {
            log.error("Could not connect to server {} - ", (Object)this.getConnectionUrlString(), (Object)e);
            throw new RuntimeException("Could not connect to server", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transferFromLocal(@NonNull File localFile, String remoteFile) throws IOException {
        if (localFile == null) {
            throw new NullPointerException("localFile is marked non-null but is null");
        }
        try (FileInputStream fis = new FileInputStream(localFile);){
            log.debug("Putting {} to {}", (Object)localFile, (Object)remoteFile);
            ChannelSftp channelSftp = this.connectSftpChannel();
            try {
                channelSftp.put((InputStream)fis, RemoteServer.unixFile(remoteFile), 0);
            }
            finally {
                if (Collections.singletonList(channelSftp).get(0) != null) {
                    channelSftp.disconnect();
                }
            }
        }
        catch (SftpException e) {
            log.error("Exception copying file {} to directory {} on server {} - ", new Object[]{localFile.getPath(), remoteFile, this.getConnectionUrlString(), e});
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transferFromRemote(@NonNull String remoteFile, @NonNull File localFile) throws IOException {
        if (remoteFile == null) {
            throw new NullPointerException("remoteFile is marked non-null but is null");
        }
        if (localFile == null) {
            throw new NullPointerException("localFile is marked non-null but is null");
        }
        try (FileOutputStream fos = new FileOutputStream(localFile);){
            log.debug("Getting {} to {}", (Object)remoteFile, (Object)localFile);
            ChannelSftp channelSftp = this.connectSftpChannel();
            try {
                channelSftp.get(RemoteServer.unixFile(remoteFile), (OutputStream)fos);
            }
            finally {
                if (Collections.singletonList(channelSftp).get(0) != null) {
                    channelSftp.disconnect();
                }
            }
        }
        catch (SftpException e) {
            log.error("Exception copying file from server {} - ", (Object)this.getConnectionUrlString(), (Object)e);
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDirectory(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        ChannelSftp channelSftp = this.connectSftpChannel();
        try {
            boolean bl = this.isDirectory(channelSftp, RemoteServer.unixFile(path));
            return bl;
        }
        finally {
            if (Collections.singletonList(channelSftp).get(0) != null) {
                channelSftp.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFile(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        ChannelSftp channelSftp = this.connectSftpChannel();
        try {
            boolean bl = this.isFile(channelSftp, RemoteServer.unixFile(path));
            return bl;
        }
        finally {
            if (Collections.singletonList(channelSftp).get(0) != null) {
                channelSftp.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAbsolutePath(@NonNull String path) throws IllegalArgumentException {
        String string;
        block7: {
            if (path == null) {
                throw new NullPointerException("path is marked non-null but is null");
            }
            ChannelSftp channelSftp = this.connectSftpChannel();
            try {
                string = channelSftp.realpath(RemoteServer.unixFile(path));
                if (Collections.singletonList(channelSftp).get(0) == null) break block7;
            }
            catch (Throwable throwable) {
                try {
                    if (Collections.singletonList(channelSftp).get(0) != null) {
                        channelSftp.disconnect();
                    }
                    throw throwable;
                }
                catch (SftpException e) {
                    log.error("Could not get realpath for {}, on remote server {} - ", new Object[]{path, this.getConnectionUrlString(), e});
                    throw new IllegalArgumentException("Could not get absolute path from remote server - " + this.getConnectionUrlString(), e);
                }
            }
            channelSftp.disconnect();
        }
        return string;
    }

    @Override
    public void rmDir(@NonNull String directory) {
        if (directory == null) {
            throw new NullPointerException("directory is marked non-null but is null");
        }
        ChannelSftp channelSftp = this.connectSftpChannel();
        try {
            this.rmDir(channelSftp, RemoteServer.unixFile(directory));
        }
        finally {
            if (Collections.singletonList(channelSftp).get(0) != null) {
                channelSftp.disconnect();
            }
        }
    }

    @Override
    public void mkDir(@NonNull String directory) {
        if (directory == null) {
            throw new NullPointerException("directory is marked non-null but is null");
        }
        ChannelSftp channelSftp = this.connectSftpChannel();
        try {
            this.mkDir(channelSftp, RemoteServer.unixFile(directory));
        }
        finally {
            if (Collections.singletonList(channelSftp).get(0) != null) {
                channelSftp.disconnect();
            }
        }
    }

    public String getEnvironmentVariable(@NonNull String variableName) {
        if (variableName == null) {
            throw new NullPointerException("variableName is marked non-null but is null");
        }
        try {
            String value = this.executeSimpleCommand(new String[]{"echo", "$" + variableName}, "getEnvVar:" + variableName).getStdout().trim();
            return value;
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            log.error("Could not get environment variable for {}, on remote server {} - ", new Object[]{variableName, this.getConnectionUrlString(), e});
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new RuntimeException("Could not get environment variable from remote server - " + this.getConnectionUrlString(), e);
        }
    }

    public ProcUtils.Output executeSimpleCommand(String[] cmd, String name) throws InterruptedException, ExecutionException, TimeoutException {
        return ProcUtils.builder().setCmd(cmd).setProcessName(name).logOutputStreams(LogLevel.DEBUG).setRemoteServerConfig(this).build().runAndReturnOutput(TIMEOUT_MS);
    }

    public static CommandBuilder buildCompoundCommand(String cmd) {
        return new CommandBuilder(cmd);
    }

    private void mkDir(ChannelSftp channelSftp, String directory) {
        directory = RemoteServer.unixFile(directory);
        try {
            if (this.isDirectory(channelSftp, directory)) {
                log.debug("Directory {} already exists on remote server - {}", (Object)directory, (Object)this.getConnectionUrlString());
                return;
            }
            log.debug("Creating directory {} on server {}", (Object)directory, (Object)this.getConnectionUrlString());
            this.executeSimpleCommand(new String[]{"mkdir", "-p", directory}, "mkdir:" + directory);
        }
        catch (Exception e) {
            log.debug("Could not create directory {} on remote server {}", (Object)directory, (Object)this.getConnectionUrlString());
            throw new RuntimeException("Could not create directory on remote server - " + this.getConnectionUrlString(), e);
        }
    }

    private void rmDir(ChannelSftp channelSftp, String directory) {
        directory = RemoteServer.unixFile(directory);
        try {
            log.debug("Removing directory {} on server {}", (Object)directory, (Object)this.getConnectionUrlString());
            channelSftp.rmdir(directory);
        }
        catch (SftpException e) {
            log.debug("Directory {} did not exist - no need to remove it", (Object)directory);
        }
    }

    private boolean isDirectory(ChannelSftp channelSftp, String directory) {
        directory = RemoteServer.unixFile(directory);
        try {
            SftpATTRS attrs = channelSftp.stat(directory);
            return attrs.isDir();
        }
        catch (SftpException e) {
            log.debug("Path {} is not a directory on server {}", (Object)directory, (Object)this.getConnectionUrlString());
            return false;
        }
    }

    private boolean isFile(ChannelSftp channelSftp, String path) {
        path = RemoteServer.unixFile(path);
        try {
            SftpATTRS attrs = channelSftp.stat(path);
            return !attrs.isDir();
        }
        catch (SftpException e) {
            log.debug("Path {} is not a file on server {}", (Object)path, (Object)this.getConnectionUrlString());
            return false;
        }
    }

    @Override
    public void close() throws InterruptedException {
        this.sessionProvider.close();
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public String getConnectionUrlString() {
        return this.sessionProvider.getConnectionUrlString();
    }

    private static String unixFile(String remoteFile) {
        if (remoteFile == null) {
            return null;
        }
        return remoteFile.replace("\\", "/");
    }

    public String toString() {
        return "RemoteServer(sessionProvider=" + String.valueOf(this.sessionProvider) + ", sshTimeout=" + this.sshTimeout + ")";
    }

    public static class CommandBuilder {
        private static final String SET_VARIABLE_CMD = "export %s=\"%s\"";
        private static final String CMD_AND_JOINER = " && ";
        @NonNull
        private final String command;
        private String workingDir;
        private Collection<String> envp;

        private void joinCmd(StringBuilder cmdStringBuilder, String cmd) {
            String cmdStr = cmdStringBuilder.toString();
            if (!cmdStr.isEmpty() && !cmdStr.endsWith(CMD_AND_JOINER)) {
                cmdStringBuilder.append(CMD_AND_JOINER);
            }
            cmdStringBuilder.append(cmd);
        }

        private void buildSetEnvPCommand(StringBuilder cmdStringBuilder) {
            if (this.envp != null) {
                for (String env : this.envp) {
                    int eqIndex = env.indexOf("=");
                    String varName = env.substring(0, eqIndex);
                    String val = env.substring(eqIndex + 1);
                    this.joinCmd(cmdStringBuilder, String.format(SET_VARIABLE_CMD, varName, StringEscapeUtils.escapeJava((String)val)));
                }
            }
        }

        public CommandBuilder workingDir(String workingDir) {
            this.workingDir = RemoteServer.unixFile(workingDir);
            return this;
        }

        public String build() {
            StringBuilder commandSB = new StringBuilder();
            this.buildSetEnvPCommand(commandSB);
            if (this.workingDir != null) {
                this.joinCmd(commandSB, "cd " + this.workingDir);
            }
            this.joinCmd(commandSB, this.command);
            return commandSB.toString();
        }

        private CommandBuilder(@NonNull String command) {
            if (command == null) {
                throw new NullPointerException("command is marked non-null but is null");
            }
            this.command = command;
        }

        public CommandBuilder envp(Collection<String> envp) {
            this.envp = envp;
            return this;
        }
    }
}

