/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.test.utils.remote;

import com.appdynamics.voltron.test.utils.AssertUtils;
import com.appdynamics.voltron.test.utils.remote.ProcUtils;
import com.appdynamics.voltron.test.utils.ssh.RemoteServer;
import com.google.common.base.Optional;
import java.nio.file.Paths;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.junit.rules.ExternalResource;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteTemporaryFolder
extends ExternalResource {
    private static final Logger log = LoggerFactory.getLogger(RemoteTemporaryFolder.class);
    private static final int MAX_RANDOM_FOLDERS_RETRY = 5;
    private static final Random random = new Random();
    private final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private final Optional<RemoteServer> remoteServerOpt;
    private String remoteFolderName;

    public RemoteTemporaryFolder(Optional<RemoteServer> remoteServerOpt) {
        this.remoteServerOpt = remoteServerOpt;
    }

    protected void before() throws Throwable {
        if (!this.remoteServerOpt.isPresent()) {
            this.temporaryFolder.create();
        } else {
            this.createRandomRemoteFolder();
        }
    }

    protected void after() {
        if (!this.remoteServerOpt.isPresent()) {
            this.temporaryFolder.delete();
        } else {
            this.deleteRemoteFolder();
        }
    }

    private void createRandomRemoteFolder() {
        this.remoteFolderName = AssertUtils.tryTillSuccess(Exception.class, 5, 5000L, new Callable<String>(){

            @Override
            public String call() {
                try {
                    return RemoteTemporaryFolder.this.createRandomRemoteFolder("build");
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private void deleteRemoteFolder() {
        RemoteServer remoteServer = (RemoteServer)this.remoteServerOpt.get();
        if (this.remoteFolderName == null) {
            throw new RuntimeException("Remote foldername not set");
        }
        try {
            remoteServer.executeSimpleCommand(new String[]{"rm", "-rf", this.remoteFolderName}, "rmRandomForce");
        }
        catch (ExecutionException | TimeoutException e) {
            log.error("Failed to delete remote dir", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            log.error("Interrupted thread while executing");
            Thread.currentThread().interrupt();
        }
        finally {
            try {
                remoteServer.close();
            }
            catch (InterruptedException e) {
                log.error("Interrupted when closing remote connection", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    public String getRootAbsPath() {
        if (!this.remoteServerOpt.isPresent()) {
            return this.temporaryFolder.getRoot().getAbsolutePath();
        }
        return this.remoteFolderName;
    }

    private String createRandomRemoteFolder(String parentFolderName) throws Exception {
        String randomDirPath = Paths.get(parentFolderName, String.format("junit-%d-%06d", System.currentTimeMillis(), random.nextInt(999999))).toString().replace('\\', '/');
        log.debug("Creating remote directory {}", (Object)randomDirPath);
        ProcUtils.Output output = ((RemoteServer)this.remoteServerOpt.get()).executeSimpleCommand(new String[]{"mkdir", "-p", randomDirPath}, "makeRemoteRandomDir");
        if (output.getRetVal() != 0) {
            throw new Exception("Failed to make remote random folder");
        }
        return randomDirPath;
    }
}

