/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.test.utils.remote;

import com.appdynamics.voltron.test.utils.remote.TestEnvironmentConfiguration;
import com.appdynamics.voltron.test.utils.ssh.RemoteServer;
import com.appdynamics.voltron.test.utils.ssh.SSHConfig;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import lombok.NonNull;
import org.junit.Assert;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteCapableTestRule
extends ExternalResource {
    private static final Logger log = LoggerFactory.getLogger(RemoteCapableTestRule.class);
    private static final int JUST_ONE = 1;
    private static final String RUN_REMOTE_TESTS = "run.remote.tests";
    private static final String RUN_REMOTE_CONTROLLER_HOST = "run.remote.controller.host";
    private static final boolean IS_REMOTE = Boolean.getBoolean("run.remote.tests");
    private static final Optional<String> REMOTE_CONTROLLER_HOST = Optional.fromNullable((Object)System.getProperty("run.remote.controller.host"));
    private static final String REMOTE_SERVERS_CONFIG_OVERRIDE = "test-local.json";
    @NonNull
    private final String serverConfigFileName;
    private final int controllerPort;
    private Set<TestEnvironmentConfiguration> environmentConfigurations = Collections.emptySet();

    public RemoteCapableTestRule(String serverConfigFileName) {
        this.serverConfigFileName = serverConfigFileName;
        this.controllerPort = 0;
    }

    public Set<TestEnvironmentConfiguration> getEnvironmentConfigurations() {
        return this.environmentConfigurations;
    }

    public TestEnvironmentConfiguration getSingleEnvironmentConfigurationOrFail() {
        Assert.assertEquals((String)"Incorrect number of environment configurations were found", (long)1L, (long)this.environmentConfigurations.size());
        return this.environmentConfigurations.iterator().next();
    }

    public void before() throws IOException {
        this.environmentConfigurations = this.readEnvironmentConfigurations();
    }

    public void after() {
    }

    public static String getControllerHostOrDefault(@NonNull String defaultHost) {
        if (defaultHost == null) {
            throw new NullPointerException("defaultHost is marked non-null but is null");
        }
        return (String)REMOTE_CONTROLLER_HOST.or((Object)defaultHost);
    }

    public static Optional<String> getControllerHost() {
        return REMOTE_CONTROLLER_HOST;
    }

    private boolean isConfigOverrideExists() {
        return RemoteCapableTestRule.class.getResource(REMOTE_SERVERS_CONFIG_OVERRIDE) != null;
    }

    private Collection<SSHConfig> readRemoteConfigs() throws IOException {
        String serverConfig = this.serverConfigFileName;
        if (this.isConfigOverrideExists()) {
            serverConfig = REMOTE_SERVERS_CONFIG_OVERRIDE;
        }
        InputStream inputStream = RemoteCapableTestRule.class.getResourceAsStream(serverConfig);
        Collection<SSHConfig> remoteConfigs = SSHConfig.loadConfigFromStream(inputStream);
        return remoteConfigs;
    }

    private Set<TestEnvironmentConfiguration> readEnvironmentConfigurations() throws IOException {
        if (IS_REMOTE) {
            Collection<SSHConfig> remoteConfigs = this.readRemoteConfigs();
            ImmutableSet.Builder envConfigSetBuilder = new ImmutableSet.Builder();
            for (SSHConfig config : remoteConfigs) {
                config.setRemoteForwardedPort(this.controllerPort);
                envConfigSetBuilder.add((Object)new TestEnvironmentConfiguration((Optional<RemoteServer>)Optional.of((Object)new RemoteServer(config))));
            }
            return envConfigSetBuilder.build();
        }
        return Collections.singleton(TestEnvironmentConfiguration.LOCAL_CONFIG);
    }

    public RemoteCapableTestRule(@NonNull String serverConfigFileName, int controllerPort) {
        if (serverConfigFileName == null) {
            throw new NullPointerException("serverConfigFileName is marked non-null but is null");
        }
        this.serverConfigFileName = serverConfigFileName;
        this.controllerPort = controllerPort;
    }
}

