/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.test.utils.remote;

import com.appdynamics.voltron.test.utils.AssertUtils;
import com.appdynamics.voltron.test.utils.IProcessTerminator;
import com.appdynamics.voltron.test.utils.LogLevel;
import com.appdynamics.voltron.test.utils.LogOutputStream;
import com.appdynamics.voltron.test.utils.ssh.RemoteProcess;
import com.appdynamics.voltron.test.utils.ssh.RemoteServer;
import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.NonNull;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProcUtils {
    private static final Logger log = LoggerFactory.getLogger(ProcUtils.class);

    private ProcUtils() {
    }

    public static ProcBuilder builder() {
        return new ProcBuilder();
    }

    private static Process getRuntimeProcess(@NonNull String[] cmd, @NonNull Optional<String[]> envp, @NonNull Optional<String> workingDir) throws IOException {
        if (cmd == null) {
            throw new NullPointerException("cmd is marked non-null but is null");
        }
        if (envp == null) {
            throw new NullPointerException("envp is marked non-null but is null");
        }
        if (workingDir == null) {
            throw new NullPointerException("workingDir is marked non-null but is null");
        }
        File workingDirFile = null;
        if (workingDir.isPresent()) {
            workingDirFile = new File((String)workingDir.get());
        }
        Object[] currentEnvVars = ProcUtils.buildEnvVarsArrayFromMap(System.getenv());
        if (envp.isPresent()) {
            currentEnvVars = (String[])ArrayUtils.addAll((Object[])currentEnvVars, (Object[])((String[])envp.get()));
        }
        return Runtime.getRuntime().exec(cmd, (String[])currentEnvVars, workingDirFile);
    }

    public static String[] buildEnvVarsArrayFromMap(Map<String, String> environmentVars) {
        ArrayList<CallSite> varsList = new ArrayList<CallSite>();
        for (String varName : environmentVars.keySet()) {
            String varValue = environmentVars.get(varName);
            varsList.add((CallSite)((Object)(varName + "=" + varValue)));
        }
        return varsList.toArray(new String[varsList.size()]);
    }

    private static Future<Output> runBackgroundProcAndReturnOutput(final @NonNull String[] cmd, final @NonNull Optional<String[]> envp, final @NonNull Optional<byte[]> stdin, final @NonNull Optional<String> workingDir, @NonNull Optional<String> processName, final @NonNull Optional<? extends OutputStream> stdoutOutputStream, final @NonNull Optional<? extends OutputStream> stderrOutputStream, final @NonNull Optional<? extends IProcessTerminator> terminator, final @NonNull Optional<RemoteServer> remoteServerConfig) {
        if (cmd == null) {
            throw new NullPointerException("cmd is marked non-null but is null");
        }
        if (envp == null) {
            throw new NullPointerException("envp is marked non-null but is null");
        }
        if (stdin == null) {
            throw new NullPointerException("stdin is marked non-null but is null");
        }
        if (workingDir == null) {
            throw new NullPointerException("workingDir is marked non-null but is null");
        }
        if (processName == null) {
            throw new NullPointerException("processName is marked non-null but is null");
        }
        if (stdoutOutputStream == null) {
            throw new NullPointerException("stdoutOutputStream is marked non-null but is null");
        }
        if (stderrOutputStream == null) {
            throw new NullPointerException("stderrOutputStream is marked non-null but is null");
        }
        if (terminator == null) {
            throw new NullPointerException("terminator is marked non-null but is null");
        }
        if (remoteServerConfig == null) {
            throw new NullPointerException("remoteServerConfig is marked non-null but is null");
        }
        final String cmdStr = ProcUtils.initializeCommandString(cmd, processName);
        final ExecutorService executor = ProcUtils.initializeExecutorService(cmdStr);
        return executor.submit(new Callable<Output>(){

            @Override
            public Output call() throws Exception {
                try {
                    Process proc = ProcUtils.startProcess(cmd, (Optional<String[]>)envp, (Optional<byte[]>)stdin, (Optional<String>)workingDir, (Optional<? extends IProcessTerminator>)terminator, (Optional<RemoteServer>)remoteServerConfig);
                    StreamGobbler outStreamGobbler = new StreamGobbler(proc.getInputStream(), cmdStr + "-out", (Optional<? extends OutputStream>)stdoutOutputStream);
                    outStreamGobbler.start();
                    StreamGobbler errStreamGobbler = new StreamGobbler(proc.getErrorStream(), cmdStr + "-err", (Optional<? extends OutputStream>)stderrOutputStream);
                    errStreamGobbler.start();
                    try {
                        log.trace("Task now waiting for the proces {} to finish.", (Object)cmdStr);
                        int retVal = proc.waitFor();
                        outStreamGobbler.join(4000L);
                        if (outStreamGobbler.isAlive()) {
                            log.error("Did not finish reading stdout");
                        }
                        errStreamGobbler.join(4000L);
                        if (errStreamGobbler.isAlive()) {
                            log.error("Did not finish reading stderr");
                        }
                        Output output = new Output(outStreamGobbler.getResult(), errStreamGobbler.getResult(), retVal);
                        return output;
                    }
                    catch (InterruptedException e) {
                        try {
                            log.debug("Process interrupted. Destroying...");
                            ProcUtils.destroyProcess(proc, (Optional<? extends IProcessTerminator>)terminator);
                            outStreamGobbler.interrupt();
                            errStreamGobbler.interrupt();
                            throw e;
                        }
                        catch (Throwable t) {
                            log.debug("Caught exception while running.", t);
                            throw Throwables.propagate((Throwable)t);
                        }
                    }
                }
                finally {
                    executor.shutdown();
                }
            }
        });
    }

    private static Future<Process> runBackgroundProcAndReturnProcessStructure(final @NonNull String[] cmd, final @NonNull Optional<String[]> envp, final @NonNull Optional<byte[]> stdin, final @NonNull Optional<String> workingDir, @NonNull Optional<String> processName, @NonNull Optional<? extends OutputStream> stdoutOutputStream, @NonNull Optional<? extends OutputStream> stderrOutputStream, final @NonNull Optional<? extends IProcessTerminator> terminator, final @NonNull Optional<RemoteServer> remoteServerConfig) {
        if (cmd == null) {
            throw new NullPointerException("cmd is marked non-null but is null");
        }
        if (envp == null) {
            throw new NullPointerException("envp is marked non-null but is null");
        }
        if (stdin == null) {
            throw new NullPointerException("stdin is marked non-null but is null");
        }
        if (workingDir == null) {
            throw new NullPointerException("workingDir is marked non-null but is null");
        }
        if (processName == null) {
            throw new NullPointerException("processName is marked non-null but is null");
        }
        if (stdoutOutputStream == null) {
            throw new NullPointerException("stdoutOutputStream is marked non-null but is null");
        }
        if (stderrOutputStream == null) {
            throw new NullPointerException("stderrOutputStream is marked non-null but is null");
        }
        if (terminator == null) {
            throw new NullPointerException("terminator is marked non-null but is null");
        }
        if (remoteServerConfig == null) {
            throw new NullPointerException("remoteServerConfig is marked non-null but is null");
        }
        String cmdStr = ProcUtils.initializeCommandString(cmd, processName);
        final ExecutorService executor = ProcUtils.initializeExecutorService(cmdStr);
        return executor.submit(new Callable<Process>(){

            @Override
            public Process call() throws Exception {
                try {
                    Process process = ProcUtils.startProcess(cmd, (Optional<String[]>)envp, (Optional<byte[]>)stdin, (Optional<String>)workingDir, (Optional<? extends IProcessTerminator>)terminator, (Optional<RemoteServer>)remoteServerConfig);
                    return process;
                }
                catch (Throwable t) {
                    log.debug("Caught exception while running.", t);
                    throw Throwables.propagate((Throwable)t);
                }
                finally {
                    executor.shutdown();
                }
            }
        });
    }

    private static String initializeCommandString(@NonNull String[] cmd, @NonNull Optional<String> processName) {
        if (cmd == null) {
            throw new NullPointerException("cmd is marked non-null but is null");
        }
        if (processName == null) {
            throw new NullPointerException("processName is marked non-null but is null");
        }
        String cmdStr = processName.isPresent() ? (String)processName.get() : ProcUtils.buildCmdString(cmd);
        return cmdStr;
    }

    private static ExecutorService initializeExecutorService(final String cmdStr) {
        ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r){

                    @Override
                    public void run() {
                        try {
                            super.run();
                        }
                        catch (Throwable t) {
                            log.debug("Caught an exception", t);
                            throw Throwables.propagate((Throwable)t);
                        }
                    }
                };
                t.setName("Process-" + cmdStr);
                return t;
            }
        });
        return executor;
    }

    private static Process startProcess(@NonNull String[] cmd, @NonNull Optional<String[]> envp, @NonNull Optional<byte[]> stdin, @NonNull Optional<String> workingDir, final @NonNull Optional<? extends IProcessTerminator> terminator, @NonNull Optional<RemoteServer> remoteServerConfig) {
        if (cmd == null) {
            throw new NullPointerException("cmd is marked non-null but is null");
        }
        if (envp == null) {
            throw new NullPointerException("envp is marked non-null but is null");
        }
        if (stdin == null) {
            throw new NullPointerException("stdin is marked non-null but is null");
        }
        if (workingDir == null) {
            throw new NullPointerException("workingDir is marked non-null but is null");
        }
        if (terminator == null) {
            throw new NullPointerException("terminator is marked non-null but is null");
        }
        if (remoteServerConfig == null) {
            throw new NullPointerException("remoteServerConfig is marked non-null but is null");
        }
        try {
            final Process proc = remoteServerConfig.isPresent() ? new RemoteProcess((RemoteServer)remoteServerConfig.get(), cmd, envp, workingDir) : ProcUtils.getRuntimeProcess(cmd, envp, workingDir);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    ProcUtils.destroyProcess(proc, (Optional<? extends IProcessTerminator>)terminator);
                }
            });
            ProcUtils.sendInputToProcess(proc, stdin);
            return proc;
        }
        catch (Throwable t) {
            log.debug("Caught exception while running.", t);
            throw Throwables.propagate((Throwable)t);
        }
    }

    private static void sendInputToProcess(@NonNull Process proc, @NonNull Optional<byte[]> stdin) {
        if (proc == null) {
            throw new NullPointerException("proc is marked non-null but is null");
        }
        if (stdin == null) {
            throw new NullPointerException("stdin is marked non-null but is null");
        }
        try {
            if (stdin.isPresent()) {
                OutputStream procIn = proc.getOutputStream();
                procIn.write((byte[])stdin.get());
                procIn.flush();
                procIn.close();
            }
        }
        catch (Throwable t) {
            log.debug("Caught exception while sending input to process.", t);
            throw Throwables.propagate((Throwable)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Output runProcAndReturnOutput(long timeoutMillis, @NonNull String[] cmd, @NonNull Optional<String[]> envp, @NonNull Optional<byte[]> stdin, @NonNull Optional<String> workingDir, @NonNull Optional<String> processName, @NonNull Optional<? extends OutputStream> stdoutOutputStream, @NonNull Optional<? extends OutputStream> stderrOutputStream, @NonNull Optional<? extends IProcessTerminator> terminator, @NonNull Optional<RemoteServer> remoteServerConfig) throws InterruptedException, TimeoutException, ExecutionException {
        if (cmd == null) {
            throw new NullPointerException("cmd is marked non-null but is null");
        }
        if (envp == null) {
            throw new NullPointerException("envp is marked non-null but is null");
        }
        if (stdin == null) {
            throw new NullPointerException("stdin is marked non-null but is null");
        }
        if (workingDir == null) {
            throw new NullPointerException("workingDir is marked non-null but is null");
        }
        if (processName == null) {
            throw new NullPointerException("processName is marked non-null but is null");
        }
        if (stdoutOutputStream == null) {
            throw new NullPointerException("stdoutOutputStream is marked non-null but is null");
        }
        if (stderrOutputStream == null) {
            throw new NullPointerException("stderrOutputStream is marked non-null but is null");
        }
        if (terminator == null) {
            throw new NullPointerException("terminator is marked non-null but is null");
        }
        if (remoteServerConfig == null) {
            throw new NullPointerException("remoteServerConfig is marked non-null but is null");
        }
        Future<Output> parseFuture = ProcUtils.runBackgroundProcAndReturnOutput(cmd, envp, stdin, workingDir, processName, stdoutOutputStream, stderrOutputStream, terminator, remoteServerConfig);
        try {
            Output output = parseFuture.get(timeoutMillis, TimeUnit.MILLISECONDS);
            return output;
        }
        finally {
            if (!parseFuture.isDone()) {
                parseFuture.cancel(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Process runProcAndReturnProcessStructure(long timeoutMillis, @NonNull String[] cmd, @NonNull Optional<String[]> envp, @NonNull Optional<byte[]> stdin, @NonNull Optional<String> workingDir, @NonNull Optional<String> processName, @NonNull Optional<? extends OutputStream> stdoutOutputStream, @NonNull Optional<? extends OutputStream> stderrOutputStream, @NonNull Optional<? extends IProcessTerminator> terminator, @NonNull Optional<RemoteServer> remoteServerConfig) throws InterruptedException, TimeoutException, ExecutionException {
        if (cmd == null) {
            throw new NullPointerException("cmd is marked non-null but is null");
        }
        if (envp == null) {
            throw new NullPointerException("envp is marked non-null but is null");
        }
        if (stdin == null) {
            throw new NullPointerException("stdin is marked non-null but is null");
        }
        if (workingDir == null) {
            throw new NullPointerException("workingDir is marked non-null but is null");
        }
        if (processName == null) {
            throw new NullPointerException("processName is marked non-null but is null");
        }
        if (stdoutOutputStream == null) {
            throw new NullPointerException("stdoutOutputStream is marked non-null but is null");
        }
        if (stderrOutputStream == null) {
            throw new NullPointerException("stderrOutputStream is marked non-null but is null");
        }
        if (terminator == null) {
            throw new NullPointerException("terminator is marked non-null but is null");
        }
        if (remoteServerConfig == null) {
            throw new NullPointerException("remoteServerConfig is marked non-null but is null");
        }
        Future<Process> parseFuture = ProcUtils.runBackgroundProcAndReturnProcessStructure(cmd, envp, stdin, workingDir, processName, stdoutOutputStream, stderrOutputStream, terminator, remoteServerConfig);
        try {
            Process process = parseFuture.get(timeoutMillis, TimeUnit.MILLISECONDS);
            return process;
        }
        finally {
            if (!parseFuture.isDone()) {
                parseFuture.cancel(true);
            }
        }
    }

    private static String buildCmdString(String[] cmd) {
        StringBuilder cmdStrBuilder = new StringBuilder();
        cmdStrBuilder.append("'");
        for (String cmdPart : cmd) {
            cmdStrBuilder.append(cmdPart).append(' ');
        }
        cmdStrBuilder.deleteCharAt(cmdStrBuilder.length() - 1);
        cmdStrBuilder.append("'");
        return cmdStrBuilder.toString();
    }

    private static void destroyProcess(final Process proc, Optional<? extends IProcessTerminator> terminator) {
        if (terminator.isPresent()) {
            try {
                ((IProcessTerminator)terminator.get()).terminateProcess(proc);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            proc.destroy();
        }
        AssertUtils.tryTillSuccess(IllegalThreadStateException.class, 5, TimeUnit.SECONDS.toMillis(2L), new Runnable(){

            @Override
            public void run() {
                proc.exitValue();
            }
        });
        try {
            proc.exitValue();
        }
        catch (Exception e) {
            throw new RuntimeException("Process is still running after calling destroy.");
        }
    }

    public static class ProcBuilder {
        private String[] cmd;
        private String[] cmdParameters;
        private String[] envp;
        private byte[] stdin;
        private String workingDir;
        private String processName;
        private OutputStream stdoutOutputStream;
        private OutputStream stderrOutputStream;
        private IProcessTerminator terminator;
        private RemoteServer remoteServerConfig;

        public ProcBuilder logOutputStreams(LogLevel level) {
            this.setStdoutOutputStream(new LogOutputStream(log, level, "[stdout] "));
            this.setStderrOutputStream(new LogOutputStream(log, level, "[stderr] "));
            return this;
        }

        public ProcRunner build() {
            String[] cmdWithParameters = null;
            if (this.cmd == null) {
                throw new RuntimeException("cmd is null - did you forget to set it?");
            }
            cmdWithParameters = this.cmdParameters != null ? (String[])ArrayUtils.addAll((Object[])this.cmd, (Object[])this.cmdParameters) : (String[])ArrayUtils.clone((Object[])this.cmd);
            return new ProcRunner(cmdWithParameters, (Optional<String[]>)Optional.fromNullable((Object)this.envp), (Optional<byte[]>)Optional.fromNullable((Object)this.stdin), (Optional<String>)Optional.fromNullable((Object)this.workingDir), (Optional<String>)Optional.fromNullable((Object)this.processName), (Optional<OutputStream>)Optional.fromNullable((Object)this.stdoutOutputStream), (Optional<OutputStream>)Optional.fromNullable((Object)this.stderrOutputStream), (Optional<IProcessTerminator>)Optional.fromNullable((Object)this.terminator), (Optional<RemoteServer>)Optional.fromNullable((Object)this.remoteServerConfig));
        }

        public ProcBuilder setCmd(String[] cmd) {
            this.cmd = cmd;
            return this;
        }

        public ProcBuilder setCmdParameters(String[] cmdParameters) {
            this.cmdParameters = cmdParameters;
            return this;
        }

        public ProcBuilder setEnvp(String[] envp) {
            this.envp = envp;
            return this;
        }

        public ProcBuilder setStdin(byte[] stdin) {
            this.stdin = stdin;
            return this;
        }

        public ProcBuilder setWorkingDir(String workingDir) {
            this.workingDir = workingDir;
            return this;
        }

        public ProcBuilder setProcessName(String processName) {
            this.processName = processName;
            return this;
        }

        public ProcBuilder setStdoutOutputStream(OutputStream stdoutOutputStream) {
            this.stdoutOutputStream = stdoutOutputStream;
            return this;
        }

        public ProcBuilder setStderrOutputStream(OutputStream stderrOutputStream) {
            this.stderrOutputStream = stderrOutputStream;
            return this;
        }

        public ProcBuilder setTerminator(IProcessTerminator terminator) {
            this.terminator = terminator;
            return this;
        }

        public ProcBuilder setRemoteServerConfig(RemoteServer remoteServerConfig) {
            this.remoteServerConfig = remoteServerConfig;
            return this;
        }

        private ProcBuilder() {
        }

        public String[] getCmd() {
            return this.cmd;
        }

        public String[] getEnvp() {
            return this.envp;
        }
    }

    public static class Output {
        private final String stdout;
        private final String stderr;
        private final int retVal;

        public Output(String stdout, String stderr, int retVal) {
            this.stdout = stdout;
            this.stderr = stderr;
            this.retVal = retVal;
        }

        public String getStdout() {
            return this.stdout;
        }

        public String getStderr() {
            return this.stderr;
        }

        public int getRetVal() {
            return this.retVal;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Output)) {
                return false;
            }
            Output other = (Output)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getRetVal() != other.getRetVal()) {
                return false;
            }
            String this$stdout = this.getStdout();
            String other$stdout = other.getStdout();
            if (this$stdout == null ? other$stdout != null : !this$stdout.equals(other$stdout)) {
                return false;
            }
            String this$stderr = this.getStderr();
            String other$stderr = other.getStderr();
            return !(this$stderr == null ? other$stderr != null : !this$stderr.equals(other$stderr));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Output;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getRetVal();
            String $stdout = this.getStdout();
            result = result * 59 + ($stdout == null ? 43 : $stdout.hashCode());
            String $stderr = this.getStderr();
            result = result * 59 + ($stderr == null ? 43 : $stderr.hashCode());
            return result;
        }

        public String toString() {
            return "ProcUtils.Output(stdout=" + this.getStdout() + ", stderr=" + this.getStderr() + ", retVal=" + this.getRetVal() + ")";
        }
    }

    public static class ProcRunner {
        @NonNull
        private String[] cmd;
        private Optional<String[]> envp;
        private Optional<byte[]> stdin;
        private Optional<String> workingDir;
        private Optional<String> processName;
        private Optional<OutputStream> stdoutOutputStream;
        private Optional<OutputStream> stderrOutputStream;
        private Optional<IProcessTerminator> terminator;
        private Optional<RemoteServer> remoteServerConfig;

        public Future<Output> runInBackground() {
            return ProcUtils.runBackgroundProcAndReturnOutput(this.cmd, this.envp, this.stdin, this.workingDir, this.processName, this.stdoutOutputStream, this.stderrOutputStream, this.terminator, this.remoteServerConfig);
        }

        public Output runAndReturnOutput(long timeoutInMillis) throws InterruptedException, ExecutionException, TimeoutException {
            return ProcUtils.runProcAndReturnOutput(timeoutInMillis, this.cmd, this.envp, this.stdin, this.workingDir, this.processName, this.stdoutOutputStream, this.stderrOutputStream, this.terminator, this.remoteServerConfig);
        }

        public Process runAndReturnProcessStructure(long timeoutInMillis) throws InterruptedException, ExecutionException, TimeoutException {
            return ProcUtils.runProcAndReturnProcessStructure(timeoutInMillis, this.cmd, this.envp, this.stdin, this.workingDir, this.processName, this.stdoutOutputStream, this.stderrOutputStream, this.terminator, this.remoteServerConfig);
        }

        ProcRunner(@NonNull String[] cmd, Optional<String[]> envp, Optional<byte[]> stdin, Optional<String> workingDir, Optional<String> processName, Optional<OutputStream> stdoutOutputStream, Optional<OutputStream> stderrOutputStream, Optional<IProcessTerminator> terminator, Optional<RemoteServer> remoteServerConfig) {
            if (cmd == null) {
                throw new NullPointerException("cmd is marked non-null but is null");
            }
            this.cmd = cmd;
            this.envp = envp;
            this.stdin = stdin;
            this.workingDir = workingDir;
            this.processName = processName;
            this.stdoutOutputStream = stdoutOutputStream;
            this.stderrOutputStream = stderrOutputStream;
            this.terminator = terminator;
            this.remoteServerConfig = remoteServerConfig;
        }
    }

    public static class StreamGobbler
    extends Thread {
        private static final Logger log = LoggerFactory.getLogger(StreamGobbler.class);
        private final InputStream input;
        private final Optional<? extends OutputStream> logOutputStream;
        private final byte[] buff;
        private String result;

        public StreamGobbler(InputStream input, String name, Optional<? extends OutputStream> logOutputStream) {
            this.input = input;
            this.logOutputStream = logOutputStream;
            this.buff = new byte[512];
            this.setDaemon(true);
            this.setName("StreamGobbler-" + name);
        }

        @Override
        public void run() {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            try {
                int read;
                while ((read = this.input.read(this.buff)) != -1) {
                    output.write(this.buff, 0, read);
                    if (!this.logOutputStream.isPresent()) continue;
                    ((OutputStream)this.logOutputStream.get()).write(this.buff, 0, read);
                }
                this.result = output.toString();
            }
            catch (IOException e) {
                log.warn("Could not get output", (Throwable)e);
            }
        }

        public String getResult() {
            return this.result;
        }
    }
}

