/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.test.utils.remote;

import com.appdynamics.voltron.test.utils.ssh.RemoteFileSystem;
import com.google.common.base.Optional;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import lombok.NonNull;
import org.apache.commons.io.FileUtils;

public class PlatformFile {
    private final IPlatformFileInternal platformFileInternal;

    public PlatformFile(String path, Optional<? extends RemoteFileSystem> remoteFileSystem) {
        this.platformFileInternal = remoteFileSystem.isPresent() ? new RemotePlatformFile(path, (RemoteFileSystem)remoteFileSystem.get()) : new LocalPlatformFile(path);
    }

    public File copyToTemp(@NonNull File localFile) throws IOException {
        if (localFile == null) {
            throw new NullPointerException("localFile is marked non-null but is null");
        }
        this.platformFileInternal.copyTo(localFile);
        return localFile;
    }

    public File copyToTemp() throws IOException {
        File localFile = File.createTempFile("temp", null);
        localFile.deleteOnExit();
        return this.copyToTemp(localFile);
    }

    public void copyFrom(@NonNull File localFile) throws IOException {
        if (localFile == null) {
            throw new NullPointerException("localFile is marked non-null but is null");
        }
        this.platformFileInternal.copyFrom(localFile);
    }

    public String getAbsolutePath() {
        return this.platformFileInternal.getAbsolutePath();
    }

    public String getCanonicalPath() {
        return this.platformFileInternal.getCanonicalPath();
    }

    public boolean isFile() {
        return this.platformFileInternal.isFile();
    }

    public boolean isDirectory() {
        return this.platformFileInternal.isDirectory();
    }

    public void deleteDirectory() throws IOException {
        this.platformFileInternal.deleteDirectory();
    }

    public void makeDirectory() throws IOException {
        this.platformFileInternal.makeDirectory();
    }

    public String readToString() throws IOException {
        File tempFile = this.copyToTemp();
        return FileUtils.readFileToString((File)tempFile);
    }

    public String toString() {
        return "PlatformFile(platformFileInternal=" + String.valueOf(this.platformFileInternal) + ")";
    }

    private class RemotePlatformFile
    implements IPlatformFileInternal {
        private final String path;
        private final RemoteFileSystem remoteFileSystem;

        private RemotePlatformFile(String path, RemoteFileSystem remoteFileSystem) {
            this.path = path.replace('\\', '/');
            this.remoteFileSystem = remoteFileSystem;
        }

        @Override
        public void copyTo(File destFile) throws IOException {
            this.remoteFileSystem.transferFromRemote(this.getAbsolutePath(), destFile);
        }

        @Override
        public void copyFrom(File srcFile) throws IOException {
            String absolutePath = this.getAbsolutePath();
            if (this.remoteFileSystem.isDirectory(absolutePath)) {
                this.remoteFileSystem.transferFromLocal(srcFile, Paths.get(absolutePath, srcFile.getName()).toString());
            } else {
                this.remoteFileSystem.transferFromLocal(srcFile, absolutePath);
            }
        }

        @Override
        public String getAbsolutePath() {
            return this.remoteFileSystem.getAbsolutePath(this.path);
        }

        @Override
        public String getCanonicalPath() {
            return this.getAbsolutePath();
        }

        @Override
        public boolean isFile() {
            return this.remoteFileSystem.isFile(this.path);
        }

        @Override
        public boolean isDirectory() {
            return this.remoteFileSystem.isDirectory(this.path);
        }

        @Override
        public void deleteDirectory() throws IOException {
            this.remoteFileSystem.rmDir(this.path);
        }

        @Override
        public void makeDirectory() throws IOException {
            this.remoteFileSystem.mkDir(this.path);
        }

        public String toString() {
            return "PlatformFile.RemotePlatformFile(path=" + this.path + ", remoteFileSystem=" + String.valueOf(this.remoteFileSystem) + ")";
        }
    }

    private static interface IPlatformFileInternal {
        public void copyTo(File var1) throws IOException;

        public void copyFrom(File var1) throws IOException;

        public String getAbsolutePath();

        public String getCanonicalPath();

        public boolean isFile();

        public boolean isDirectory();

        public void deleteDirectory() throws IOException;

        public void makeDirectory() throws IOException;
    }

    private class LocalPlatformFile
    implements IPlatformFileInternal {
        private final File file;

        LocalPlatformFile(String path) {
            this.file = new File(path);
        }

        @Override
        public void copyTo(File destFile) throws IOException {
            FileUtils.copyFile((File)this.file, (File)destFile);
        }

        @Override
        public void copyFrom(File srcFile) throws IOException {
            if (this.file.isDirectory()) {
                FileUtils.copyFileToDirectory((File)srcFile, (File)this.file);
            } else {
                FileUtils.copyFile((File)srcFile, (File)this.file);
            }
        }

        @Override
        public String getAbsolutePath() {
            return this.file.getAbsolutePath();
        }

        @Override
        public String getCanonicalPath() {
            try {
                return this.file.getCanonicalPath();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to get canonical path for " + String.valueOf(this.file), e);
            }
        }

        @Override
        public boolean isFile() {
            return this.file.isFile();
        }

        @Override
        public boolean isDirectory() {
            return this.file.isDirectory();
        }

        @Override
        public void deleteDirectory() throws IOException {
            FileUtils.deleteDirectory((File)this.file);
        }

        @Override
        public void makeDirectory() throws IOException {
            FileUtils.forceMkdir((File)this.file);
        }

        public String toString() {
            return "PlatformFile.LocalPlatformFile(file=" + String.valueOf(this.file) + ")";
        }
    }

    private static class PathUtils {
        private static final Character DIR_DELIM = Character.valueOf(File.separatorChar);

        private PathUtils() {
        }

        private static String stripDelimAtBegin(String text) {
            String result = text.trim();
            int index = 0;
            if (result.startsWith(String.valueOf(DIR_DELIM))) {
                result = result.substring(index + 1).trim();
            }
            return result;
        }

        private static String stripDelimAtEnd(String text) {
            String result = text.trim();
            if (result.endsWith(String.valueOf(DIR_DELIM))) {
                int index = result.length() - 1;
                result = result.substring(0, index - 1);
            }
            return result;
        }

        public static String makePath(@NonNull Collection<String> paths, @NonNull Optional<? extends RemoteFileSystem> remoteFileSystem) {
            if (paths == null) {
                throw new NullPointerException("paths is marked non-null but is null");
            }
            if (remoteFileSystem == null) {
                throw new NullPointerException("remoteFileSystem is marked non-null but is null");
            }
            Object result = "";
            for (String currentPathPart : paths) {
                if (remoteFileSystem.isPresent()) {
                    currentPathPart = currentPathPart.trim();
                    currentPathPart = PathUtils.stripDelimAtBegin(currentPathPart);
                    if (((String)result).length() > 0) {
                        result = PathUtils.stripDelimAtEnd((String)result);
                        result = (String)result + DIR_DELIM;
                    }
                    result = (String)result + currentPathPart;
                    continue;
                }
                result = Paths.get((String)result, currentPathPart).toString();
            }
            return ((String)result).replace("\\", "/");
        }
    }

    public static class PlatformFileBuilder {
        private final Optional<? extends RemoteFileSystem> remoteFileSystem;

        public PlatformFile buildFrom(String ... paths) {
            String path = PathUtils.makePath(Arrays.asList(paths), this.remoteFileSystem);
            return new PlatformFile(path, this.remoteFileSystem);
        }

        public PlatformFileBuilder(Optional<? extends RemoteFileSystem> remoteFileSystem) {
            this.remoteFileSystem = remoteFileSystem;
        }
    }
}

