/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.test.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZipUtils {
    private static final Logger log = LoggerFactory.getLogger(ZipUtils.class);
    private static final int BUFFER_SIZE = 1024;

    public static void unzip(File zipFile, File destDir) {
        try {
            FileUtils.forceMkdir((File)destDir);
            ZipFile zip = new ZipFile(zipFile);
            Enumeration zipEntries = zip.getEntries();
            while (zipEntries.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)zipEntries.nextElement();
                if (entry.isDirectory()) {
                    File dir = new File(destDir, entry.getName());
                    FileUtils.forceMkdir((File)dir);
                    continue;
                }
                File out = new File(destDir, entry.getName());
                InputStream stream = zip.getInputStream(entry);
                FileUtils.copyInputStreamToFile((InputStream)stream, (File)out);
                stream.close();
                if (SystemUtils.IS_OS_WINDOWS) continue;
                String perms = ZipUtils.unixPermsIntToStr(entry.getUnixMode());
                try {
                    Files.setPosixFilePermissions(out.toPath(), PosixFilePermissions.fromString(perms));
                }
                catch (UnsupportedOperationException e) {
                    log.warn("Could not set the permissions on unzipped file {}", (Object)out, (Object)e);
                }
            }
            zip.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static String unixPermsIntToStr(int perms) {
        char[] permsChars = new char[]{'r', 'w', 'x', 'r', 'w', 'x', 'r', 'w', 'x'};
        int useablePerms = perms & 0x1FF;
        String permsBinary = String.format("%9s", Integer.toBinaryString(useablePerms)).replace(' ', '0');
        for (int i = 0; i < permsChars.length; ++i) {
            if (permsBinary.charAt(i) == '1') continue;
            permsChars[i] = 45;
        }
        return new String(permsChars);
    }

    static List<File> getAllFiles(File sourceDir) throws IOException {
        ArrayList<File> fileList = new ArrayList<File>();
        ZipUtils.getAllFilesRecursive(sourceDir, fileList);
        return fileList;
    }

    static void getAllFilesRecursive(File sourceDir, List<File> fileList) throws IOException {
        File[] files;
        for (File file : files = sourceDir.listFiles()) {
            fileList.add(file);
            if (file.isDirectory()) {
                log.info("directory:" + file.getCanonicalPath());
                ZipUtils.getAllFilesRecursive(file, fileList);
                continue;
            }
            log.info("Get file:" + file.getCanonicalPath());
        }
    }

    public static String writeZipFile(File directoryToZip, Collection<File> fileList) throws IOException {
        String zipFileFullPath = String.valueOf(directoryToZip) + ".zip";
        try (FileOutputStream fos = new FileOutputStream(zipFileFullPath);){
            String string;
            try (ZipOutputStream zos = new ZipOutputStream(fos);){
                for (File file : fileList) {
                    if (file.isDirectory()) continue;
                    log.info("Add File: " + file.getName());
                    String zipFilePath = ZipUtils.getRelativePath(directoryToZip, file);
                    log.info("Writing '" + zipFilePath + "' to zip file");
                    ZipArchiveEntry zipEntry = new ZipArchiveEntry(zipFilePath);
                    zos.putNextEntry((ZipEntry)zipEntry);
                    byte[] bytes = new byte[1024];
                    try (FileInputStream fis = new FileInputStream(file);){
                        int length;
                        while ((length = fis.read(bytes)) >= 0) {
                            zos.write(bytes, 0, length);
                        }
                    }
                    zos.closeEntry();
                }
                string = zipFileFullPath;
            }
            return string;
        }
    }

    public static String getRelativePath(File base, File actual) {
        Path pathAbsolute = Paths.get(actual.getAbsolutePath(), new String[0]);
        Path pathBase = Paths.get(base.getAbsolutePath(), new String[0]);
        Path pathRelative = pathBase.relativize(pathAbsolute);
        return pathRelative.toString();
    }

    private ZipUtils() {
    }
}

