/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.test.utils;

import java.lang.reflect.Field;
import java.util.Stack;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionRule
extends ExternalResource {
    private static Logger logger = LoggerFactory.getLogger(ReflectionRule.class);
    protected Stack<ReflectionChange> changes = new Stack();

    public void before() {
        this.changes.clear();
    }

    public void after() {
        this.restoreReflectionChanges();
    }

    public void setField(Object owner, String fieldName, Object value) throws IllegalAccessException, NoSuchFieldException {
        Field field = this.getField(owner, fieldName);
        Object original = field.get(owner);
        this.changes.push(new ReflectionChange(owner, field, original));
        field.set(owner, value);
    }

    private Field getField(Object owner, String fieldName) throws NoSuchFieldException {
        for (Class<?> aClass = owner.getClass(); aClass != null; aClass = aClass.getSuperclass()) {
            try {
                Field field = aClass.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field;
            }
            catch (Exception exception) {
                continue;
            }
        }
        throw new NoSuchFieldException(fieldName + " is not found");
    }

    private void restoreReflectionChanges() {
        while (!this.changes.isEmpty()) {
            try {
                ReflectionChange change = this.changes.pop();
                change.field.set(change.owner, change.originalValue);
            }
            catch (Exception e) {
                logger.warn("failed to recover field");
            }
        }
    }

    static class ReflectionChange {
        public Field field;
        public Object owner;
        public Object originalValue;

        public ReflectionChange(Object owner, Field field, Object originalValue) {
            this.owner = owner;
            this.field = field;
            this.originalValue = originalValue;
        }
    }
}

