/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.test.utils;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.lang.annotation.Annotation;
import java.util.List;
import org.junit.Assert;
import org.mockito.Mockito;

public class ModuleTester {
    public static final boolean SHOULD_BE_SINGLETON = true;
    public static final boolean SHOULD_NOT_BE_SINGLETON = false;
    public static final Optional<Boolean> NO_SINGLETON_PARAM = Optional.absent();
    private final Module mockModule;

    protected ModuleTester(Module mockModule) {
        this.mockModule = mockModule;
    }

    public static Builder builder() {
        return new Builder();
    }

    public <T> T testInject(Module target, Class<T> requiredClass, boolean shouldBeSingleton) {
        return this.testInject(target, requiredClass, (Optional<Boolean>)Optional.of((Object)shouldBeSingleton));
    }

    public <T> T testInject(Module target, Key<T> requiredClass, boolean shouldBeSingleton) {
        return this.testInject(target, requiredClass, (Optional<Boolean>)Optional.of((Object)shouldBeSingleton));
    }

    public <T> T testInject(Module target, Class<T> requiredClass, Optional<Boolean> shouldBeSingleton) {
        return this.testInject(target, Key.get(requiredClass), shouldBeSingleton);
    }

    public <T> T testInject(Module target, Key<T> requiredClass, Optional<Boolean> shouldBeSingleton) {
        Injector injector = this.buildInjector(target);
        Object requiredInstance = injector.getInstance(requiredClass);
        Object secondInstance = injector.getInstance(requiredClass);
        if (shouldBeSingleton.isPresent()) {
            if (((Boolean)shouldBeSingleton.get()).booleanValue()) {
                Assert.assertSame((String)("Injected type " + String.valueOf(requiredClass) + " was not a singleton."), (Object)requiredInstance, (Object)secondInstance);
            } else {
                Assert.assertNotSame((String)("Injected type " + String.valueOf(requiredClass) + " was a singleton."), (Object)requiredInstance, (Object)secondInstance);
            }
        }
        this.stop();
        return (T)requiredInstance;
    }

    public Injector buildinjectorWithOverridingModule(Module target) {
        return this.createInjector((List<Module>)ImmutableList.of((Object)Modules.override((Module[])new Module[]{target}).with(new Module[]{this.mockModule})));
    }

    public Injector buildInjector(Module target) {
        ImmutableList modules = ImmutableList.builder().add((Object)target).add((Object)this.mockModule).build();
        return this.createInjector((List<Module>)modules);
    }

    public Injector buildInjector() {
        ImmutableList modules = ImmutableList.builder().add((Object)this.mockModule).build();
        return this.createInjector((List<Module>)modules);
    }

    protected Injector createInjector(List<Module> modules) {
        return Guice.createInjector(modules);
    }

    protected void stop() {
    }

    public static class Builder {
        private final ImmutableList.Builder<Module> mockModules = ImmutableList.builder();
        private final ImmutableList.Builder<Module> overrideModules = ImmutableList.builder();

        protected Builder() {
        }

        public <T> Builder addMock(final Key<T> mockKey) {
            this.mockModules.add((Object)new AbstractModule(){

                protected void configure() {
                    this.bind(mockKey).toInstance(Mockito.mock((Class)mockKey.getTypeLiteral().getRawType()));
                }
            });
            return this;
        }

        public <T> Builder addMock(final Class<T> mockClass) {
            this.mockModules.add((Object)new AbstractModule(){

                protected void configure() {
                    this.bind(mockClass).toInstance(Mockito.mock((Class)mockClass));
                }
            });
            return this;
        }

        public <T> Builder addMock(final Class<T> mockClass, final Class<? extends Annotation> annotationClass) {
            this.mockModules.add((Object)new AbstractModule(){

                protected void configure() {
                    this.bind(mockClass).annotatedWith(annotationClass).toInstance(Mockito.mock((Class)mockClass));
                }
            });
            return this;
        }

        public <T> Builder addMock(final Class<T> mockClass, final Annotation annotation) {
            this.mockModules.add((Object)new AbstractModule(){

                protected void configure() {
                    this.bind(mockClass).annotatedWith(annotation).toInstance(Mockito.mock((Class)mockClass));
                }
            });
            return this;
        }

        public <T> Builder overrideWithMock(final Key<T> mockKey) {
            this.overrideModules.add((Object)new AbstractModule(){

                protected void configure() {
                    this.bind(mockKey).toInstance(Mockito.mock((Class)mockKey.getTypeLiteral().getRawType()));
                }
            });
            return this;
        }

        public <T> Builder overrideWithMock(final Class<T> mockClass) {
            this.overrideModules.add((Object)new AbstractModule(){

                protected void configure() {
                    this.bind(mockClass).toInstance(Mockito.mock((Class)mockClass));
                }
            });
            return this;
        }

        public <T> Builder overrideWithMock(final Class<T> mockClass, final Class<? extends Annotation> annotationClass) {
            this.overrideModules.add((Object)new AbstractModule(){

                protected void configure() {
                    this.bind(mockClass).annotatedWith(annotationClass).toInstance(Mockito.mock((Class)mockClass));
                }
            });
            return this;
        }

        public <T> Builder overrideWithMock(final Class<T> mockClass, final Annotation annotation) {
            this.overrideModules.add((Object)new AbstractModule(){

                protected void configure() {
                    this.bind(mockClass).annotatedWith(annotation).toInstance(Mockito.mock((Class)mockClass));
                }
            });
            return this;
        }

        public Builder addModule(Module module) {
            this.mockModules.add((Object)module);
            return this;
        }

        public Builder overrideWith(Module module) {
            this.overrideModules.add((Object)module);
            return this;
        }

        public ModuleTester build() {
            return new ModuleTester(Modules.override((Iterable)this.mockModules.build()).with((Iterable)this.overrideModules.build()));
        }

        public ImmutableList.Builder<Module> getMockModules() {
            return this.mockModules;
        }

        public ImmutableList.Builder<Module> getOverrideModules() {
            return this.overrideModules;
        }
    }
}

