/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.test.utils;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.Arrays;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpUtils.class);

    public static int findFreePort() {
        int[] ports = HttpUtils.findFreePorts(1);
        if (ports == null) {
            return -1;
        }
        return ports[0];
    }

    public static int findFreePortOrFail() {
        int[] ports = HttpUtils.findFreePorts(1);
        if (ports == null) {
            throw new RuntimeException("Could not find a free port");
        }
        return ports[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] findFreePorts(int num) {
        log.debug("Getting free port numbers...");
        int[] ports = new int[num];
        HashSet<Integer> portSet = new HashSet<Integer>(num);
        ServerSocket[] sockets = new ServerSocket[num];
        try {
            for (int i = 0; i < num; ++i) {
                do {
                    try {
                        if (sockets[i] != null) {
                            sockets[i].close();
                        }
                        ServerSocket socket = new ServerSocket();
                        socket.setReuseAddress(true);
                        socket.bind(null);
                        ports[i] = socket.getLocalPort();
                        sockets[i] = socket;
                    }
                    catch (IOException e) {
                        log.warn("Could not get free port", (Throwable)e);
                        int[] nArray = null;
                        for (ServerSocket socket : sockets) {
                            if (socket == null) continue;
                            try {
                                socket.close();
                            }
                            catch (IOException e2) {
                                log.warn("Could not close socket on port " + socket.getLocalPort(), (Throwable)e2);
                            }
                        }
                        return nArray;
                    }
                } while (portSet.contains(ports[i]));
                portSet.add(ports[i]);
            }
        }
        finally {
            for (ServerSocket socket : sockets) {
                if (socket == null) continue;
                try {
                    socket.close();
                }
                catch (IOException e) {
                    log.warn("Could not close socket on port " + socket.getLocalPort(), (Throwable)e);
                }
            }
        }
        log.debug("Returning ports {}", (Object)Arrays.toString(ports));
        return ports;
    }

    private HttpUtils() {
    }
}

