/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.test.utils;

import com.appdynamics.voltron.test.utils.LogLevel;
import com.appdynamics.voltron.test.utils.remote.ProcUtils;
import com.google.common.base.Optional;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GradleUtil {
    private static final Logger log = LoggerFactory.getLogger(GradleUtil.class);
    private static final int BUILD_PROC_TIMEOUT_SECS = 3600;
    private static final String GRADLE_FILE = "gradlew";
    private static final String PROJECT_DIR_PATH_OPTION = "-p";

    public static void runGradleCommandFromDirectory(String gradleFilePathFromCodebase, String[] systemProperty, String gradleCommand, Optional<String> workingDirectory) {
        String gradleCmd = GradleUtil.buildGradleCommand();
        File rootDir = GradleUtil.getCodebaseRootDir();
        if (!rootDir.exists()) {
            log.debug("Did not find root codebase directory");
            throw new RuntimeException("Did not find root codebase directory");
        }
        File gradlewFile = GradleUtil.findGradlewFileAtCodebase(gradleCmd, rootDir);
        Path gradleFilePath = Paths.get(rootDir.getAbsolutePath(), gradleFilePathFromCodebase);
        String workingDirectoryPath = workingDirectory.isPresent() ? Paths.get(rootDir.getAbsolutePath(), (String)workingDirectory.get()).toString() : rootDir.getAbsolutePath();
        try {
            ArrayList<String> commands = new ArrayList<String>();
            commands.add(gradlewFile.getCanonicalPath());
            commands.add(PROJECT_DIR_PATH_OPTION);
            commands.add(gradleFilePath.toString());
            if (systemProperty.length != 0) {
                commands.addAll(Arrays.asList(systemProperty));
            }
            commands.add(gradleCommand);
            ProcUtils.Output output = ProcUtils.builder().setCmd(commands.toArray(new String[commands.size()])).setWorkingDir(workingDirectoryPath).logOutputStreams(LogLevel.DEBUG).build().runAndReturnOutput(TimeUnit.SECONDS.toMillis(3600L));
            if (!output.getStdout().contains("BUILD SUCCESSFUL")) {
                log.error("Gradle execution failed:\n{}\n{}", (Object)output.getStdout(), (Object)output.getStderr());
                throw new RuntimeException("Gradle execution failed");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Gradle execution failed", e);
        }
    }

    private static File getCodebaseRootDir() {
        String workingDir = System.getProperty("user.dir");
        for (File currentDir = new File(workingDir); currentDir != null && currentDir.exists(); currentDir = currentDir.getParentFile()) {
            File file = new File(currentDir, GRADLE_FILE);
            if (!file.exists()) continue;
            return currentDir;
        }
        throw new RuntimeException("Could not find the codebase root dir containing gradlew scripts.");
    }

    private static File findGradlewFileAtCodebase(String gradleCmd, File rootDir) {
        File gradlewFile = new File(gradleCmd);
        if (!gradlewFile.exists() && !(gradlewFile = new File(rootDir, gradleCmd)).exists()) {
            log.debug("Did not find gradlew file at codebase");
            throw new RuntimeException("Could not find gradlew in the current dir or root.");
        }
        return gradlewFile;
    }

    private static String buildGradleCommand() {
        String gradleCmd = "./gradlew";
        if (SystemUtils.IS_OS_WINDOWS) {
            gradleCmd = "gradlew.bat";
        }
        return gradleCmd;
    }
}

