/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.test.utils;

import com.google.common.base.Throwables;
import java.util.concurrent.Callable;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.mockito.Matchers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AssertUtils {
    private static final Logger log = LoggerFactory.getLogger(AssertUtils.class);

    public static <T extends Throwable> T assertThrows(Class<T> throwableClass, final Runnable runnable) {
        return AssertUtils.assertThrows(throwableClass, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                runnable.run();
                return null;
            }
        });
    }

    public static <T extends Throwable> T assertThrows(Class<T> throwableClass, Callable<?> callable) {
        try {
            callable.call();
            Assert.fail((String)("Failed to throw exception of type " + throwableClass.getSimpleName()));
            return null;
        }
        catch (Throwable t) {
            if (!throwableClass.isInstance(t)) {
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw new RuntimeException(t);
            }
            return (T)((Throwable)throwableClass.cast(t));
        }
    }

    public static void tryTillSuccess(Class<? extends Throwable> exceptionClass, int numTries, long period, final Runnable runnable) {
        AssertUtils.tryTillSuccess(exceptionClass, numTries, period, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                runnable.run();
                return null;
            }
        });
    }

    public static <T> T tryTillSuccess(Class<? extends Throwable> exceptionClass, int numTries, long period, Callable<T> callable) {
        return AssertUtils.tryTillSuccess(exceptionClass, numTries, period, 0L, callable);
    }

    public static <T> T tryTillSuccess(Class<? extends Throwable> exceptionClass, int numTries, long period, long initialDelay, Callable<T> callable) {
        Throwable last = null;
        try {
            Thread.sleep(initialDelay);
        }
        catch (InterruptedException e) {
            log.warn("Thread interrupted from sleep");
        }
        for (int i = 0; i < numTries; ++i) {
            try {
                return callable.call();
            }
            catch (Throwable e) {
                if (!exceptionClass.isInstance(e)) {
                    throw new RuntimeException(e);
                }
                last = e;
                try {
                    Thread.sleep(period);
                    continue;
                }
                catch (InterruptedException e2) {
                    throw new RuntimeException(e2);
                }
            }
        }
        if (last != null) {
            throw Throwables.propagate(last);
        }
        throw new RuntimeException("Found last exception null. This is an unexpected code path.");
    }

    public static void tryTillFailure(int numTries, long period, Runnable runnable) {
        for (int i = 0; i < numTries; ++i) {
            try {
                runnable.run();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            try {
                Thread.sleep(period);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static <T> T instanceOf(Class<T> type) {
        return (T)Matchers.argThat((Matcher)CoreMatchers.instanceOf(type));
    }

    private AssertUtils() {
    }
}

