/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron.testutils.rest;

import com.appdynamics.voltron.test.utils.BetterTemporaryFolder;
import com.google.common.base.Throwables;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public final class KeyStores
extends ExternalResource {
    public static final String CA_CERT_ALIAS = "cacert";
    public static final String CLIENT_PRIVATE_KEY_CERT_ALIAS = "clientkeycert";
    public static final String KEYSTORE_PASSWORD = "password";
    public static final String PRIVATE_KEY_PASSWORD = "private_password";
    private static final String SERVER_TRUSTSTORE_FILENAME = "serverkeystore.jks";
    public static final String SERVER_CERT_ALIAS = "servercert";
    private static final String CLIENT_COMBINED_KEYSTORE_AND_TRUSTSTORE_FILENAME = "clientkeystore.jks";
    private final KeyStore clientKeyStore;
    private final KeyStore clientTrustStore;
    private final KeyStore serverTrustStore;
    private final BetterTemporaryFolder temp;

    public KeyStores() {
        KeyStore combinedKeyAndTrustStore;
        this.clientKeyStore = combinedKeyAndTrustStore = this.buildKeyStore(CLIENT_COMBINED_KEYSTORE_AND_TRUSTSTORE_FILENAME, KEYSTORE_PASSWORD);
        this.clientTrustStore = combinedKeyAndTrustStore;
        this.serverTrustStore = this.buildKeyStore(SERVER_TRUSTSTORE_FILENAME, KEYSTORE_PASSWORD);
        this.temp = new BetterTemporaryFolder();
    }

    public X509Certificate getCaCert() throws KeyStoreException {
        return (X509Certificate)this.clientTrustStore.getCertificate(CA_CERT_ALIAS);
    }

    public X509Certificate getServerCert() throws KeyStoreException {
        return (X509Certificate)this.serverTrustStore.getCertificate(SERVER_CERT_ALIAS);
    }

    public X509Certificate[] getServerCertChain() throws KeyStoreException {
        Certificate[] certs = this.serverTrustStore.getCertificateChain(SERVER_CERT_ALIAS);
        X509Certificate[] serverCertChain = new X509Certificate[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            serverCertChain[i] = (X509Certificate)certs[i];
        }
        return serverCertChain;
    }

    public PrivateKey getClientCertPrivateKey() {
        PrivateKey result;
        String privateKeyAlias = CLIENT_PRIVATE_KEY_CERT_ALIAS;
        String privateKeyEntryPassword = PRIVATE_KEY_PASSWORD;
        try {
            char[] privateKeyPasswordCharArr = null;
            if (privateKeyEntryPassword != null) {
                privateKeyPasswordCharArr = privateKeyEntryPassword.toCharArray();
            }
            result = (PrivateKey)this.clientKeyStore.getKey(privateKeyAlias, privateKeyPasswordCharArr);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new RuntimeException("Could not get private key for alias:" + privateKeyAlias);
        }
        return result;
    }

    public Certificate[] getClientCertChain() {
        Certificate[] result;
        String privateKeyAlias = CLIENT_PRIVATE_KEY_CERT_ALIAS;
        try {
            result = this.clientKeyStore.getCertificateChain(privateKeyAlias);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException("Could not get private key for alias:" + privateKeyAlias);
        }
        return result;
    }

    public X509Certificate[] getCertificates() {
        ArrayList<X509Certificate> result = new ArrayList<X509Certificate>();
        try {
            Enumeration<String> iterator = this.clientKeyStore.aliases();
            while (iterator.hasMoreElements()) {
                String alias = iterator.nextElement();
                Certificate certificate = this.clientKeyStore.getCertificate(alias);
                if (!(certificate instanceof X509Certificate)) continue;
                result.add((X509Certificate)certificate);
            }
        }
        catch (KeyStoreException e) {
            throw new RuntimeException("Could not get certificates for key store");
        }
        return result.toArray(new X509Certificate[result.size()]);
    }

    public URL getServerTrustStoreUrl() {
        return ((Object)((Object)this)).getClass().getResource(SERVER_TRUSTSTORE_FILENAME);
    }

    private KeyStore buildKeyStore(String keystoreName, String password) {
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        InputStream keystoreStream = ((Object)((Object)this)).getClass().getResourceAsStream(keystoreName);
        if (keystoreStream == null) {
            throw new RuntimeException("Did not find keystore resource " + keystoreName);
        }
        keystore.load(keystoreStream, password.toCharArray());
        return keystore;
    }

    private static void copyKeyStoreToFile(KeyStore keystore, File file, String password) {
        try (FileOutputStream out = new FileOutputStream(file);){
            keystore.store(out, password.toCharArray());
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
    }

    public File getClientCombinedKeyStoreAndTrustStoreFile() {
        return new File(this.temp.getRoot(), "clientcert.jks");
    }

    public void before() throws Throwable {
        KeyStores.copyKeyStoreToFile(this.clientTrustStore, this.getClientCombinedKeyStoreAndTrustStoreFile(), KEYSTORE_PASSWORD);
    }

    public Statement apply(Statement base, Description description) {
        return this.temp.apply(super.apply(base, description), description);
    }

    public KeyStore getClientKeyStore() {
        return this.clientKeyStore;
    }

    public KeyStore getClientTrustStore() {
        return this.clientTrustStore;
    }

    public KeyStore getServerTrustStore() {
        return this.serverTrustStore;
    }
}

