/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.var;

import com.appdynamics.common.io.file.FileSource;
import com.appdynamics.common.util.configuration.Parameters;
import com.appdynamics.common.util.configuration.property.ConfigurationProperties;
import com.appdynamics.common.util.var.CalendarVariableResolver;
import com.appdynamics.common.util.var.ChainedVariableResolver;
import com.appdynamics.common.util.var.ConfigurationPropertiesVariableResolver;
import com.appdynamics.common.util.var.EchoVariableResolver;
import com.appdynamics.common.util.var.FileIncludeVariableResolver;
import com.appdynamics.common.util.var.MapBasedVariableResolver;
import com.appdynamics.common.util.var.SystemPropertyResolver;
import com.appdynamics.common.util.var.SystemVariableResolver;
import com.appdynamics.common.util.var.VariableResolver;
import com.google.common.escape.CharEscaperBuilder;
import com.google.common.escape.Escaper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Variables {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Variables.class);
    static final Escaper MATCHER_ESCAPER = new CharEscaperBuilder().addEscape('$', "\\$").addEscape('\\', "\\\\").toEscaper();
    static final String VARIABLE_FRAGMENT = "[a-zA-Z_\\$][a-zA-Z_\\$0-9-]*";
    static final String VARIABLE = "[a-zA-Z_\\$][a-zA-Z_\\$0-9-]*(?:\\.[a-zA-Z_\\$][a-zA-Z_\\$0-9-]*)*";
    static final String VARIABLE_MARKER_START = "\\$\\{";
    static final String VARIABLE_MARKER_END = "\\}";
    public static final String VARIABLE_EXTENSION = "(?:\\(([^\\(\\)]+)\\))?";
    public static final String VARIABLE_SYNTAX = "\\$\\{([a-zA-Z_\\$][a-zA-Z_\\$0-9-]*(?:\\.[a-zA-Z_\\$][a-zA-Z_\\$0-9-]*)*)(?:\\(([^\\(\\)]+)\\))?\\}";
    public static final ChainedVariableResolver VARIABLE_RESOLVER_ONLY_SYSTEM = new ChainedVariableResolver((VariableResolver)SystemPropertyResolver.INSTANCE, (VariableResolver)SystemVariableResolver.INSTANCE, new VariableResolver[]{EchoVariableResolver.INSTANCE});
    public static final ChainedVariableResolver VARIABLE_RESOLVER_SYSTEM_AND_INCLUDE = Variables.newResolverChainPlusCustomResolver(new VariableResolver[0]);
    static final Pattern PATTERN_VARIABLE = Pattern.compile("\\$\\{([a-zA-Z_\\$][a-zA-Z_\\$0-9-]*(?:\\.[a-zA-Z_\\$][a-zA-Z_\\$0-9-]*)*)(?:\\(([^\\(\\)]+)\\))?\\}");

    private Variables() {
    }

    public static String resolve(String stringWithVariables, VariableResolver variableResolver) {
        if (log.isTraceEnabled()) {
            log.trace("Attempting to resolve [{}]", (Object)stringWithVariables);
        }
        String oldInputString = null;
        String inputString = stringWithVariables;
        StringBuffer sb = null;
        do {
            Matcher matcher = PATTERN_VARIABLE.matcher(inputString);
            boolean replaced = false;
            while (matcher.find()) {
                String stringValue;
                String variable = matcher.group(1);
                String variableExt = matcher.group(2);
                Object value = null;
                if (variableExt == null) {
                    value = variableResolver.resolve(variable);
                } else {
                    String resolvedVariableExt = Variables.resolve(variableExt, variableResolver);
                    value = variableResolver.resolve(variable, resolvedVariableExt);
                }
                if (sb == null) {
                    sb = new StringBuffer(inputString.length());
                }
                if (inputString.equals(stringValue = Variables.asString(inputString, matcher.start(), variableResolver, value))) continue;
                try {
                    stringValue = MATCHER_ESCAPER.escape(stringValue);
                    matcher.appendReplacement(sb, stringValue);
                }
                catch (IllegalArgumentException | IndexOutOfBoundsException e) {
                    String msg = "Error occurred while resolving variable [" + variable + (String)(variableExt == null ? "" : ":" + variableExt) + "] in string [" + stringWithVariables + "] with value [" + stringValue + "]";
                    throw new IllegalArgumentException(msg, e);
                }
                replaced = true;
            }
            if (!replaced) break;
            matcher.appendTail(sb);
            oldInputString = inputString;
            inputString = sb.toString();
            sb.setLength(0);
        } while (!oldInputString.equals(inputString));
        return inputString;
    }

    private static String asString(String inputString, int valueStartPosition, VariableResolver variableResolver, Object value) {
        if (value instanceof Collection) {
            char c;
            if (log.isTraceEnabled()) {
                log.trace("Attempting to resolve collection [\n{}\n]", value);
            }
            StringBuilder sb = new StringBuilder();
            for (int j = valueStartPosition - 1; j >= 0 && (c = inputString.charAt(j)) == ' '; --j) {
                sb.append(c);
            }
            String indent = sb.toString();
            sb.delete(0, indent.length());
            int i = 0;
            for (Object unresolvedItem : (Collection)value) {
                if (i > 0) {
                    sb.append('\n').append(indent);
                }
                String unresolvedItemStr = Parameters.toStringOrBlank(unresolvedItem);
                String resolvedItem = Variables.resolve(unresolvedItemStr, variableResolver);
                sb.append(resolvedItem);
                ++i;
            }
            return sb.toString();
        }
        return Parameters.toStringOrBlank((Object)value);
    }

    public static Map<String, Object> resolveValues(String stringWithVariables, VariableResolver variableResolver) {
        Matcher matcher = PATTERN_VARIABLE.matcher(stringWithVariables);
        LinkedHashMap<String, Object> map = null;
        while (matcher.find()) {
            String variable = matcher.group(1);
            String variableExt = matcher.group(2);
            Object value = null;
            value = variableExt == null ? variableResolver.resolve(variable) : variableResolver.resolve(variable, variableExt);
            if (map == null) {
                map = new LinkedHashMap<String, Object>();
            }
            map.put(variable, value);
        }
        return map;
    }

    public static MapBasedVariableResolver loadVariables(Properties properties) {
        HashMap<String, String> map = new HashMap<String, String>(properties.size());
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            key = key == null ? null : Variables.resolve(key, (VariableResolver)VARIABLE_RESOLVER_ONLY_SYSTEM);
            String value = (String)entry.getValue();
            value = value == null ? null : Variables.resolve(value, (VariableResolver)VARIABLE_RESOLVER_ONLY_SYSTEM);
            map.put(key, value);
        }
        return new MapBasedVariableResolver(map);
    }

    public static void resolveVariables(InputStream templateSource, Properties optTemplateVariablesProps, OutputStream resolvedOutput) throws IOException {
        ChainedVariableResolver variableResolver;
        if (optTemplateVariablesProps != null) {
            variableResolver = Variables.loadVariables(optTemplateVariablesProps);
            variableResolver = Variables.newResolverChainPlusCustomResolver(new VariableResolver[]{variableResolver});
        } else {
            variableResolver = VARIABLE_RESOLVER_SYSTEM_AND_INCLUDE;
        }
        Variables.resolveVariables(templateSource, (VariableResolver)variableResolver, resolvedOutput);
    }

    public static File resolveVariables(FileSource templateSource, ConfigurationProperties configurationProperties) throws IOException {
        File source = new File(templateSource.getSource());
        File destination = Variables.createTempFile(source.getName());
        try (FileInputStream fis = new FileInputStream(source);
             FileOutputStream fos = new FileOutputStream(destination);){
            Variables.resolveVariables((InputStream)fis, configurationProperties, (OutputStream)fos);
        }
        return destination;
    }

    public static void resolveVariables(InputStream templateSource, ConfigurationProperties configurationProperties, OutputStream resolvedOutput) throws IOException {
        ConfigurationPropertiesVariableResolver configPropsVariableResolver = new ConfigurationPropertiesVariableResolver(configurationProperties);
        ChainedVariableResolver variableResolver = new ChainedVariableResolver((VariableResolver)configPropsVariableResolver, (VariableResolver)EchoVariableResolver.INSTANCE, new VariableResolver[0]);
        Variables.resolveVariables(templateSource, (VariableResolver)variableResolver, resolvedOutput);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File resolveVariables(String destinationFileSuffix, InputStream templateSource, ConfigurationProperties configurationProperties) throws IOException {
        File destination = Variables.createTempFile(destinationFileSuffix);
        try (FileOutputStream fos = new FileOutputStream(destination);){
            Variables.resolveVariables(templateSource, configurationProperties, (OutputStream)fos);
        }
        finally {
            if (templateSource != null) {
                templateSource.close();
            }
        }
        return destination;
    }

    public static ChainedVariableResolver newResolverChainPlusCustomResolver(VariableResolver ... customResolvers) {
        VariableResolver[] resolvers = new VariableResolver[3 + customResolvers.length];
        int i = 0;
        for (VariableResolver cr : customResolvers) {
            resolvers[i++] = cr;
        }
        resolvers[i++] = FileIncludeVariableResolver.INSTANCE;
        resolvers[i++] = CalendarVariableResolver.INSTANCE;
        resolvers[i] = EchoVariableResolver.INSTANCE;
        return new ChainedVariableResolver((VariableResolver)SystemPropertyResolver.INSTANCE, (VariableResolver)SystemVariableResolver.INSTANCE, resolvers);
    }

    private static void resolveVariables(InputStream templateSource, VariableResolver variableResolver, OutputStream resolvedOutput) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(templateSource, StandardCharsets.UTF_8.name()));
             PrintWriter writer = new PrintWriter(new OutputStreamWriter(resolvedOutput, StandardCharsets.UTF_8.name()));){
            String line;
            while ((line = reader.readLine()) != null) {
                try {
                    line = Variables.resolve(line, variableResolver);
                }
                catch (RuntimeException e) {
                    log.error("Error occurred while resolving variables in line [{}]", (Object)line, (Object)e);
                    throw e;
                }
                writer.println(line);
            }
        }
    }

    private static File createTempFile(String fileNameSuffix) throws IOException {
        File tempFile = File.createTempFile("tmp-", "-" + fileNameSuffix);
        tempFile.deleteOnExit();
        return tempFile;
    }
}

