/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.configuration.property.provider;

import com.appdynamics.common.util.configuration.property.provider.ReadOnlyConfiguration;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public abstract class ExtensionConfiguration
extends ReadOnlyConfiguration {
    private final String startWithPattern;
    private final int extensionStartIndex;
    private final Set<String> keys;

    public ExtensionConfiguration(String key) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)key), (Object)"key can't be blank");
        this.startWithPattern = key + "(";
        this.extensionStartIndex = key.length() + 1;
        this.keys = ImmutableSet.of((Object)key);
    }

    public boolean containsKey(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return false;
        }
        return key.startsWith(this.startWithPattern) && key.endsWith(")");
    }

    public Iterator<String> getKeys() {
        return this.keys.iterator();
    }

    @Nullable
    protected String getExtension(String key) {
        int keyLength = key.length();
        if (keyLength == 0 || key.charAt(keyLength - 1) != ')') {
            return null;
        }
        for (int i = 0; i < this.extensionStartIndex; ++i) {
            if (key.charAt(i) == this.startWithPattern.charAt(i)) continue;
            return null;
        }
        boolean isBlank = true;
        int extensionEndIndex = keyLength - 1;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = this.extensionStartIndex; i < extensionEndIndex; ++i) {
            char character = key.charAt(i);
            if (character != '(' && character != ')') {
                stringBuilder.append(character);
                if (Character.isWhitespace(character)) continue;
                isBlank = false;
                continue;
            }
            return null;
        }
        return !isBlank ? stringBuilder.toString() : null;
    }
}

