/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.configuration.property.provider;

import com.appdynamics.common.util.configuration.property.provider.ExtensionConfiguration;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalendarConfiguration
extends ExtensionConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CalendarConfiguration.class);
    private static final ConcurrentHashMap<String, DateTimeFormatter> DATE_TIME_FORMATS = new ConcurrentHashMap();
    private static final String CALENDAR_NOW_KEY = "calendar.now";

    public CalendarConfiguration() {
        super(CALENDAR_NOW_KEY);
    }

    public Object getProperty(String key) {
        String formatString = this.getExtension(key);
        if (formatString == null) {
            return null;
        }
        DateTimeFormatter fmt = DATE_TIME_FORMATS.get(formatString);
        if (fmt == null) {
            try {
                fmt = DateTimeFormat.forPattern((String)formatString);
            }
            catch (IllegalArgumentException e) {
                log.error("Error occurred while parsing date time format [{}]", (Object)formatString, (Object)e);
                return null;
            }
        }
        DATE_TIME_FORMATS.putIfAbsent(formatString, fmt);
        return DateTime.now().toString(fmt);
    }
}

