/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.configuration.property;

import com.appdynamics.common.util.configuration.ConfigurationException;
import com.google.common.base.Preconditions;
import com.singularity.ee.util.security.credentialstore.KeyStoreBasedEncryptionWrapper;
import com.singularity.ee.util.security.credentialstore.KeyStoreBasedEncryptionWrapperFactory;
import com.singularity.ee.util.security.credentialstore.exception.CryptoOperationFailureException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SecureCredentialResolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecureCredentialResolver.class);
    static final String SECURE_CREDENTIAL_KEYSTORE_FILE_NAME_CONFIG = "ad.secure.credential.store.filename";
    static final String SECURE_CREDENTIAL_KEYSTORE_PASSWORD_CONFIG = "ad.secure.credential.store.password";
    static final String SECURE_CREDENTIAL_KEYSTORE_FORMAT_CONFIG = "ad.secure.credential.store.format";
    static final String SECURE_CREDENTIAL_CONFIG_VALUE_PREFIX = "secure://";
    private final KeyStoreBasedEncryptionWrapper scsEncryptionWrapper;

    SecureCredentialResolver(String keyStoreFile, String obfuscatedKeyStorePassword, String keyStoreFormat) {
        Preconditions.checkNotNull((Object)keyStoreFile, (Object)"scs keystore file can't be null");
        Preconditions.checkNotNull((Object)obfuscatedKeyStorePassword, (Object)"scs keystore obfuscated password cant't be null");
        log.info("scs keystore format configured: {}", (Object)keyStoreFormat);
        try {
            this.scsEncryptionWrapper = StringUtils.isNotBlank((CharSequence)keyStoreFormat) ? new KeyStoreBasedEncryptionWrapperFactory().createWithObfuscatedPassword(keyStoreFile, obfuscatedKeyStorePassword, keyStoreFormat) : new KeyStoreBasedEncryptionWrapperFactory().createWithObfuscatedPassword(keyStoreFile, obfuscatedKeyStorePassword);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new ConfigurationException("Error occurred while trying to configure secure credential store", (Throwable)e);
        }
    }

    String decryptConfig(String propertyValue) {
        if (this.scsEncryptionWrapper == null || !SecureCredentialResolver.checkIfConfigEncrypted(propertyValue)) {
            return propertyValue;
        }
        try {
            return this.scsEncryptionWrapper.decryptCipherTextString(propertyValue.substring(SECURE_CREDENTIAL_CONFIG_VALUE_PREFIX.length()));
        }
        catch (CryptoOperationFailureException e) {
            throw new ConfigurationException("Error occurred while decrypting property/cipher text", (Throwable)e);
        }
    }

    static boolean checkIfConfigEncrypted(Object propertyValue) {
        if (!(propertyValue instanceof String)) {
            return false;
        }
        return String.valueOf(propertyValue).startsWith(SECURE_CREDENTIAL_CONFIG_VALUE_PREFIX);
    }
}

