/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.configuration.property;

import com.appdynamics.common.util.configuration.ConfigurationException;
import com.appdynamics.common.util.configuration.property.ConfigurationProperties;
import com.appdynamics.common.util.configuration.property.ConfigurationResolver;
import com.appdynamics.common.util.configuration.property.SecureCredentialResolver;
import com.appdynamics.common.util.configuration.property.provider.CalendarConfiguration;
import com.appdynamics.common.util.configuration.property.provider.CompositeConfiguration;
import com.appdynamics.common.util.configuration.property.provider.FileIncludeConfiguration;
import com.appdynamics.common.util.configuration.property.provider.SystemVariableConfiguration;
import com.google.common.base.Preconditions;
import com.netflix.config.ConcurrentMapConfiguration;
import com.netflix.config.ConfigurationManager;
import com.netflix.config.DynamicPropertyFactory;
import javax.annotation.concurrent.NotThreadSafe;
import lombok.Generated;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.EnvironmentConfiguration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class ConfigurationPropertiesBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigurationPropertiesBuilder.class);
    protected final CompositeConfiguration compositeConfig = new CompositeConfiguration();

    public ConfigurationPropertiesBuilder addSystemPropertiesResolver() {
        ConcurrentMapConfiguration systemPropertiesConfig = new ConcurrentMapConfiguration((Configuration)new SystemConfiguration());
        this.compositeConfig.addConfiguration((AbstractConfiguration)systemPropertiesConfig, "systemPropertiesConfig");
        log.info("Added system property resolver");
        return this;
    }

    public ConfigurationPropertiesBuilder addEnvironmentPropertiesResolver() {
        ConcurrentMapConfiguration environmentPropertiesConfig = new ConcurrentMapConfiguration((Configuration)new EnvironmentConfiguration());
        this.compositeConfig.addConfiguration((AbstractConfiguration)environmentPropertiesConfig, "environmentPropertiesConfig");
        log.info("Added environment property resolver");
        return this;
    }

    public ConfigurationPropertiesBuilder addSystemVariableResolver() {
        this.compositeConfig.addConfiguration(new SystemVariableConfiguration(), "systemVariableConfig");
        log.info("Added system variable resolver");
        return this;
    }

    public ConfigurationPropertiesBuilder addCalendarResolver() {
        this.compositeConfig.addConfiguration(new CalendarConfiguration(), "calendarConfig");
        log.info("Added calendar properties resolver");
        return this;
    }

    public ConfigurationPropertiesBuilder addFileIncludeResolver() {
        this.compositeConfig.addConfiguration(new FileIncludeConfiguration(), "fileIncludeConfig");
        log.info("Added file include resolver");
        return this;
    }

    public ConfigurationPropertiesBuilder addConfigurationResolver(ConfigurationResolver configurationResolver) {
        Preconditions.checkNotNull((Object)configurationResolver, (Object)"configurationResolver can't be null");
        String name = configurationResolver.getName();
        this.compositeConfig.addConfiguration(configurationResolver.getConfiguration(), name);
        log.info(String.format("Added configuration resolver [%s]", name));
        return this;
    }

    public ConfigurationPropertiesBuilder addPropertiesFileResolver(String propertiesFile) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)propertiesFile), (Object)"propertiesFile can't be blank");
        try {
            ConcurrentMapConfiguration propertiesConfiguration = new ConcurrentMapConfiguration((Configuration)new PropertiesConfiguration(propertiesFile));
            this.compositeConfig.addConfiguration((AbstractConfiguration)propertiesConfiguration, String.format("propertiesFileConfig:%s", propertiesFile));
            log.info("Added properties file resolver for [{}]", (Object)propertiesFile);
        }
        catch (org.apache.commons.configuration.ConfigurationException e) {
            log.error("Failed to initialize properties file resolver for [{}]", (Object)propertiesFile);
            throw new ConfigurationException((Throwable)e);
        }
        return this;
    }

    public ConfigurationPropertiesBuilder applySecureCredentialResolver() {
        Preconditions.checkNotNull((Object)this.compositeConfig, (Object)"compositeConfiguration can't be null");
        String keyStoreFile = this.compositeConfig.getString("ad.secure.credential.store.filename");
        String obfuscatedKeyStorePassword = this.compositeConfig.getString("ad.secure.credential.store.password");
        String keyStoreFormat = this.compositeConfig.getString("ad.secure.credential.store.format");
        if (StringUtils.isNotBlank((CharSequence)keyStoreFile) && StringUtils.isNotBlank((CharSequence)obfuscatedKeyStorePassword)) {
            log.debug("Secure Credentials Store is in use");
            SecureCredentialResolver secureCredentialResolver = new SecureCredentialResolver(keyStoreFile, obfuscatedKeyStorePassword, keyStoreFormat);
            this.compositeConfig.getKeys().forEachRemaining(key -> {
                if (SecureCredentialResolver.checkIfConfigEncrypted(this.compositeConfig.getProperty((String)key))) {
                    this.compositeConfig.setOverrideProperty((String)key, secureCredentialResolver.decryptConfig(this.compositeConfig.getString((String)key)));
                }
            });
        } else if (StringUtils.isNotBlank((CharSequence)keyStoreFile) ^ StringUtils.isNotBlank((CharSequence)obfuscatedKeyStorePassword)) {
            throw new ConfigurationException("Secure Credential Store keystore file or password is incorrect");
        }
        return this;
    }

    public ConfigurationProperties build() {
        System.setProperty("archaius.dynamicProperty.disableDefaultConfig", "true");
        ConfigurationManager.install((AbstractConfiguration)this.compositeConfig);
        return new ConfigurationProperties(DynamicPropertyFactory.getInstance());
    }
}

