/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.configuration;

import com.appdynamics.common.util.configuration.CommonReader;
import com.appdynamics.common.util.configuration.ConfigurationHelper;
import com.appdynamics.common.util.var.ChainedVariableResolver;
import com.appdynamics.common.util.var.MapBasedVariableResolver;
import com.appdynamics.common.util.var.VariableResolver;
import com.appdynamics.common.util.var.Variables;
import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheFactory;
import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.concurrent.ThreadSafe;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class Templates {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Templates.class);
    final MapBasedVariableResolver propertiesResolver;
    final Map<String, String> templates;
    final MustacheFactory mustacheFactory;
    final ConcurrentMap<String, Mustache> compiledTemplates;

    Templates(Map<String, String> templates) {
        this(templates, ConfigurationHelper.getProperties());
    }

    public Templates(Map<String, String> templates, Properties properties) {
        this.propertiesResolver = Variables.loadVariables(properties);
        this.templates = templates;
        this.mustacheFactory = new DefaultMustacheFactory();
        this.compiledTemplates = new ConcurrentHashMap<String, Mustache>();
    }

    public <T> T read(String templateName, Map<String, Object> variables, Class<T> readAsType) {
        String rawWithVariables = this.templates.get(templateName);
        if (rawWithVariables == null) {
            return null;
        }
        Mustache mustache = (Mustache)this.compiledTemplates.get(templateName);
        if (mustache == null) {
            mustache = this.mustacheFactory.compile((Reader)new StringReader(rawWithVariables), templateName);
            Mustache oldMustache = this.compiledTemplates.putIfAbsent(templateName, mustache);
            mustache = oldMustache == null ? mustache : oldMustache;
        }
        try (StringWriter writer = new StringWriter();){
            mustache.execute((Writer)writer, variables).flush();
            rawWithVariables = writer.toString();
            log.debug("The template [{}] has been expanded to [\n{}]", (Object)templateName, (Object)rawWithVariables);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ChainedVariableResolver chainResolver = Variables.newResolverChainPlusCustomResolver(new VariableResolver[]{this.propertiesResolver, new MapBasedVariableResolver(variables)});
        String rawTemplate = Variables.resolve(rawWithVariables, (VariableResolver)chainResolver);
        log.info("The following template will be used to create an instance of [{}] [\n{}]", (Object)readAsType.getName(), (Object)rawTemplate);
        try {
            return (T)CommonReader.readFrom(readAsType, (InputStream)new ByteArrayInputStream(rawTemplate.getBytes(Charsets.UTF_8)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

