/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.common.util.configuration;

import com.appdynamics.common.util.var.ChainedVariableResolver;
import com.appdynamics.common.util.var.MapBasedVariableResolver;
import com.appdynamics.common.util.var.VariableResolver;
import com.appdynamics.common.util.var.Variables;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigurationHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigurationHelper.class);
    public static final String PROP_APP_PROP_FILE_PATH = "ad.prop.file.path";

    private ConfigurationHelper() {
    }

    public static Properties getProperties() {
        Properties variableValues;
        String variableValuesPath = ConfigurationHelper.getPropertiesFileLocation();
        if (variableValuesPath == null) {
            variableValues = new Properties();
            log.warn("No properties file is available under the key [{}]", (Object)PROP_APP_PROP_FILE_PATH);
        } else {
            File variableValuesFile = new File(variableValuesPath);
            Preconditions.checkArgument((boolean)variableValuesFile.exists(), (Object)("The properties file that is supposed to be located at [" + variableValuesFile.getAbsolutePath() + "] does not exist"));
            variableValues = new Properties();
            try (FileInputStream fis = new FileInputStream(variableValuesFile);){
                variableValues.load(fis);
            }
            catch (IOException e) {
                Throwables.propagate((Throwable)e);
            }
            log.debug("Properties file [{}] will be used to resolve variables", (Object)variableValuesFile.getAbsolutePath());
        }
        return variableValues;
    }

    public static String resolveProperty(String propertyName, String defaultValue) {
        String configProperty = "${" + propertyName + "}";
        Properties properties = ConfigurationHelper.getProperties();
        String valueFromProperties = properties.getProperty(propertyName, defaultValue);
        Map<String, String> mapAsProperties = Collections.singletonMap(propertyName, valueFromProperties);
        ChainedVariableResolver resolver = Variables.newResolverChainPlusCustomResolver(new VariableResolver[]{new MapBasedVariableResolver(mapAsProperties)});
        return Variables.resolve(configProperty, (VariableResolver)resolver);
    }

    public static String getPropertiesFileLocation() {
        return System.getProperty(PROP_APP_PROP_FILE_PATH);
    }
}

