/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.voltron;

import com.appdynamics.voltron.AppLifecycleModule;
import com.appdynamics.voltron.Main;
import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrameworkBootstrap {
    private static final Logger log = LoggerFactory.getLogger(FrameworkBootstrap.class);
    private final List<Module> modules = new ArrayList<Module>();
    private Optional<Injector> parentInjector = Optional.absent();
    private boolean requireExplicitBindings;
    private Optional<? extends Class<? extends Main>> mainClass = Optional.absent();

    public FrameworkBootstrap requireExplictBindings() {
        this.requireExplicitBindings = true;
        return this;
    }

    public FrameworkBootstrap setParentInjector(@NonNull Injector parentInjector) {
        if (parentInjector == null) {
            throw new NullPointerException("parentInjector is marked non-null but is null");
        }
        this.parentInjector = Optional.of((Object)parentInjector);
        return this;
    }

    public FrameworkBootstrap add(Module module) {
        this.modules.add(module);
        return this;
    }

    public FrameworkBootstrap addAll(Collection<? extends Module> modules) {
        this.modules.addAll(modules);
        return this;
    }

    public void bindMain(Class<? extends Main> mainClass) {
        this.mainClass = Optional.of(mainClass);
    }

    private Injector createInjector(AppLifecycleModule lifecycleModule) {
        ArrayList<AbstractModule> modulesToUse = new ArrayList<AbstractModule>(this.modules.size() + 2);
        modulesToUse.add(lifecycleModule);
        modulesToUse.addAll(this.modules);
        if (this.mainClass.isPresent()) {
            modulesToUse.add(new MainBindingModule((Class)this.mainClass.get()));
        }
        if (this.requireExplicitBindings) {
            modulesToUse.add(new ExplicitBindingsModule());
        }
        if (this.parentInjector.isPresent()) {
            return ((Injector)this.parentInjector.get()).createChildInjector(modulesToUse);
        }
        return Guice.createInjector(modulesToUse);
    }

    public Context startAndRun() {
        Context context = this.start();
        log.debug("Starting application context");
        try {
            final Context finalContext = context;
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    finalContext.stop();
                }
            });
            Main main = (Main)context.getInjector().getInstance(Main.class);
            log.debug("Calling {} run method", (Object)main);
            main.run();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            context.stop();
        }
        return context;
    }

    public Context start() {
        log.debug("Starting framework");
        AppLifecycleModule lifecycleModule = new AppLifecycleModule();
        try {
            log.debug("Creating the injector");
            Injector injector = this.createInjector(lifecycleModule);
            log.debug("Created injector");
            return new Context(lifecycleModule, injector);
        }
        catch (Throwable t) {
            log.warn("Failed to start framework", t);
            lifecycleModule.stop();
            throw Throwables.propagate((Throwable)t);
        }
    }

    private static class MainBindingModule
    extends AbstractModule {
        private final Class<? extends Main> mainClass;

        public MainBindingModule(Class<? extends Main> mainClass) {
            this.mainClass = mainClass;
        }

        protected void configure() {
            this.bind(Main.class).to(this.mainClass);
        }
    }

    private static class ExplicitBindingsModule
    extends AbstractModule {
        private ExplicitBindingsModule() {
        }

        protected void configure() {
            this.binder().requireExplicitBindings();
        }
    }

    public static class Context {
        private final AppLifecycleModule lifecycleModule;
        private final Injector injector;

        public void stop() {
            this.lifecycleModule.stop();
        }

        public Context(AppLifecycleModule lifecycleModule, Injector injector) {
            this.lifecycleModule = lifecycleModule;
            this.injector = injector;
        }

        public AppLifecycleModule getLifecycleModule() {
            return this.lifecycleModule;
        }

        public Injector getInjector() {
            return this.injector;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Context)) {
                return false;
            }
            Context other = (Context)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AppLifecycleModule this$lifecycleModule = this.getLifecycleModule();
            AppLifecycleModule other$lifecycleModule = other.getLifecycleModule();
            if (this$lifecycleModule == null ? other$lifecycleModule != null : !((Object)((Object)this$lifecycleModule)).equals((Object)other$lifecycleModule)) {
                return false;
            }
            Injector this$injector = this.getInjector();
            Injector other$injector = other.getInjector();
            return !(this$injector == null ? other$injector != null : !this$injector.equals(other$injector));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Context;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AppLifecycleModule $lifecycleModule = this.getLifecycleModule();
            result = result * 59 + ($lifecycleModule == null ? 43 : ((Object)((Object)$lifecycleModule)).hashCode());
            Injector $injector = this.getInjector();
            result = result * 59 + ($injector == null ? 43 : $injector.hashCode());
            return result;
        }

        public String toString() {
            return "FrameworkBootstrap.Context(lifecycleModule=" + String.valueOf((Object)this.getLifecycleModule()) + ", injector=" + String.valueOf(this.getInjector()) + ")";
        }
    }

    public static class Factory {
        public FrameworkBootstrap make() {
            return new FrameworkBootstrap();
        }
    }
}

